/*
 * Decompiled with CFR 0.152.
 */
package net.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.cli.CommandException;
import net.cli.ICommandResultListener;

public class CommandExecutor {
    public static ProcessBuilder createProcessBuilder(String ... cmd) {
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.redirectErrorStream(true);
        return builder;
    }

    public static int execute(ProcessBuilder builder) throws CommandException {
        return CommandExecutor.execute(builder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized int execute(ProcessBuilder builder, ICommandResultListener listener) throws CommandException {
        Process process = null;
        BufferedReader reader = null;
        try {
            process = builder.start();
            if (builder.redirectErrorStream()) {
                String line;
                reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "CP850"));
                while ((line = reader.readLine()) != null) {
                    String string = line;
                    synchronized (string) {
                        System.err.println(line);
                        if (listener != null) {
                            listener.result(line);
                        }
                        line.notify();
                    }
                }
            }
            int n = process.waitFor();
            return n;
        }
        catch (Throwable cause) {
            throw new CommandException(cause);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (process != null) {
                process.destroy();
            }
        }
    }
}

