/*
 * Decompiled with CFR 0.152.
 */
package net.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;

public class HashUtils {
    public static String calcFileHash(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        FileInputStream fis = null;
        try {
            int b;
            fis = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((b = fis.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, b);
            }
        }
        catch (Throwable throwable) {
            HashUtils.closeQuietly(fis);
            throw throwable;
        }
        HashUtils.closeQuietly(fis);
        byte[] byteArray = messageDigest.digest();
        messageDigest.reset();
        messageDigest = null;
        return Base64.encodeBase64URLSafeString((byte[])byteArray);
    }

    public static String calcHash(byte[] data) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        byte[] byteArray = messageDigest.digest(data);
        messageDigest.reset();
        messageDigest = null;
        return Base64.encodeBase64URLSafeString((byte[])byteArray);
    }

    private static void closeQuietly(AutoCloseable x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

