/*
 * Decompiled with CFR 0.152.
 */
package net.cli;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class NetworkUtils {
    public static Collection<InterfaceAddress> getInterfaceAddresses() throws SocketException {
        ArrayList<InterfaceAddress> list = new ArrayList<InterfaceAddress>();
        ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        for (NetworkInterface networkInterface : interfaces) {
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                InetAddress inetAddress = interfaceAddress.getAddress();
                if (!inetAddress.isSiteLocalAddress()) continue;
                list.add(interfaceAddress);
            }
        }
        return list;
    }

    public static Collection<InetAddress> getAddressesByInterfaceAddress(InterfaceAddress interfaceAddress, int prefixLimit) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        Integer address = NetworkUtils.convert(interfaceAddress.getBroadcast());
        if (address != null && interfaceAddress.getNetworkPrefixLength() >= prefixLimit) {
            int mask;
            int i = mask = address & Integer.MIN_VALUE >> interfaceAddress.getNetworkPrefixLength() - 1;
            while (i <= address) {
                try {
                    list.add(NetworkUtils.convert(i));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return list;
    }

    private static Integer convert(InetAddress inetAddress) {
        byte[] byteArray;
        if (inetAddress != null && (byteArray = inetAddress.getAddress()) != null) {
            return (byteArray[0] & 0xFF) << 24 | (byteArray[1] & 0xFF) << 16 | (byteArray[2] & 0xFF) << 8 | byteArray[3] & 0xFF;
        }
        return null;
    }

    private static InetAddress convert(int address) throws UnknownHostException {
        StringBuilder sb = new StringBuilder();
        sb.append((address & 0xFF000000) >>> 24);
        sb.append('.');
        sb.append((address & 0xFF0000) >>> 16);
        sb.append('.');
        sb.append((address & 0xFF00) >>> 8);
        sb.append('.');
        sb.append(address & 0xFF);
        return InetAddress.getByName(new String(sb));
    }
}

