/*
 * Decompiled with CFR 0.152.
 */
package net.cli;

import java.io.IOException;
import java.util.Collection;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class RestClient {
    private final HttpClientBuilder builder = HttpClientBuilder.create();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String rest(String urlString) throws IOException {
        block3: {
            String string;
            HttpGet method = new HttpGet(urlString);
            method.addHeader("Connection", "close");
            method.addHeader("Cache-Control", "no-cache");
            method.addHeader("Accept", ContentType.TEXT_PLAIN.getMimeType());
            CloseableHttpClient client = null;
            CloseableHttpResponse response = null;
            try {
                client = this.builder.build();
                response = client.execute((HttpUriRequest)method);
                if (response.getStatusLine().getStatusCode() != 200) throw new IOException("status-code > " + String.valueOf(response.getStatusLine().getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) break block3;
                String json = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consumeQuietly((HttpEntity)entity);
                string = json;
            }
            catch (Throwable throwable) {
                RestClient.closeQuietly(response);
                RestClient.closeQuietly((AutoCloseable)client);
                throw throwable;
            }
            RestClient.closeQuietly((AutoCloseable)response);
            RestClient.closeQuietly((AutoCloseable)client);
            return string;
        }
        throw new IOException("entity is null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String rest(String urlString, Collection<NameValuePair> parameters) throws IOException {
        block3: {
            String string;
            HttpPost method = new HttpPost(urlString);
            method.addHeader("Connection", "close");
            method.addHeader("Cache-Control", "no-cache");
            method.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            CloseableHttpClient client = null;
            CloseableHttpResponse response = null;
            try {
                client = this.builder.build();
                response = client.execute((HttpUriRequest)method);
                if (response.getStatusLine().getStatusCode() != 200) throw new IOException("status-code > " + String.valueOf(response.getStatusLine().getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) break block3;
                String json = EntityUtils.toString((HttpEntity)entity);
                EntityUtils.consumeQuietly((HttpEntity)entity);
                string = json;
            }
            catch (Throwable throwable) {
                RestClient.closeQuietly(response);
                RestClient.closeQuietly((AutoCloseable)client);
                throw throwable;
            }
            RestClient.closeQuietly((AutoCloseable)response);
            RestClient.closeQuietly((AutoCloseable)client);
            return string;
        }
        throw new IOException("entity is null");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] rest(String urlString, Collection<Header> headers, Collection<NameValuePair> parameters) throws IOException {
        block4: {
            byte[] byArray;
            HttpPost method = new HttpPost(urlString);
            method.addHeader("Connection", "close");
            method.addHeader("Cache-Control", "no-cache");
            method.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            for (Header header : headers) {
                method.addHeader(header);
            }
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            CloseableHttpClient client = null;
            CloseableHttpResponse response = null;
            try {
                client = this.builder.build();
                response = client.execute((HttpUriRequest)method);
                if (response.getStatusLine().getStatusCode() != 200) throw new IOException("status-code > " + String.valueOf(response.getStatusLine().getStatusCode()));
                HttpEntity entity = response.getEntity();
                if (entity == null) break block4;
                byte[] json = EntityUtils.toByteArray((HttpEntity)entity);
                EntityUtils.consumeQuietly((HttpEntity)entity);
                byArray = json;
            }
            catch (Throwable throwable) {
                RestClient.closeQuietly(response);
                RestClient.closeQuietly((AutoCloseable)client);
                throw throwable;
            }
            RestClient.closeQuietly((AutoCloseable)response);
            RestClient.closeQuietly((AutoCloseable)client);
            return byArray;
        }
        throw new IOException("entity is null");
    }

    public static void closeQuietly(AutoCloseable x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

