/*
 * Decompiled with CFR 0.152.
 */
package net.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void loadDirectory(File file, File dir) throws IOException {
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            fis = new FileInputStream(file);
            zis = new ZipInputStream(fis);
            ZipUtils.loadDirectory(zis, dir.getAbsolutePath(), dir);
        }
        finally {
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void storeDirectory(File file, File dir) throws IOException {
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(file);
            zos = new ZipOutputStream(fos);
            ZipUtils.storeDirectory(zos, dir.getAbsolutePath(), dir);
            zos.flush();
            fos.flush();
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void loadDirectory(ZipInputStream zis, String path, File file) throws IOException {
        ZipEntry e;
        while ((e = zis.getNextEntry()) != null) {
            File f = new File(path, e.getName());
            if (e.isDirectory()) {
                f.mkdirs();
                continue;
            }
            if (f.getParentFile() != null) {
                f.getParentFile().mkdirs();
            }
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                ZipUtils.copyStream(zis, fos);
                fos.flush();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void storeDirectory(ZipOutputStream zos, String path, File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                ZipUtils.storeDirectory(zos, path, f);
                ++n2;
            }
        } else {
            String s = file.getAbsolutePath().substring(path.length());
            if (s.length() > 0) {
                ZipEntry e = new ZipEntry(s.substring(1));
                zos.putNextEntry(e);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    ZipUtils.copyStream(fis, zos);
                    zos.flush();
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                zos.closeEntry();
            }
        }
    }

    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[8192];
        while ((len = input.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
    }
}

