/*
 * Decompiled with CFR 0.152.
 */
package net.cli.jre.os.mac;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.cli.CommandException;
import net.cli.jre.AbstractJRE;

public class MacJRE
extends AbstractJRE {
    private static final String DEFAULT_PATH = "/timeglobe";
    private static final String MAC_SPECIAL_PATH = "/Users/Shared/timeglobe";

    @Override
    public boolean spawnJRE(String classPath, String mainClass, String[] parameters) throws FileNotFoundException, CommandException {
        File dir;
        File defaultFile = new File(DEFAULT_PATH);
        File macSpecialFile = new File(MAC_SPECIAL_PATH);
        if (macSpecialFile.exists()) {
            dir = macSpecialFile;
        } else if (defaultFile.exists()) {
            dir = defaultFile;
        } else {
            throw new CommandException("timeglobe environment not exists");
        }
        String path = dir.getAbsolutePath();
        String launchPath = String.valueOf(path) + "/launch";
        String javaPath = String.valueOf(launchPath) + "/jre/bin/java";
        File f = new File(javaPath);
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath());
        }
        String cmd = String.valueOf(f.getAbsolutePath()) + " -cp " + classPath + " " + mainClass;
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            cmd = String.valueOf(cmd) + " " + p;
            ++n2;
        }
        System.err.println("SPAWN " + cmd);
        ProcessBuilder builder = new ProcessBuilder("bash", "-c", cmd);
        try {
            builder.start();
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
        return true;
    }
}

