/*
 * Decompiled with CFR 0.152.
 */
package net.cli.service.os.windows;

import net.cli.CommandException;
import net.cli.CommandExecutor;
import net.cli.service.AbstractService;
import net.cli.service.os.windows.IWindowsService;

public class WindowsService
extends AbstractService
implements IWindowsService {
    private String processorArchitecture;

    public WindowsService(String serviceName, int architecture) {
        super(serviceName, architecture);
    }

    @Override
    public boolean startService() throws CommandException {
        String cmd = "net start " + super.getServiceName();
        ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", cmd);
        builder.redirectErrorStream(true);
        return CommandExecutor.execute(builder, super.getListener()) == 0;
    }

    @Override
    public boolean stopService() throws CommandException {
        String cmd = "net stop " + super.getServiceName();
        ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", cmd);
        builder.redirectErrorStream(true);
        return CommandExecutor.execute(builder, super.getListener()) == 0;
    }

    public String getProcessorArchitecture() {
        return this.processorArchitecture;
    }
}

