/*
 * Decompiled with CFR 0.152.
 */
package net.cli.service.os.windows.tomcat;

import java.io.File;
import net.cli.CommandException;
import net.cli.CommandExecutor;
import net.cli.service.os.windows.WindowsService;
import net.cli.service.tomcat.ITomcatService;

public class TomcatWindowsService
extends WindowsService
implements ITomcatService {
    private File serviceDir;

    public TomcatWindowsService(String serviceName, int architecture, File serviceDir) {
        super(serviceName, architecture);
        this.serviceDir = serviceDir;
    }

    @Override
    public boolean installService(File runtimeDir, Integer jvmMs, Integer jvmMx) throws CommandException {
        File file = new File(new File(this.serviceDir.getAbsolutePath(), "bin"), "tomcat.exe");
        StringBuilder sb = new StringBuilder();
        sb.append(" --DisplayName=" + super.getServiceName());
        sb.append(" --Install=" + file.getAbsolutePath());
        sb.append(" --StartMode=jvm");
        sb.append(" --StopMode=jvm");
        sb.append(" --StartClass=org.apache.catalina.startup.Bootstrap");
        sb.append(" --StartParams=start");
        sb.append(" --StartPath=" + this.serviceDir.getAbsolutePath());
        sb.append(" --StopClass=org.apache.catalina.startup.Bootstrap");
        sb.append(" --StopParams=stop");
        sb.append(" --StopPath=" + this.serviceDir.getAbsolutePath());
        sb.append(" --Startup=auto");
        switch (super.getArchitecture()) {
            case 32: {
                sb.append(" --Jvm=" + new File(new File(runtimeDir, "bin/client"), "jvm.dll").getAbsolutePath());
                break;
            }
            case 64: {
                sb.append(" --Jvm=" + new File(new File(runtimeDir, "bin/server"), "jvm.dll").getAbsolutePath());
                break;
            }
            default: {
                throw new CommandException("Architecture unknown");
            }
        }
        sb.append(" --Classpath=" + this.serviceDir.getAbsolutePath() + "\\bin\\bootstrap.jar;" + this.serviceDir.getAbsolutePath() + "\\bin\\tomcat-juli.jar");
        sb.append(" --JvmOptions=-Dcatalina.home=" + this.serviceDir.getAbsolutePath() + ";-Dcatalina.base=" + this.serviceDir.getAbsolutePath() + ";-Djava.endorsed.dirs=" + this.serviceDir.getAbsolutePath() + "\\common\\endorsed;-Djava.io.tmpdir=" + this.serviceDir.getAbsolutePath() + "\\temp;-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager;-Djava.util.logging.config.file=" + this.serviceDir.getAbsolutePath() + "\\conf\\logging.properties;-Djava.awt.headless=true;");
        sb.append(" --LogPath=\"" + this.serviceDir.getAbsolutePath() + "\\logs\"");
        sb.append(" --JvmMs=" + jvmMs);
        sb.append(" --JvmMx=" + jvmMx);
        sb.append(" --StdOutput=auto");
        sb.append(" --StdError=auto");
        String cmd = String.valueOf(file.getAbsolutePath()) + " //IS//" + super.getServiceName() + new String(sb);
        ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", cmd);
        builder.redirectErrorStream(true);
        return CommandExecutor.execute(builder, super.getListener()) == 0;
    }

    @Override
    public boolean removeService() throws CommandException {
        File file = new File(new File(this.serviceDir.getAbsolutePath(), "bin"), "tomcat.exe");
        String cmd = String.valueOf(file.getAbsolutePath()) + " //DS//" + super.getServiceName();
        ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", cmd);
        builder.redirectErrorStream(true);
        return CommandExecutor.execute(builder, super.getListener()) == 0;
    }
}

