/*
 * Decompiled with CFR 0.152.
 */
package net.launcher.service;

import com.google.gson.Gson;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Session;
import net.cli.CliUtils;
import net.cli.CommandException;
import net.cli.CommandExecutor;
import net.cli.ICommandResultListener;
import net.cli.InetAddressPortScanner;
import net.cli.InetAddressScanner;
import net.cli.NetworkUtils;
import net.cli.OperatingSystem;
import net.cli.RestClient;
import net.cli.jre.IJRE;
import net.cli.jre.JREUtils;
import net.launcher.service.ZipUtils;
import net.launcher.service.client.FileDownloadClient;
import net.launcher.service.client.FileServiceClient;
import net.launcher.service.timeglobe.TimeglobePosUpdate;
import net.obj.rc.beans.RcLoginMessage;
import net.obj.rc.beans.RcMessage;
import net.obj.rc.beans.payload.IRcTaskManager;
import net.obj.rc.beans.payload.RcpCommandResponse;
import net.obj.rc.beans.payload.RcpDeleteDirectoryCommand;
import net.obj.rc.beans.payload.RcpDeleteFileCommand;
import net.obj.rc.beans.payload.RcpDownloadFileCommand;
import net.obj.rc.beans.payload.RcpExecuteCommand;
import net.obj.rc.beans.payload.RcpExistsFileCommand;
import net.obj.rc.beans.payload.RcpHashFileCommand;
import net.obj.rc.beans.payload.RcpListFilesCommand;
import net.obj.rc.beans.payload.RcpLoopbackAddressCommand;
import net.obj.rc.beans.payload.RcpMkdirCommand;
import net.obj.rc.beans.payload.RcpMkdirsCommand;
import net.obj.rc.beans.payload.RcpNetworkAddressCommand;
import net.obj.rc.beans.payload.RcpNetworkAddressesCommand;
import net.obj.rc.beans.payload.RcpNetworkPortScanCommand;
import net.obj.rc.beans.payload.RcpNetworkScanCommand;
import net.obj.rc.beans.payload.RcpOperatingSystemCommand;
import net.obj.rc.beans.payload.RcpReadFileCommand;
import net.obj.rc.beans.payload.RcpRebootCommand;
import net.obj.rc.beans.payload.RcpRedirectPostRequestCommand;
import net.obj.rc.beans.payload.RcpRedirectUrlCommand;
import net.obj.rc.beans.payload.RcpRenameFileCommand;
import net.obj.rc.beans.payload.RcpRespawnCommand;
import net.obj.rc.beans.payload.RcpSetUniqueId;
import net.obj.rc.beans.payload.RcpShowFileCommand;
import net.obj.rc.beans.payload.RcpTask;
import net.obj.rc.beans.payload.RcpUnzipFileCommand;
import net.obj.rc.beans.payload.RcpWriteFileCommand;
import net.obj.rc.client.IRcMessageListener;
import net.obj.rc.client.RcClient;
import net.obj.rc.executor.RcLocalExecutor;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.tomcat.util.codec.binary.Base64;

@WebServlet(urlPatterns={"/rest/*"}, loadOnStartup=1)
public class LauncherService
extends HttpServlet
implements IRcMessageListener,
IRcTaskManager {
    private static final long serialVersionUID = 1L;
    private static final String version = "2.0.1";
    private static LauncherUpdate launcherUpdate = null;
    private static RcClient rcClient = null;
    private static RcLocalExecutor executor = null;
    private static TimeglobePosUpdate timeglobePosUpdate = null;
    private Gson gson = new Gson();
    private Vector<RcpTask> rcpTasks = new Vector();

    private RcLoginMessage getRcLogin() {
        RcLoginMessage rcLogin = null;
        String uniqueId = null;
        File dir = new File(System.getProperty("catalina.base"));
        String fn = this.getProperty("config-properties-file", null);
        if (fn != null) {
            File file = new File(dir, fn);
            Properties properties = this.loadProperties(file);
            uniqueId = properties.getProperty("unique.id");
            if (uniqueId != null) {
                rcLogin = new RcLoginMessage();
                rcLogin.setUniqueId(uniqueId);
                rcLogin.setVersion(version);
            } else {
                String customerCd = properties.getProperty("customer_cd");
                String siteCd = properties.getProperty("site_cd");
                String siteNm = properties.getProperty("site_nm");
                String stationCd = properties.getProperty("station_cd");
                String stationNm = properties.getProperty("station_nm");
                if (customerCd != null && siteCd != null && siteNm != null && stationCd != null && stationNm != null) {
                    rcLogin = new RcLoginMessage();
                    rcLogin.setCustomerCd(customerCd);
                    rcLogin.setSiteCd(siteCd);
                    rcLogin.setSiteNm(siteNm);
                    rcLogin.setStationCd(stationCd);
                    rcLogin.setStationNm(stationNm);
                    rcLogin.setVersion(version);
                }
            }
        }
        return rcLogin;
    }

    private void storeRcLogin(String uniqueId) {
        String fn = this.getProperty("config-properties-file", null);
        if (fn != null) {
            File dir = new File(System.getProperty("catalina.base"));
            File file = new File(dir, fn);
            Properties properties = new Properties();
            properties.setProperty("unique.id", uniqueId);
            this.storeProperties(file, properties);
        }
    }

    public void init() throws ServletException {
        super.init();
        RcLoginMessage rcLogin = this.getRcLogin();
        if (rcLogin != null) {
            rcClient = new RcClient(this.getProperty("rc-service-ws-uri", null), rcLogin, this);
            rcClient.start();
        }
        launcherUpdate = new LauncherUpdate();
        launcherUpdate.start();
        executor = new RcLocalExecutor();
        timeglobePosUpdate = new TimeglobePosUpdate(executor);
        timeglobePosUpdate.start();
    }

    private Properties loadProperties(File file) {
        Properties properties;
        block5: {
            properties = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    properties.load(fis);
                }
                catch (Exception cause) {
                    cause.printStackTrace();
                    LauncherService.closeQuietly(fis);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                LauncherService.closeQuietly(fis);
                throw throwable;
            }
            LauncherService.closeQuietly(fis);
        }
        return properties;
    }

    private void storeProperties(File file, Properties properties) {
        block5: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    properties.store(fos, "");
                }
                catch (Exception cause) {
                    cause.printStackTrace();
                    LauncherService.closeQuietly(fos);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                LauncherService.closeQuietly(fos);
                throw throwable;
            }
            LauncherService.closeQuietly(fos);
        }
    }

    public String getProperty(String key, String defaultValue) {
        try {
            Object value;
            InitialContext c = new InitialContext();
            Object o = c.lookup("java:comp/env");
            if (o instanceof Context && (value = ((Context)o).lookup(key)) != null) {
                return value.toString();
            }
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return defaultValue;
    }

    public static String calcFileHash(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
        FileInputStream fis = null;
        try {
            int b;
            fis = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((b = fis.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, b);
            }
        }
        catch (Throwable throwable) {
            LauncherService.closeQuietly(fis);
            throw throwable;
        }
        LauncherService.closeQuietly(fis);
        byte[] byteArray = messageDigest.digest();
        messageDigest.reset();
        messageDigest = null;
        return Base64.encodeBase64URLSafeString((byte[])byteArray);
    }

    private String getRemoteHash(String remotePath) throws IOException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        FileServiceClient client = new FileServiceClient(this.getProperty("file-service-url", null));
        return client.getRemoteHash(remotePath);
    }

    private String downloadFile(File localTempFile, String url) throws IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        FileDownloadClient client = new FileDownloadClient();
        String hash = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(localTempFile);
            hash = client.download(url, fos);
        }
        catch (Throwable throwable) {
            LauncherService.closeQuietly(fos);
            throw throwable;
        }
        LauncherService.closeQuietly(fos);
        return hash;
    }

    private String downloadRemoteFile(File localTempFile, String remotePath) throws IOException, NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        FileServiceClient client = new FileServiceClient(this.getProperty("file-service-url", null));
        String hash = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(localTempFile);
            hash = client.download(remotePath, fos);
        }
        catch (Throwable throwable) {
            LauncherService.closeQuietly(fos);
            throw throwable;
        }
        LauncherService.closeQuietly(fos);
        return hash;
    }

    private boolean deleteCascade(File f) {
        if (f.isDirectory()) {
            File[] af;
            File[] fileArray = af = f.listFiles();
            int n = af.length;
            int n2 = 0;
            while (n2 < n) {
                File cf = fileArray[n2];
                if (!cf.getName().equals(".") && !cf.getName().equals("..")) {
                    if (cf.isFile()) {
                        cf.delete();
                    }
                    if (cf.isDirectory()) {
                        this.deleteCascade(cf);
                    }
                }
                ++n2;
            }
        }
        return f.delete();
    }

    public void unzip(File file, File dir, String fileName) throws IOException {
        FileInputStream fis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry zipEntry;
            fis = new FileInputStream(file);
            zis = new ZipInputStream(fis);
            while ((zipEntry = zis.getNextEntry()) != null) {
                this.unzip(zis, zipEntry, dir, fileName);
            }
        }
        catch (Throwable throwable) {
            LauncherService.closeQuietly(zis);
            LauncherService.closeQuietly(fis);
            throw throwable;
        }
        LauncherService.closeQuietly(zis);
        LauncherService.closeQuietly(fis);
    }

    public void unzip(InputStream stream, ZipEntry entry, File dir, String fileName) throws IOException {
        String fn = entry.getName();
        if (!fn.endsWith(fileName)) {
            return;
        }
        File file = new File(dir, fileName);
        if (entry.isDirectory()) {
            file.mkdirs();
        } else {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fos = null;
            try {
                int b;
                fos = new FileOutputStream(file);
                byte[] buffer = new byte[8192];
                while ((b = stream.read(buffer)) != -1) {
                    fos.write(buffer, 0, b);
                }
                fos.flush();
            }
            catch (Throwable throwable) {
                LauncherService.closeQuietly(fos);
                throw throwable;
            }
            LauncherService.closeQuietly(fos);
        }
    }

    public void replaceDir(File srcDir, File destDir) throws IOException {
        if (destDir.exists()) {
            this.deleteCascade(destDir);
        }
        if (!destDir.exists()) {
            srcDir.renameTo(destDir);
        }
    }

    private boolean processRest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getRequestURI().startsWith(String.valueOf(super.getServletContext().getContextPath()) + "/rest")) {
            String command = request.getRequestURI().substring((String.valueOf(super.getServletContext().getContextPath()) + "/rest").length());
            if (command.isEmpty()) {
                command = "/";
            }
            if (command.startsWith("/") && command.split("/").length > 1) {
                String function = command.split("/")[1];
                if (function.equals("update")) {
                    launcherUpdate.forceUpdate();
                    return true;
                }
                if (function.equals("timeglobe") && command.split("/").length > 2 && command.split("/")[2].equals("update") && command.split("/").length > 3 && command.split("/")[3].equals("pos")) {
                    TimeglobePosUpdate.UpdateWorker updateWorker = timeglobePosUpdate.getUpdateWorker();
                    TimeglobePosUpdate.UpdateState updateState = updateWorker.getUpdateState();
                    if (command.split("/").length > 4) {
                        if (command.split("/")[4].equals("check")) {
                            response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
                            response.setContentType(ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8).getMimeType());
                            JsonWriter writer = new JsonWriter((Writer)response.getWriter());
                            try {
                                writer.setHtmlSafe(true);
                                writer.setIndent("\t");
                                writer.beginObject();
                                writer.name("state");
                                writer.value(updateState.toString());
                                writer.name("locked");
                                writer.value(updateState.isLocked());
                                writer.endObject();
                                writer.flush();
                                return true;
                            }
                            catch (IOException ioex) {
                                response.sendError(500, ioex.getMessage());
                                return true;
                            }
                            finally {
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        if (command.split("/")[4].equals("invoke")) {
                            response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
                            response.setContentType(ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8).getMimeType());
                            JsonWriter writer = new JsonWriter((Writer)response.getWriter());
                            try {
                                writer.setHtmlSafe(true);
                                writer.setIndent("\t");
                                writer.beginObject();
                                writer.name("state");
                                writer.value(updateState.toString());
                                writer.name("invoked");
                                writer.value(updateWorker.invokeUpdate());
                                writer.endObject();
                                writer.flush();
                                return true;
                            }
                            catch (IOException ioex) {
                                response.sendError(500, ioex.getMessage());
                                return true;
                            }
                            finally {
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                        if (command.split("/")[4].equals("path")) {
                            response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
                            response.setContentType(ContentType.APPLICATION_JSON.withCharset(StandardCharsets.UTF_8).getMimeType());
                            JsonWriter writer = new JsonWriter((Writer)response.getWriter());
                            try {
                                writer.setHtmlSafe(true);
                                writer.setIndent("\t");
                                writer.beginObject();
                                writer.name("url");
                                writer.value(updateWorker.readPosSatellitePath());
                                writer.name("tennantNo");
                                writer.value((Number)updateWorker.readTennantNo());
                                writer.name("businessunitNo");
                                writer.value((Number)updateWorker.readBusinessunitNo());
                                writer.name("saloonNo");
                                writer.value((Number)updateWorker.readSaloonNo());
                                writer.name("posSatellitePath");
                                writer.value(updateWorker.readPosSatellitePath());
                                writer.name("posSatelliteAdminPath");
                                writer.value(updateWorker.readPosSatelliteAdminPath());
                                writer.endObject();
                                writer.flush();
                                return true;
                            }
                            catch (IOException ioex) {
                                response.sendError(500, ioex.getMessage());
                                return true;
                            }
                            finally {
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        }
                    }
                }
                response.sendError(501);
                return true;
            }
            response.sendError(500);
            return true;
        }
        return false;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.processRest(request, response)) {
            return;
        }
        response.sendError(204);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (timeglobePosUpdate != null) {
            timeglobePosUpdate.shutdown();
            timeglobePosUpdate = null;
        }
        Vector<RcpTask> vector = this.rcpTasks;
        synchronized (vector) {
            for (RcpTask art : this.rcpTasks) {
                art.stopTask("service destroy() invoked");
            }
        }
        if (rcClient != null) {
            rcClient.shutdown();
            rcClient = null;
        }
        if (launcherUpdate != null) {
            launcherUpdate.shutDown();
            launcherUpdate = null;
        }
        super.destroy();
    }

    @Override
    public void processMessage(Session session, RcMessage rcMessage) throws Exception {
        String sp;
        String[] asp;
        String p = rcMessage.getPayload();
        if (p != null && (asp = (sp = p.replace('.', '\t')).split("\t")).length == 2) {
            Class<?> cls;
            String className = new String(Base64.decodeBase64((byte[])asp[0].getBytes()));
            String json = new String(Base64.decodeBase64((byte[])asp[1].getBytes()));
            Object obj = this.gson.fromJson(json, cls = Class.forName(className));
            if (obj != null) {
                if (obj instanceof RcpTask) {
                    RcpTask rcpTask = (RcpTask)obj;
                    rcpTask.setRcTaskManager(this);
                    rcpTask.setToSessionId(rcMessage.getFromSessionId());
                    rcpTask.setPayloadId(rcMessage.getPayloadId());
                    this.startRcpTask(rcpTask);
                } else if (obj instanceof RcpSetUniqueId) {
                    RcpSetUniqueId rcpSetUniqueId = (RcpSetUniqueId)obj;
                    if (rcpSetUniqueId.getUniqueId() != null) {
                        this.storeRcLogin(rcpSetUniqueId.getUniqueId());
                    }
                } else if (obj instanceof RcpShowFileCommand) {
                    RcpShowFileCommand rcpCommand = (RcpShowFileCommand)obj;
                    if (rcpCommand.getPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.showFile(rcpCommand.getPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpListFilesCommand) {
                    RcpListFilesCommand rcpCommand = (RcpListFilesCommand)obj;
                    if (rcpCommand.getPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.listFiles(rcpCommand.getPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpMkdirCommand) {
                    RcpMkdirCommand rcpCommand = (RcpMkdirCommand)obj;
                    if (rcpCommand.getPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.mkdirFile(rcpCommand.getPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpMkdirsCommand) {
                    RcpMkdirsCommand rcpCommand = (RcpMkdirsCommand)obj;
                    if (rcpCommand.getPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.mkdirsFile(rcpCommand.getPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpExistsFileCommand) {
                    RcpExistsFileCommand rcpCommand = (RcpExistsFileCommand)obj;
                    if (rcpCommand.getPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.existsFile(rcpCommand.getPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpDeleteFileCommand) {
                    RcpDeleteFileCommand rcpCommand = (RcpDeleteFileCommand)obj;
                    if (rcpCommand.getPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.deleteFile(rcpCommand.getPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpDeleteDirectoryCommand) {
                    RcpDeleteDirectoryCommand rcpCommand = (RcpDeleteDirectoryCommand)obj;
                    if (rcpCommand.getPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.deleteDirectory(rcpCommand.getPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpRenameFileCommand) {
                    RcpRenameFileCommand rcpCommand = (RcpRenameFileCommand)obj;
                    if (rcpCommand.getSourcePath() != null && rcpCommand.getTargetPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.renameFile(rcpCommand.getSourcePath(), rcpCommand.getTargetPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpUnzipFileCommand) {
                    RcpUnzipFileCommand rcpCommand = (RcpUnzipFileCommand)obj;
                    if (rcpCommand.getSourcePath() != null && rcpCommand.getTargetPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.unzipFile(rcpCommand.getSourcePath(), rcpCommand.getTargetPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpWriteFileCommand) {
                    RcpWriteFileCommand rcpCommand = (RcpWriteFileCommand)obj;
                    if (rcpCommand.getSourcePath() != null && rcpCommand.getByteArray() != null) {
                        RcpCommandResponse rcpCommandResponse = this.writeFile(rcpCommand.getSourcePath(), rcpCommand.getByteArray());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpReadFileCommand) {
                    RcpReadFileCommand rcpCommand = (RcpReadFileCommand)obj;
                    if (rcpCommand.getSourcePath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.readFile(rcpCommand.getSourcePath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpRebootCommand) {
                    RcpRebootCommand rcpCommand = (RcpRebootCommand)obj;
                    if (rcpCommand.getSecret() != null && rcpCommand.getSecret().equals("goheim")) {
                        RcpCommandResponse rcpCommandResponse = this.reboot();
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpRespawnCommand) {
                    RcpRespawnCommand rcpCommand = (RcpRespawnCommand)obj;
                    RcpCommandResponse rcpCommandResponse = this.respawn();
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpDownloadFileCommand) {
                    RcpDownloadFileCommand rcpCommand = (RcpDownloadFileCommand)obj;
                    if (rcpCommand.getPath() != null && rcpCommand.getUrl() != null) {
                        RcpCommandResponse rcpCommandResponse = this.downloadFile(rcpCommand.getPath(), rcpCommand.getUrl());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpHashFileCommand) {
                    RcpHashFileCommand rcpCommand = (RcpHashFileCommand)obj;
                    if (rcpCommand.getPath() != null) {
                        RcpCommandResponse rcpCommandResponse = this.hashFile(rcpCommand.getPath());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpExecuteCommand) {
                    RcpExecuteCommand rcpCommand = (RcpExecuteCommand)obj;
                    if (rcpCommand.getCommand() != null) {
                        RcpCommandResponse rcpCommandResponse = this.executeCmd(rcpCommand.getCommand());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpRedirectUrlCommand) {
                    RcpRedirectUrlCommand rcpCommand = (RcpRedirectUrlCommand)obj;
                    if (rcpCommand.getRedirectUrl() != null) {
                        RcpCommandResponse rcpCommandResponse = this.redirectUrl(rcpCommand.getRedirectUrl());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpRedirectPostRequestCommand) {
                    RcpRedirectPostRequestCommand rcpCommand = (RcpRedirectPostRequestCommand)obj;
                    if (rcpCommand.getRedirectUrl() != null) {
                        RcpCommandResponse rcpCommandResponse = this.redirectPostRequest(rcpCommand.getRedirectUrl(), rcpCommand.getRedirectHeaders(), rcpCommand.getRedirectParameters());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpOperatingSystemCommand) {
                    RcpOperatingSystemCommand rcpCommand = (RcpOperatingSystemCommand)obj;
                    RcpCommandResponse rcpCommandResponse = this.getOperatingSystem();
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpLoopbackAddressCommand) {
                    RcpLoopbackAddressCommand rcpCommand = (RcpLoopbackAddressCommand)obj;
                    RcpCommandResponse rcpCommandResponse = this.getLoopbackAddress();
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpNetworkAddressCommand) {
                    RcpNetworkAddressCommand rcpCommand = (RcpNetworkAddressCommand)obj;
                    RcpCommandResponse rcpCommandResponse = this.getNetworkAddress();
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpNetworkAddressesCommand) {
                    RcpNetworkAddressesCommand rcpCommand = (RcpNetworkAddressesCommand)obj;
                    RcpCommandResponse rcpCommandResponse = this.getNetworkAddresses();
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpNetworkScanCommand) {
                    RcpNetworkScanCommand rcpCommand = (RcpNetworkScanCommand)obj;
                    if (rcpCommand.getTimeout() > 0) {
                        RcpCommandResponse rcpCommandResponse = this.getNetworkScan(rcpCommand.getTimeout());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                } else if (obj instanceof RcpNetworkPortScanCommand) {
                    RcpNetworkPortScanCommand rcpCommand = (RcpNetworkPortScanCommand)obj;
                    if (rcpCommand.getPort() > 0 && rcpCommand.getPort() < 65535 && rcpCommand.getTimeout() > 0) {
                        RcpCommandResponse rcpCommandResponse = this.getNetworkPortScan(rcpCommand.getPort(), rcpCommand.getTimeout());
                        RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                        rcClient.sendMessage(responseMessage);
                        return;
                    }
                    RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage("bad request");
                    RcMessage responseMessage = this.createRcpResponseMessage(rcMessage.getPayloadId(), rcpCommandResponse);
                    rcClient.sendMessage(responseMessage);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRcpTask(RcpTask rcpTask) {
        Vector<RcpTask> vector = this.rcpTasks;
        synchronized (vector) {
            this.rcpTasks.add(rcpTask);
        }
        Thread t = new Thread(rcpTask);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rcpTaskEnded(RcpTask rcpTask) {
        Vector<RcpTask> vector = this.rcpTasks;
        synchronized (vector) {
            this.rcpTasks.remove(rcpTask);
        }
    }

    @Override
    public void reportProgress(String toSessionId, Integer payloadId, String message) {
        RcMessage rcMessage = new RcMessage();
        rcMessage.setToSessionId(toSessionId);
        String pay1 = String.class.getName();
        String pay2 = this.gson.toJson((Object)message);
        rcMessage.setPayloadId(payloadId);
        rcMessage.setPayload(String.valueOf(Base64.encodeBase64URLSafeString((byte[])pay1.getBytes())) + "." + Base64.encodeBase64URLSafeString((byte[])pay2.getBytes()));
        rcClient.sendMessage(rcMessage);
    }

    public RcMessage createRcpResponseMessage(Integer payloadId, RcpCommandResponse rcpCommandResponse) {
        RcMessage rcMessage = new RcMessage();
        rcMessage.setPayloadId(payloadId);
        Gson gson = new Gson();
        String pay = gson.toJson((Object)rcpCommandResponse);
        rcMessage.setPayload(String.valueOf(Base64.encodeBase64URLSafeString((byte[])RcpCommandResponse.class.getName().getBytes())) + "." + Base64.encodeBase64URLSafeString((byte[])pay.getBytes()));
        return rcMessage;
    }

    private String convertThrowable(Throwable throwable) {
        if (throwable != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(throwable.getMessage());
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement e = stackTraceElementArray[n2];
                sb.append("\n");
                sb.append(e.toString());
                ++n2;
            }
            return new String(sb);
        }
        return null;
    }

    private static void closeQuietly(AutoCloseable x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private byte[] readLocalFile(File path) throws IOException {
        if (path.exists() && path.isFile() && path.length() > 0L) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[131072];
            if (path.length() < (long)buffer.length) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(path);
                    int len = fis.read(buffer);
                    baos.write(buffer, 0, len);
                    baos.flush();
                    baos.close();
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return null;
    }

    private RcpCommandResponse reboot() {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        if (OperatingSystem.isWindows()) {
            ExecResult r = new ExecResult();
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            try {
                builder.command("shutdown.exe", "/r", "/f", "/t 0");
                this.log("" + builder.command());
                int p = CommandExecutor.execute(builder, r);
                this.log(r.getResult());
                rcpCommandResponse.setResponseMessage(builder.command() + " " + p + " " + r.getResult());
                rcpCommandResponse.setStatusCode(p);
            }
            catch (CommandException cex) {
                this.log("ex", cex);
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cex));
            }
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse respawn() {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("respawn");
                w.beginObject();
                String error = null;
                IJRE jre = JREUtils.getJRE();
                File dir = new File(System.getProperty("catalina.base"));
                try {
                    System.out.println("respawn...");
                    jre.spawnJRE(new File(dir, "appbase/launcher-service.jar").getAbsolutePath(), "net.launcher.service.RestartService", new String[]{"launch-9980"});
                    System.out.println("respawned!!!");
                }
                catch (CommandException e) {
                    e.printStackTrace();
                    error = e.getMessage();
                }
                w.name("error").value(error);
                w.name("os").value(OperatingSystem.getOperatingSystem().toString());
                w.name("arch").value(System.getProperty("os.arch"));
                w.name("model").value(System.getProperty("sun.arch.data.model"));
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse listFiles(String path) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        if (f.exists()) {
            if (f.isDirectory()) {
                StringBuilder sb = new StringBuilder();
                JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
                try {
                    try {
                        w.setHtmlSafe(true);
                        w.setIndent("\t");
                        w.beginObject();
                        w.name("list-files");
                        w.beginArray();
                        File[] fileArray = f.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            w.beginObject();
                            w.name("name");
                            w.value(file.getName());
                            w.name("modified");
                            w.value(file.lastModified());
                            if (file.isFile()) {
                                w.name("size");
                                w.value(file.length());
                                w.name("hash");
                                w.value(LauncherService.calcFileHash(file));
                            } else {
                                w.name("directory");
                                w.value(true);
                            }
                            w.endObject();
                            ++n2;
                        }
                        w.endArray();
                        w.endObject();
                        w.flush();
                        rcpCommandResponse.setResponseMessage(new String(sb));
                        rcpCommandResponse.setStatusCode(0);
                    }
                    catch (Exception cause) {
                        rcpCommandResponse.setStatusCode(-1);
                        rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                        LauncherService.closeQuietly((AutoCloseable)w);
                    }
                }
                finally {
                    LauncherService.closeQuietly((AutoCloseable)w);
                }
            } else {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage("not a directory");
            }
        } else {
            rcpCommandResponse.setStatusCode(-1);
            rcpCommandResponse.setResponseMessage("not found");
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse mkdirFile(String path) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("make-directory");
                w.beginObject();
                w.name("created").value(f.mkdir());
                w.name("path").value(path);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse mkdirsFile(String path) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("make-directories");
                w.beginObject();
                w.name("created").value(f.mkdirs());
                w.name("path").value(path);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse showFile(String path) {
        RcpCommandResponse rcpCommandResponse;
        block13: {
            rcpCommandResponse = new RcpCommandResponse();
            rcpCommandResponse.setStatusCode(-1);
            int maxSize = 524288;
            File f = new File(path);
            if (f.exists()) {
                if (f.isFile()) {
                    long fileSize = f.length();
                    if (fileSize < (long)maxSize) {
                        FileReader fr = null;
                        try {
                            try {
                                String mimeType = Files.probeContentType(f.toPath());
                                fr = new FileReader(f);
                                String response = "";
                                if (fileSize > 0L) {
                                    char[] buffer = new char[maxSize];
                                    int c = fr.read(buffer, 0, maxSize);
                                    response = new String(buffer, 0, c);
                                }
                                if (mimeType != null) {
                                    rcpCommandResponse.getHeaders().put("mime-type", mimeType);
                                }
                                rcpCommandResponse.setResponseMessage(response);
                                rcpCommandResponse.setStatusCode(0);
                            }
                            catch (IOException ioex) {
                                rcpCommandResponse.setStatusCode(-1);
                                rcpCommandResponse.setResponseMessage(this.convertThrowable(ioex));
                                LauncherService.closeQuietly(fr);
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            LauncherService.closeQuietly(fr);
                            throw throwable;
                        }
                        LauncherService.closeQuietly(fr);
                    } else {
                        rcpCommandResponse.setResponseMessage("too big (" + fileSize + "/" + maxSize + ")");
                    }
                } else {
                    rcpCommandResponse.setResponseMessage("not a file");
                }
            } else {
                rcpCommandResponse.setResponseMessage("not found");
            }
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse downloadFile(String path, String url) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("file-download");
                w.beginObject();
                w.name("hash").value(this.downloadFile(f, url));
                w.name("path").value(path);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse hashFile(String path) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        try {
            rcpCommandResponse.setResponseMessage(LauncherService.calcFileHash(f));
            rcpCommandResponse.setStatusCode(0);
        }
        catch (Exception cause) {
            rcpCommandResponse.setStatusCode(-1);
            rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse existsFile(String path) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("file-exists");
                w.beginObject();
                w.name("exists").value(f.exists());
                w.name("path").value(path);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse deleteFile(String path) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("file-delete");
                w.beginObject();
                w.name("deleted").value(f.delete());
                w.name("path").value(path);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse deleteDirectory(String path) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("directory-delete");
                w.beginObject();
                w.name("deleted").value(this.deleteCascade(f));
                w.name("path").value(path);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse renameFile(String path, String targetPath) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(path);
        File dest = new File(targetPath);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("file-rename");
                w.beginObject();
                w.name("renamed").value(f.renameTo(dest));
                w.name("path").value(path);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse unzipFile(String zipFile, String targetPath) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(zipFile);
        File dest = new File(targetPath);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                ZipUtils.loadDirectory(f, dest);
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("file-unzip");
                w.beginObject();
                w.name("path").value(zipFile);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse writeFile(String sourceFile, byte[] byteArray) {
        RcpCommandResponse rcpCommandResponse;
        block5: {
            rcpCommandResponse = new RcpCommandResponse();
            rcpCommandResponse.setStatusCode(-1);
            File f = new File(sourceFile);
            StringBuilder sb = new StringBuilder();
            JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(f);
                    fos.write(byteArray);
                    fos.flush();
                    w.setHtmlSafe(true);
                    w.setIndent("\t");
                    w.beginObject();
                    w.name("write-file");
                    w.beginObject();
                    w.name("path").value(sourceFile);
                    w.endObject();
                    w.endObject();
                    w.flush();
                    rcpCommandResponse.setResponseMessage(new String(sb));
                    rcpCommandResponse.setStatusCode(0);
                }
                catch (Exception cause) {
                    rcpCommandResponse.setStatusCode(-1);
                    rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                    LauncherService.closeQuietly(fos);
                    LauncherService.closeQuietly((AutoCloseable)w);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                LauncherService.closeQuietly(fos);
                LauncherService.closeQuietly((AutoCloseable)w);
                throw throwable;
            }
            LauncherService.closeQuietly(fos);
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse readFile(String sourceFile) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        File f = new File(sourceFile);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("read-file");
                w.beginObject();
                w.name("byte-array").value(Base64.encodeBase64String((byte[])this.readLocalFile(f)));
                w.name("path").value(sourceFile);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(new String(sb));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse executeCmd(String cmd) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        final JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("execute-cmd");
                w.beginObject();
                w.name("data");
                w.beginArray();
                int p = CommandExecutor.execute(CliUtils.createProcessBuilder(cmd), new ICommandResultListener(){

                    @Override
                    public void result(String line) {
                        try {
                            w.value(line);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                w.endArray();
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(p);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse redirectUrl(String redirectUrl) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                RestClient client = new RestClient();
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("redirect-url");
                w.beginObject();
                w.name("data").value(client.rest(redirectUrl));
                w.name("redirect-url").value(redirectUrl);
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse redirectPostRequest(String redirectUrl, Map<String, String> redirectHeaders, Map<String, String> redirectParameters) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                RestClient client = new RestClient();
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("redirect-post-request");
                w.beginObject();
                ArrayList<Header> headers = new ArrayList<Header>();
                for (String key : redirectHeaders.keySet()) {
                    headers.add((Header)new BasicHeader(key, redirectHeaders.get(key)));
                }
                ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
                for (String key : redirectParameters.keySet()) {
                    parameters.add((NameValuePair)new BasicNameValuePair(key, redirectParameters.get(key)));
                }
                w.name("byte-array").value(Base64.encodeBase64String((byte[])client.rest(redirectUrl, headers, parameters)));
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse getOperatingSystem() {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("operating-system");
                w.beginObject();
                w.name("os").value(OperatingSystem.getOperatingSystem().toString());
                w.name("arch").value(System.getProperty("os.arch"));
                w.name("model").value(System.getProperty("sun.arch.data.model"));
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse getLoopbackAddress() {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("loopback-address");
                w.beginObject();
                w.name("address").value(InetAddress.getLoopbackAddress().getHostAddress());
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse getNetworkAddress() {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("network-address");
                w.beginObject();
                w.name("address").value(InetAddress.getLocalHost().getHostAddress());
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse getNetworkAddresses() {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("network-addresses");
                w.beginObject();
                w.name("data");
                w.beginArray();
                w.value(InetAddress.getLoopbackAddress().getHostAddress());
                w.value(InetAddress.getLocalHost().getHostAddress());
                for (InterfaceAddress networkInterface : NetworkUtils.getInterfaceAddresses()) {
                    w.value(networkInterface.getAddress().getHostAddress());
                }
                w.endArray();
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse getNetworkScan(int timeout) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("network-scan");
                w.beginObject();
                w.name("data");
                w.beginArray();
                ArrayList<InetAddressScanner> scanners = new ArrayList<InetAddressScanner>();
                scanners.add(new InetAddressScanner(InetAddress.getLoopbackAddress(), timeout));
                scanners.add(new InetAddressScanner(InetAddress.getLocalHost(), timeout));
                try {
                    for (InterfaceAddress networkInterface : NetworkUtils.getInterfaceAddresses()) {
                        for (InetAddress inetAddress : NetworkUtils.getAddressesByInterfaceAddress(networkInterface, 24)) {
                            scanners.add(new InetAddressScanner(inetAddress, timeout));
                        }
                    }
                }
                catch (SocketException networkInterface) {
                    // empty catch block
                }
                for (InetAddressScanner scanner : scanners) {
                    scanner.start();
                }
                for (InetAddressScanner scanner : scanners) {
                    try {
                        scanner.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                for (InetAddressScanner scanner : scanners) {
                    if (!scanner.isAvailable()) continue;
                    w.value(scanner.getAddress().getHostAddress());
                }
                w.endArray();
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private RcpCommandResponse getNetworkPortScan(int port, int timeout) {
        RcpCommandResponse rcpCommandResponse = new RcpCommandResponse();
        rcpCommandResponse.setStatusCode(-1);
        StringBuilder sb = new StringBuilder();
        JsonWriter w = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
        try {
            try {
                w.setHtmlSafe(true);
                w.setIndent("\t");
                w.beginObject();
                w.name("network-port-scan");
                w.beginObject();
                w.name("data");
                w.beginArray();
                ArrayList<InetAddressPortScanner> scanners = new ArrayList<InetAddressPortScanner>();
                scanners.add(new InetAddressPortScanner(InetAddress.getLoopbackAddress(), port, timeout));
                scanners.add(new InetAddressPortScanner(InetAddress.getLocalHost(), port, timeout));
                try {
                    for (InterfaceAddress networkInterface : NetworkUtils.getInterfaceAddresses()) {
                        for (InetAddress inetAddress : NetworkUtils.getAddressesByInterfaceAddress(networkInterface, 24)) {
                            scanners.add(new InetAddressPortScanner(inetAddress, port, timeout));
                        }
                    }
                }
                catch (SocketException networkInterface) {
                    // empty catch block
                }
                for (InetAddressPortScanner scanner : scanners) {
                    scanner.start();
                }
                for (InetAddressPortScanner scanner : scanners) {
                    try {
                        scanner.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                for (InetAddressPortScanner scanner : scanners) {
                    if (!scanner.isAvailable()) continue;
                    w.value(scanner.getAddress().getHostAddress());
                }
                w.endArray();
                w.endObject();
                w.endObject();
                w.flush();
                rcpCommandResponse.setResponseMessage(Base64.encodeBase64URLSafeString((byte[])new String(sb).getBytes(StandardCharsets.UTF_8)));
                rcpCommandResponse.setStatusCode(0);
            }
            catch (Exception cause) {
                rcpCommandResponse.setStatusCode(-1);
                rcpCommandResponse.setResponseMessage(this.convertThrowable(cause));
                LauncherService.closeQuietly((AutoCloseable)w);
            }
        }
        finally {
            LauncherService.closeQuietly((AutoCloseable)w);
        }
        return rcpCommandResponse;
    }

    private class ExecResult
    implements ICommandResultListener {
        private StringBuilder sb = new StringBuilder();
        private String sep = "";

        private ExecResult() {
        }

        @Override
        public void result(String line) {
            this.sb.append(this.sep);
            this.sb.append(line);
            this.sep = "\n";
        }

        public String getResult() {
            return new String(this.sb);
        }
    }

    private class LauncherUpdate
    extends Thread {
        private boolean stop = false;
        private Object stopSem = new Object();
        private long nextDL = System.currentTimeMillis();

        private LauncherUpdate() {
        }

        public void forceUpdate() {
            this.nextDL = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                File[] af;
                Object object = this.stopSem;
                synchronized (object) {
                    try {
                        this.stopSem.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (System.currentTimeMillis() <= this.nextDL) continue;
                this.nextDL = System.currentTimeMillis() + 60000L;
                File dir = new File(System.getProperty("catalina.base"));
                File localLogDir = new File(dir, "logs");
                localLogDir.mkdirs();
                File[] fileArray = af = localLogDir.listFiles();
                int n = af.length;
                int n2 = 0;
                while (n2 < n) {
                    File df = fileArray[n2];
                    if (df.getName().endsWith(".log")) {
                        df.delete();
                    }
                    ++n2;
                }
                File localDownloadDir = new File(dir, "downloads");
                localDownloadDir.mkdirs();
                File[] fileArray2 = af = localDownloadDir.listFiles();
                int n3 = af.length;
                n = 0;
                while (n < n3) {
                    File df = fileArray2[n];
                    if (df.getName().endsWith(".dl")) {
                        df.delete();
                    }
                    ++n;
                }
                String remotePath = "launcher-service.war";
                File webappsDir = new File(dir, "webapps");
                File webappsWarFile = new File(webappsDir, "launcher-service.war");
                File localWarDir = new File(dir, "appbase");
                localWarDir.mkdirs();
                File localWarFile = new File(localWarDir, "launcher-service.war");
                try {
                    String localWarHash = "";
                    try {
                        localWarHash = LauncherService.calcFileHash(localWarFile);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String remoteWarHash = LauncherService.this.getRemoteHash(remotePath);
                    System.out.println("check update...");
                    if (remoteWarHash.equals(localWarHash)) continue;
                    System.out.println("update available...");
                    File tempFile = File.createTempFile("launcher-service-", ".dl", localDownloadDir);
                    String downloadFileHash = LauncherService.this.downloadRemoteFile(tempFile, remotePath);
                    if (!downloadFileHash.equals(remoteWarHash)) continue;
                    System.out.println("unpack update...");
                    LauncherService.this.unzip(webappsWarFile, localWarDir, "launcher-service.jar");
                    localWarFile.delete();
                    tempFile.renameTo(localWarFile);
                    Path source = FileSystems.getDefault().getPath(localWarFile.getAbsolutePath(), new String[0]);
                    Path dest = FileSystems.getDefault().getPath(webappsWarFile.getAbsolutePath(), new String[0]);
                    Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
                    IJRE jre = JREUtils.getJRE();
                    try {
                        System.out.println("begin update...");
                        jre.spawnJRE(new File(dir, "appbase/launcher-service.jar").getAbsolutePath(), "net.launcher.service.RestartService", new String[]{"launch-9980"});
                        System.out.println("end update...");
                    }
                    catch (CommandException e) {
                        e.printStackTrace();
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (KeyManagementException e) {
                    e.printStackTrace();
                }
                catch (KeyStoreException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutDown() {
            this.stop = true;
            Object object = this.stopSem;
            synchronized (object) {
                this.stopSem.notifyAll();
            }
        }
    }
}

