/*
 * Decompiled with CFR 0.152.
 */
package net.launcher.service.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import net.launcher.service.client.EasyX509TrustStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.tomcat.util.codec.binary.Base64;

public class FileDownloadClient {
    private final HttpClientBuilder builder = HttpClientBuilder.create();

    public FileDownloadClient() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        SSLContext context = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new EasyX509TrustStrategy()).build();
        SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(context, new String[]{"TLSv1"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
        this.builder.setSSLSocketFactory((LayeredConnectionSocketFactory)factory);
    }

    public String download(String urlString, OutputStream stream) throws IOException, NoSuchAlgorithmException {
        HttpGet method = new HttpGet(urlString);
        method.addHeader("Connection", "close");
        method.addHeader("Cache-Control", "no-cache");
        method.addHeader("Accept", ContentType.APPLICATION_OCTET_STREAM.getMimeType());
        CloseableHttpClient client = null;
        CloseableHttpResponse response = null;
        InputStream in = null;
        try {
            client = this.builder.build();
            response = client.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                int b;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
                byte[] buffer = new byte[8192];
                in = response.getEntity().getContent();
                while ((b = in.read(buffer)) != -1) {
                    stream.write(buffer, 0, b);
                    messageDigest.update(buffer, 0, b);
                }
                byte[] byteArray = messageDigest.digest();
                messageDigest.reset();
                messageDigest = null;
                String string = Base64.encodeBase64URLSafeString((byte[])byteArray);
                return string;
            }
            throw new IOException(String.valueOf(response.getStatusLine().getStatusCode()));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

