/*
 * Decompiled with CFR 0.152.
 */
package net.launcher.service.timeglobe;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import net.cli.CommandException;
import net.cli.OperatingSystem;
import net.obj.rc.executor.IRcExecutor;
import net.obj.rc.executor.RcExecutorUtils;
import net.obj.rc.executor.tg.RcExecutorTgPosUpdater;

public class TimeglobePosUpdate
extends Thread {
    private static final String DEFAULT_PATH = "/timeglobe";
    private static final String MAC_SPECIAL_PATH = "/Users/Shared/timeglobe";
    private volatile boolean stop = false;
    private Object semaphore = new Object();
    private static final File updateSourceDir = new File(System.getProperty("catalina.base"), "update/timeglobe/pos");
    private UpdateWorker updateWorker = new UpdateWorker();
    private IRcExecutor executor;

    public TimeglobePosUpdate(IRcExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            if (this.updateWorker.isUpdateSupported()) {
                this.updateWorker.checkUpdate();
                this.updateWorker.executeUpdate();
            }
            if (this.stop) break;
            Object object = this.semaphore;
            synchronized (object) {
                try {
                    this.semaphore.wait(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized UpdateWorker getUpdateWorker() {
        return this.updateWorker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stop = true;
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    public static enum UpdateState {
        IDLE(false),
        AVAILABLE(true),
        INSTALL(true);

        private boolean locked;

        private UpdateState(boolean locked) {
            this.locked = locked;
        }

        public boolean isLocked() {
            return this.locked;
        }
    }

    public class UpdateWorker {
        private UpdateState updateState = UpdateState.IDLE;

        private boolean isUpdateSupported() {
            try {
                OperatingSystem.Type os = TimeglobePosUpdate.this.executor.getOperatingSystem();
                return os == OperatingSystem.Type.WINDOWS || os == OperatingSystem.Type.MAC;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkUpdate() {
            boolean checkUpdate;
            UpdateWorker updateWorker = this;
            synchronized (updateWorker) {
                checkUpdate = this.updateState == UpdateState.IDLE;
            }
            if (checkUpdate) {
                File versionFile = new File(updateSourceDir, "version.hash");
                File updateFile = new File(updateSourceDir, "update.pos");
                if (versionFile.exists()) {
                    try {
                        String hash;
                        byte[] byteArray = TimeglobePosUpdate.this.executor.readFile(versionFile.getAbsolutePath());
                        if (byteArray != null && (hash = new String(byteArray, StandardCharsets.UTF_8)) != null && RcExecutorUtils.compareHashIfExists(TimeglobePosUpdate.this.executor, updateFile.getAbsolutePath(), hash)) {
                            return false;
                        }
                    }
                    catch (Exception cause) {
                        cause.printStackTrace();
                    }
                }
                if (updateFile.exists()) {
                    UpdateWorker updateWorker2 = this;
                    synchronized (updateWorker2) {
                        this.updateState = UpdateState.AVAILABLE;
                    }
                    return true;
                }
            }
            return false;
        }

        public Integer readTennantNo() {
            try {
                File dir;
                File defaultFile = new File(TimeglobePosUpdate.DEFAULT_PATH);
                File macSpecialFile = new File(TimeglobePosUpdate.MAC_SPECIAL_PATH);
                if (macSpecialFile.exists()) {
                    dir = macSpecialFile;
                } else if (defaultFile.exists()) {
                    dir = defaultFile;
                } else {
                    throw new CommandException("timeglobe environment not exists");
                }
                String posDir = new File(dir, "pos").getAbsolutePath();
                Collection<RcExecutorTgPosUpdater.PosConfig> configs = RcExecutorTgPosUpdater.loadPosConfigs(TimeglobePosUpdate.this.executor, String.valueOf(posDir) + "/possat-8080/conf/Catalina/localhost");
                for (RcExecutorTgPosUpdater.PosConfig config : configs) {
                    if (config.getConfigType() != RcExecutorTgPosUpdater.PosConfig.ConfigType.POS_SATELLITE_SERVICE) continue;
                    return config.getTenantNo();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public Integer readBusinessunitNo() {
            try {
                File dir;
                File defaultFile = new File(TimeglobePosUpdate.DEFAULT_PATH);
                File macSpecialFile = new File(TimeglobePosUpdate.MAC_SPECIAL_PATH);
                if (macSpecialFile.exists()) {
                    dir = macSpecialFile;
                } else if (defaultFile.exists()) {
                    dir = defaultFile;
                } else {
                    throw new CommandException("timeglobe environment not exists");
                }
                String posDir = new File(dir, "pos").getAbsolutePath();
                Collection<RcExecutorTgPosUpdater.PosConfig> configs = RcExecutorTgPosUpdater.loadPosConfigs(TimeglobePosUpdate.this.executor, String.valueOf(posDir) + "/possat-8080/conf/Catalina/localhost");
                for (RcExecutorTgPosUpdater.PosConfig config : configs) {
                    if (config.getConfigType() != RcExecutorTgPosUpdater.PosConfig.ConfigType.POS_SATELLITE_SERVICE) continue;
                    return config.getBusinessunitNo();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public Integer readSaloonNo() {
            try {
                File dir;
                File defaultFile = new File(TimeglobePosUpdate.DEFAULT_PATH);
                File macSpecialFile = new File(TimeglobePosUpdate.MAC_SPECIAL_PATH);
                if (macSpecialFile.exists()) {
                    dir = macSpecialFile;
                } else if (defaultFile.exists()) {
                    dir = defaultFile;
                } else {
                    throw new CommandException("timeglobe environment not exists");
                }
                String posDir = new File(dir, "pos").getAbsolutePath();
                Collection<RcExecutorTgPosUpdater.PosConfig> configs = RcExecutorTgPosUpdater.loadPosConfigs(TimeglobePosUpdate.this.executor, String.valueOf(posDir) + "/possat-8080/conf/Catalina/localhost");
                for (RcExecutorTgPosUpdater.PosConfig config : configs) {
                    if (config.getConfigType() != RcExecutorTgPosUpdater.PosConfig.ConfigType.POS_SATELLITE_SERVICE) continue;
                    return config.getSaloonNo();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public String readPosSatellitePath() {
            try {
                File dir;
                File defaultFile = new File(TimeglobePosUpdate.DEFAULT_PATH);
                File macSpecialFile = new File(TimeglobePosUpdate.MAC_SPECIAL_PATH);
                if (macSpecialFile.exists()) {
                    dir = macSpecialFile;
                } else if (defaultFile.exists()) {
                    dir = defaultFile;
                } else {
                    throw new CommandException("timeglobe environment not exists");
                }
                String posDir = new File(dir, "pos").getAbsolutePath();
                Collection<RcExecutorTgPosUpdater.PosConfig> configs = RcExecutorTgPosUpdater.loadPosConfigs(TimeglobePosUpdate.this.executor, String.valueOf(posDir) + "/possat-8080/conf/Catalina/localhost");
                for (RcExecutorTgPosUpdater.PosConfig config : configs) {
                    if (config.getConfigType() != RcExecutorTgPosUpdater.PosConfig.ConfigType.POS_SATELLITE_SERVICE) continue;
                    return config.getFileName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public String readPosSatelliteAdminPath() {
            try {
                File dir;
                File defaultFile = new File(TimeglobePosUpdate.DEFAULT_PATH);
                File macSpecialFile = new File(TimeglobePosUpdate.MAC_SPECIAL_PATH);
                if (macSpecialFile.exists()) {
                    dir = macSpecialFile;
                } else if (defaultFile.exists()) {
                    dir = defaultFile;
                } else {
                    throw new CommandException("timeglobe environment not exists");
                }
                String posDir = new File(dir, "pos").getAbsolutePath();
                Collection<RcExecutorTgPosUpdater.PosConfig> configs = RcExecutorTgPosUpdater.loadPosConfigs(TimeglobePosUpdate.this.executor, String.valueOf(posDir) + "/possat-8080/conf/Catalina/localhost");
                for (RcExecutorTgPosUpdater.PosConfig config : configs) {
                    if (config.getConfigType() != RcExecutorTgPosUpdater.PosConfig.ConfigType.POS_SATELLITE_ADMIN_SERVICE) continue;
                    return config.getFileName();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invokeUpdate() {
            boolean invokeUpdate;
            Object object = this;
            synchronized (object) {
                invokeUpdate = this.updateState == UpdateState.AVAILABLE;
            }
            if (invokeUpdate) {
                object = this;
                synchronized (object) {
                    this.updateState = UpdateState.INSTALL;
                }
                object = TimeglobePosUpdate.this.semaphore;
                synchronized (object) {
                    TimeglobePosUpdate.this.semaphore.notifyAll();
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeUpdate() {
            boolean executeUpdate;
            UpdateWorker updateWorker = this;
            synchronized (updateWorker) {
                executeUpdate = this.updateState == UpdateState.INSTALL;
            }
            if (executeUpdate) {
                String dir;
                File updateFile;
                File versionFile;
                block13: {
                    versionFile = new File(updateSourceDir, "version.hash");
                    updateFile = new File(updateSourceDir, "update.pos");
                    try {
                        dir = TimeglobePosUpdate.MAC_SPECIAL_PATH;
                        if (TimeglobePosUpdate.this.executor.existsFile(dir)) break block13;
                        dir = TimeglobePosUpdate.DEFAULT_PATH;
                        if (TimeglobePosUpdate.this.executor.existsFile(dir)) break block13;
                        return false;
                    }
                    catch (Exception cause) {
                        cause.printStackTrace();
                        UpdateWorker updateWorker2 = this;
                        synchronized (updateWorker2) {
                            this.updateState = UpdateState.AVAILABLE;
                        }
                        return false;
                    }
                }
                RcExecutorTgPosUpdater.execute(TimeglobePosUpdate.this.executor, dir);
                TimeglobePosUpdate.this.executor.writeFile(versionFile.getAbsolutePath(), RcExecutorUtils.hashFile(TimeglobePosUpdate.this.executor, updateFile.getAbsolutePath()).getBytes(StandardCharsets.UTF_8));
                UpdateWorker updateWorker3 = this;
                synchronized (updateWorker3) {
                    this.updateState = UpdateState.IDLE;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpdateState getUpdateState() {
            UpdateWorker updateWorker = this;
            synchronized (updateWorker) {
                return this.updateState;
            }
        }
    }
}

