/*
 * Decompiled with CFR 0.152.
 */
package net.obj.rc.client;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import net.obj.rc.beans.RcLoginMessage;
import net.obj.rc.beans.RcMessage;
import net.obj.rc.client.IRcMessageListener;
import org.apache.tomcat.websocket.WsSession;

@ClientEndpoint
public class RcClient
extends Thread {
    private static WebSocketContainer CONTAINER = ContainerProvider.getWebSocketContainer();
    private Object semaphore = new Object();
    private boolean stop = false;
    private WsSession wsSession = null;
    private String uriString;
    private RcLoginMessage rcLogin;
    private IRcMessageListener listener = null;

    public RcClient(String uriString, RcLoginMessage rcLogin, IRcMessageListener listener) {
        this.uriString = uriString;
        this.rcLogin = rcLogin;
        this.listener = listener;
    }

    @OnOpen
    public void onOpen(Session session) {
        session.setMaxBinaryMessageBufferSize(0x100000);
        session.setMaxTextMessageBufferSize(0x100000);
        session.setMaxIdleTimeout(300000L);
        if (session instanceof WsSession) {
            this.wsSession = (WsSession)session;
            Gson gson = new Gson();
            try {
                System.err.println(new Date() + " [OPEN] > " + gson.toJson((Object)this.rcLogin));
                this.wsSession.getBasicRemote().sendText(gson.toJson((Object)this.rcLogin));
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
    }

    public void sendMessage(RcMessage rcMessage) {
        if (this.wsSession != null) {
            Gson gson = new Gson();
            try {
                this.wsSession.getBasicRemote().sendText(gson.toJson((Object)rcMessage));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @OnMessage
    public void onMessage(Session session, String message) {
        if (message != null && !message.equals(".") && this.wsSession != null && this.listener != null) {
            RcMessage rcMessage = null;
            Gson gson = new Gson();
            rcMessage = (RcMessage)gson.fromJson(message, RcMessage.class);
            try {
                this.listener.processMessage(session, rcMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable throwable) {
        throwable.printStackTrace();
        if (this.wsSession != null) {
            try {
                this.wsSession.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnClose
    public void onClose(Session session, CloseReason reason) {
        System.err.println(new Date() + " [CLOSE] > " + session + ":" + reason);
        this.wsSession = null;
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            Object object;
            if (this.wsSession == null) {
                try {
                    CONTAINER.connectToServer((Object)this, new URI(this.uriString));
                }
                catch (DeploymentException deploymentException) {
                }
                catch (IOException iOException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.stop) break;
            if (this.wsSession == null) {
                object = this.semaphore;
                synchronized (object) {
                    try {
                        this.semaphore.wait(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            object = this.semaphore;
            synchronized (object) {
                try {
                    this.semaphore.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.wsSession != null) {
            try {
                this.wsSession.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.wsSession = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.stop = true;
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }
}

