/*
 * Decompiled with CFR 0.152.
 */
package net.obj.rc.executor;

import java.io.IOException;
import java.util.ArrayList;
import net.cli.OperatingSystem;
import net.cli.pid.PidGrabberMac;
import net.cli.pid.PidGrabberWindows;
import net.obj.rc.executor.IRcExecutor;

public class RcExecutorUtils {
    public static void deleteFileIfExists(IRcExecutor executor, String file) throws IOException {
        if (executor.existsFile(file)) {
            RcExecutorUtils.deleteFile(executor, file);
        }
    }

    public static void deleteFile(IRcExecutor executor, String file) throws IOException {
        if (!executor.deleteFile(file)) {
            throw new IOException("failed to delete file file=" + file);
        }
    }

    public static void deleteDirectoryIfExists(IRcExecutor executor, String directory) throws IOException {
        if (executor.existsFile(directory)) {
            RcExecutorUtils.deleteDirectory(executor, directory);
        }
    }

    public static void deleteDirectory(IRcExecutor executor, String directory) throws IOException {
        if (!executor.deleteDirectory(directory)) {
            throw new IOException("failed to delete directory dir=" + directory);
        }
    }

    public static void createDirectoryIfNoExists(IRcExecutor executor, String directory) throws IOException {
        if (!executor.existsFile(directory)) {
            RcExecutorUtils.createDirectory(executor, directory);
        }
    }

    public static void createDirectory(IRcExecutor executor, String directory) throws IOException {
        if (!executor.makeDirectory(directory)) {
            throw new IOException("failed to create directory dir=" + directory);
        }
    }

    public static void createDirectoriesIfNoExists(IRcExecutor executor, String directory) throws IOException {
        if (!executor.existsFile(directory)) {
            RcExecutorUtils.createDirectories(executor, directory);
        }
    }

    public static void createDirectories(IRcExecutor executor, String directory) throws IOException {
        if (!executor.makeDirectories(directory)) {
            throw new IOException("failed to create directories dir=" + directory);
        }
    }

    public static void renameFileIfExists(IRcExecutor executor, String sourcePath, String targetPath) throws IOException {
        if (executor.existsFile(sourcePath)) {
            RcExecutorUtils.renameFile(executor, sourcePath, targetPath);
        }
    }

    public static void renameFile(IRcExecutor executor, String sourcePath, String targetPath) throws IOException {
        if (!executor.renameFile(sourcePath, targetPath)) {
            throw new IOException("failed to rename from=" + sourcePath + ", to=" + targetPath);
        }
    }

    public static boolean compareHashIfExists(IRcExecutor executor, String sourcePath, String hash) throws IOException {
        if (executor.existsFile(sourcePath)) {
            return RcExecutorUtils.compareHash(executor, sourcePath, hash);
        }
        return false;
    }

    public static boolean compareHash(IRcExecutor executor, String sourcePath, String hash) throws IOException {
        return RcExecutorUtils.hashFile(executor, sourcePath).equals(hash);
    }

    public static String hashFile(IRcExecutor executor, String sourcePath) throws IOException {
        return executor.hashFile(sourcePath);
    }

    public static boolean compareDownloadHash(IRcExecutor executor, String sourcePath, String targetUrl, String hash) throws IOException {
        return executor.downloadFile(sourcePath, targetUrl).equals(hash);
    }

    public static void downloadHash(IRcExecutor executor, String sourcePath, String targetUrl) throws IOException {
        executor.downloadFile(sourcePath, targetUrl);
    }

    public static void killPid(IRcExecutor executor, int pid) throws IOException {
        ArrayList<String> lines = null;
        OperatingSystem.Type os = executor.getOperatingSystem();
        if (os == OperatingSystem.Type.WINDOWS) {
            lines = executor.executeCommand("taskkill /PID " + pid + " /F");
        } else if (os == OperatingSystem.Type.MAC) {
            lines = executor.executeCommand("kill -9 " + pid);
        } else {
            throw new IOException("os not supported: abort");
        }
        if (lines == null) {
            throw new IOException("no lines found: abort");
        }
    }

    public static int[] readPidsByPort(IRcExecutor executor, String proto, int port) throws IOException {
        ArrayList<String> lines = null;
        OperatingSystem.Type os = executor.getOperatingSystem();
        if (os == OperatingSystem.Type.WINDOWS) {
            lines = executor.executeCommand("netstat -ano");
        } else if (os == OperatingSystem.Type.MAC) {
            lines = executor.executeCommand("lsof -i tcp:8080");
        } else {
            throw new IOException("os not supported: abort");
        }
        if (lines == null) {
            throw new IOException("no lines found: abort");
        }
        String[] array = new String[lines.size()];
        int p = 0;
        for (String x : lines) {
            array[p++] = x;
        }
        if (os == OperatingSystem.Type.WINDOWS) {
            return PidGrabberWindows.parse(proto, port, array);
        }
        if (os == OperatingSystem.Type.MAC) {
            return PidGrabberMac.parse(proto, port, array);
        }
        throw new IOException("os not supported: abort");
    }
}

