/*
 * Decompiled with CFR 0.152.
 */
package net.obj.rc.executor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Map;
import net.cli.CliUtils;
import net.cli.CommandExecutor;
import net.cli.FileUtils;
import net.cli.HashUtils;
import net.cli.ICommandResultListener;
import net.cli.InetAddressPortScanner;
import net.cli.InetAddressScanner;
import net.cli.NetworkUtils;
import net.cli.OperatingSystem;
import net.cli.ZipUtils;
import net.obj.rc.executor.FileDownloadClient;
import net.obj.rc.executor.IRcExecutor;
import net.obj.rc.executor.beans.RcFile;

public class RcLocalExecutor
implements IRcExecutor {
    private static final long TIMEOUT = 100L;

    @Override
    public void respawn() throws IOException {
        throw new IOException("not implemented.");
    }

    @Override
    public synchronized ArrayList<RcFile> listFiles(String sourcePath) throws IOException {
        ArrayList<RcFile> files = new ArrayList<RcFile>();
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            RcFile rcFile;
            File file = fileArray[n2];
            if (file.isFile()) {
                try {
                    rcFile = new RcFile(file.getName(), file.lastModified(), file.length(), false, HashUtils.calcFileHash(file));
                    files.add(rcFile);
                }
                catch (Exception cause) {
                    throw new IOException(cause);
                }
            }
            try {
                rcFile = new RcFile(file.getName(), file.lastModified(), 0L, true, null);
                files.add(rcFile);
            }
            catch (Exception cause) {
                throw new IOException(cause);
            }
            ++n2;
        }
        return files;
    }

    @Override
    public synchronized String hashFile(String sourcePath) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            return HashUtils.calcFileHash(path);
        }
        catch (Exception cause) {
            throw new IOException(cause);
        }
    }

    @Override
    public synchronized boolean existsFile(String sourcePath) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return path.exists();
    }

    @Override
    public synchronized boolean deleteFile(String sourcePath) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return path.delete();
    }

    @Override
    public synchronized boolean renameFile(String sourcePath, String targetPath) throws IOException {
        File path1 = new File(sourcePath);
        File path2 = new File(targetPath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return path1.renameTo(path2);
    }

    @Override
    public synchronized void unzipFile(String sourcePath, String targetPath) throws IOException {
        File path1 = new File(sourcePath);
        File path2 = new File(targetPath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ZipUtils.loadDirectory(path1, path2);
    }

    @Override
    public synchronized String downloadFile(String sourcePath, String targetUrl) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String hash = null;
        FileOutputStream fos = null;
        try {
            try {
                FileDownloadClient client = new FileDownloadClient();
                fos = new FileOutputStream(path);
                hash = client.download(targetUrl, fos);
            }
            catch (Exception cause) {
                throw new IOException(cause);
            }
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return hash;
    }

    @Override
    public synchronized void writeFile(String sourcePath, byte[] byteArray) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(path);
            fos.write(byteArray);
            fos.flush();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public synchronized byte[] readFile(String sourcePath) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (path.exists() && path.isFile() && path.length() > 0L) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[131072];
            if (path.length() < (long)buffer.length) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(path);
                    int len = fis.read(buffer);
                    baos.write(buffer, 0, len);
                    baos.flush();
                    baos.close();
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return null;
    }

    @Override
    public synchronized boolean makeDirectory(String sourcePath) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return path.mkdir();
    }

    @Override
    public synchronized boolean makeDirectories(String sourcePath) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return path.mkdirs();
    }

    @Override
    public synchronized boolean deleteDirectory(String sourcePath) throws IOException {
        File path = new File(sourcePath);
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return FileUtils.deleteCascade(path);
    }

    @Override
    public synchronized ArrayList<String> executeCommand(String cmd) throws IOException {
        try {
            this.wait(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        final ArrayList<String> lines = new ArrayList<String>();
        boolean error = true;
        try {
            int p = CommandExecutor.execute(CliUtils.createProcessBuilder(cmd), new ICommandResultListener(){

                @Override
                public void result(String line) {
                    lines.add(line);
                }
            });
            error = p != 0;
        }
        catch (Exception cause) {
            throw new IOException(cause);
        }
        if (error) {
            throw new IOException("process failed");
        }
        return lines;
    }

    @Override
    public String redirectUrl(String redirectUrl) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public byte[] redirectPostRequest(String redirectUrl, Map<String, String> headers, Map<String, String> parameters) throws IOException {
        throw new IOException("not implemented");
    }

    @Override
    public OperatingSystem.Type getOperatingSystem() throws IOException {
        return OperatingSystem.getOperatingSystem();
    }

    @Override
    public String getLoopbackAddress() throws IOException {
        return InetAddress.getLoopbackAddress().getHostAddress();
    }

    @Override
    public String getNetworkAddress() throws IOException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    @Override
    public ArrayList<String> getNetworkAddresses() throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(InetAddress.getLoopbackAddress().getHostAddress());
        list.add(InetAddress.getLocalHost().getHostAddress());
        for (InterfaceAddress networkInterface : NetworkUtils.getInterfaceAddresses()) {
            list.add(networkInterface.getAddress().getHostAddress());
        }
        return list;
    }

    @Override
    public ArrayList<String> getNetworkScan(int timeout) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<InetAddressScanner> scanners = new ArrayList<InetAddressScanner>();
        scanners.add(new InetAddressScanner(InetAddress.getLoopbackAddress(), timeout));
        scanners.add(new InetAddressScanner(InetAddress.getLocalHost(), timeout));
        try {
            for (InterfaceAddress networkInterface : NetworkUtils.getInterfaceAddresses()) {
                for (InetAddress inetAddress : NetworkUtils.getAddressesByInterfaceAddress(networkInterface, 24)) {
                    scanners.add(new InetAddressScanner(inetAddress, timeout));
                }
            }
        }
        catch (SocketException networkInterface) {
            // empty catch block
        }
        for (InetAddressScanner scanner : scanners) {
            scanner.start();
        }
        for (InetAddressScanner scanner : scanners) {
            try {
                scanner.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (InetAddressScanner scanner : scanners) {
            if (!scanner.isAvailable()) continue;
            list.add(scanner.getAddress().getHostAddress());
        }
        return list;
    }

    @Override
    public ArrayList<String> getNetworkPortScan(int port, int timeout) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<InetAddressPortScanner> scanners = new ArrayList<InetAddressPortScanner>();
        scanners.add(new InetAddressPortScanner(InetAddress.getLoopbackAddress(), port, timeout));
        scanners.add(new InetAddressPortScanner(InetAddress.getLocalHost(), port, timeout));
        try {
            for (InterfaceAddress networkInterface : NetworkUtils.getInterfaceAddresses()) {
                for (InetAddress inetAddress : NetworkUtils.getAddressesByInterfaceAddress(networkInterface, 24)) {
                    scanners.add(new InetAddressPortScanner(inetAddress, port, timeout));
                }
            }
        }
        catch (SocketException networkInterface) {
            // empty catch block
        }
        for (InetAddressPortScanner scanner : scanners) {
            scanner.start();
        }
        for (InetAddressPortScanner scanner : scanners) {
            try {
                scanner.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (InetAddressPortScanner scanner : scanners) {
            if (!scanner.isAvailable()) continue;
            list.add(scanner.getAddress().getHostAddress());
        }
        return list;
    }
}

