/*
 * Decompiled with CFR 0.152.
 */
package net.obj.rc.executor.tg.script;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.obj.rc.executor.tg.script.ScriptRunner;

public class SqlScriptExecutor {
    private final String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    private final String user = "";
    private final String password = "";

    public void executeScripts(String url, File file) throws IOException, SQLException, ClassNotFoundException {
        Connection connection = null;
        try {
            connection = this.getConnection("org.apache.derby.jdbc.EmbeddedDriver", url, "", "");
            connection.setAutoCommit(true);
            ScriptRunner scriptRunner = new ScriptRunner();
            String script = this.readScriptFile(file);
            scriptRunner.runScript(connection, script);
        }
        catch (Throwable throwable) {
            this.closeConnection(connection);
            throw throwable;
        }
        this.closeConnection(connection);
    }

    private String readScriptFile(File file) throws IOException {
        return String.join((CharSequence)System.lineSeparator(), Files.readAllLines(file.toPath()));
    }

    public void shutDownDerbyDatabase() {
        String shutDownUrl = "jdbc:derby:;shutdown=true";
        try {
            this.getConnection("org.apache.derby.jdbc.EmbeddedDriver", shutDownUrl, "", "");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private Connection getConnection(String driver, String url, String user, String password) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        System.err.println("driver=" + driver);
        System.err.println("url=" + url);
        System.err.println("user=" + user);
        System.err.println("password=" + password);
        Connection connection = DriverManager.getConnection(url, user, password);
        connection.setAutoCommit(true);
        return connection;
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

