/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontReader;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;
import org.apache.xmlgraphics.io.Resource;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyFont
extends Typeface
implements FontDescriptor,
Substitutable,
Positionable {
    private static Log log = LogFactory.getLog(LazyFont.class);
    private final URI metricsURI;
    private final URI fontEmbedURI;
    private final boolean useKerning;
    private final boolean useAdvanced;
    private final EncodingMode encodingMode;
    private final EmbeddingMode embeddingMode;
    private final String subFontName;
    private final boolean embedded;
    private final InternalResourceResolver resourceResolver;
    private boolean isMetricsLoaded;
    private Typeface realFont;
    private FontDescriptor realFontDescriptor;

    public LazyFont(EmbedFontInfo fontInfo, InternalResourceResolver resourceResolver, boolean useComplexScripts) {
        this.metricsURI = fontInfo.getMetricsURI();
        this.fontEmbedURI = fontInfo.getEmbedURI();
        this.useKerning = fontInfo.getKerning();
        this.useAdvanced = resourceResolver != null ? useComplexScripts : fontInfo.getAdvanced();
        this.encodingMode = fontInfo.getEncodingMode() != null ? fontInfo.getEncodingMode() : EncodingMode.AUTO;
        this.embeddingMode = fontInfo.getEmbeddingMode() != null ? fontInfo.getEmbeddingMode() : EmbeddingMode.AUTO;
        this.subFontName = fontInfo.getSubFontName();
        this.embedded = fontInfo.isEmbedded();
        this.resourceResolver = resourceResolver;
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer(super.toString());
        sbuf.append('{');
        sbuf.append("metrics-url=" + this.metricsURI);
        sbuf.append(",embed-url=" + this.fontEmbedURI);
        sbuf.append(",kerning=" + this.useKerning);
        sbuf.append(",advanced=" + this.useAdvanced);
        sbuf.append('}');
        return sbuf.toString();
    }

    private void load(boolean fail) {
        if (!this.isMetricsLoaded) {
            block10: {
                try {
                    if (this.metricsURI != null) {
                        FontReader reader = null;
                        Resource in = this.resourceResolver.getResource(this.metricsURI);
                        InputSource src = new InputSource((InputStream)in);
                        src.setSystemId(this.metricsURI.toASCIIString());
                        reader = new FontReader(src, this.resourceResolver);
                        reader.setKerningEnabled(this.useKerning);
                        reader.setAdvancedEnabled(this.useAdvanced);
                        if (this.embedded) {
                            reader.setFontEmbedURI(this.fontEmbedURI);
                        }
                        this.realFont = reader.getFont();
                    } else {
                        if (this.fontEmbedURI == null) {
                            throw new RuntimeException("Cannot load font. No font URIs available.");
                        }
                        this.realFont = FontLoader.loadFont(this.fontEmbedURI, this.subFontName, this.embedded, this.embeddingMode, this.encodingMode, this.useKerning, this.useAdvanced, this.resourceResolver);
                    }
                    if (this.realFont instanceof FontDescriptor) {
                        this.realFontDescriptor = (FontDescriptor)((Object)this.realFont);
                    }
                }
                catch (FOPException fopex) {
                    log.error((Object)("Failed to read font metrics file " + this.metricsURI), (Throwable)fopex);
                    if (fail) {
                        throw new RuntimeException(fopex);
                    }
                }
                catch (IOException ioex) {
                    log.error((Object)("Failed to read font metrics file " + this.metricsURI), (Throwable)ioex);
                    if (!fail) break block10;
                    throw new RuntimeException(ioex);
                }
            }
            this.realFont.setEventListener(this.eventListener);
            this.isMetricsLoaded = true;
        }
    }

    public Typeface getRealFont() {
        this.load(false);
        return this.realFont;
    }

    @Override
    public String getEncodingName() {
        this.load(true);
        return this.realFont.getEncodingName();
    }

    @Override
    public char mapChar(char c) {
        this.load(true);
        return this.realFont.mapChar(c);
    }

    @Override
    public boolean hadMappingOperations() {
        this.load(true);
        return this.realFont.hadMappingOperations();
    }

    @Override
    public boolean hasChar(char c) {
        this.load(true);
        return this.realFont.hasChar(c);
    }

    @Override
    public boolean isMultiByte() {
        this.load(true);
        return this.realFont.isMultiByte();
    }

    @Override
    public String getFontName() {
        this.load(true);
        return this.realFont.getFontName();
    }

    @Override
    public String getEmbedFontName() {
        this.load(true);
        return this.realFont.getEmbedFontName();
    }

    @Override
    public String getFullName() {
        this.load(true);
        return this.realFont.getFullName();
    }

    @Override
    public Set<String> getFamilyNames() {
        this.load(true);
        return this.realFont.getFamilyNames();
    }

    @Override
    public int getMaxAscent(int size) {
        this.load(true);
        return this.realFont.getMaxAscent(size);
    }

    @Override
    public int getAscender(int size) {
        this.load(true);
        return this.realFont.getAscender(size);
    }

    @Override
    public int getCapHeight(int size) {
        this.load(true);
        return this.realFont.getCapHeight(size);
    }

    @Override
    public int getDescender(int size) {
        this.load(true);
        return this.realFont.getDescender(size);
    }

    @Override
    public int getXHeight(int size) {
        this.load(true);
        return this.realFont.getXHeight(size);
    }

    @Override
    public int getWidth(int i, int size) {
        this.load(true);
        return this.realFont.getWidth(i, size);
    }

    @Override
    public int[] getWidths() {
        this.load(true);
        return this.realFont.getWidths();
    }

    @Override
    public boolean hasKerningInfo() {
        this.load(true);
        return this.realFont.hasKerningInfo();
    }

    @Override
    public Map<Integer, Map<Integer, Integer>> getKerningInfo() {
        this.load(true);
        return this.realFont.getKerningInfo();
    }

    @Override
    public int getCapHeight() {
        this.load(true);
        return this.realFontDescriptor.getCapHeight();
    }

    @Override
    public int getDescender() {
        this.load(true);
        return this.realFontDescriptor.getDescender();
    }

    @Override
    public int getAscender() {
        this.load(true);
        return this.realFontDescriptor.getAscender();
    }

    @Override
    public int getFlags() {
        this.load(true);
        return this.realFontDescriptor.getFlags();
    }

    @Override
    public boolean isSymbolicFont() {
        this.load(true);
        return this.realFontDescriptor.isSymbolicFont();
    }

    @Override
    public int[] getFontBBox() {
        this.load(true);
        return this.realFontDescriptor.getFontBBox();
    }

    @Override
    public int getItalicAngle() {
        this.load(true);
        return this.realFontDescriptor.getItalicAngle();
    }

    @Override
    public int getStemV() {
        this.load(true);
        return this.realFontDescriptor.getStemV();
    }

    @Override
    public FontType getFontType() {
        this.load(true);
        return this.realFontDescriptor.getFontType();
    }

    @Override
    public boolean isEmbeddable() {
        this.load(true);
        return this.realFontDescriptor.isEmbeddable();
    }

    @Override
    public boolean performsSubstitution() {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).performsSubstitution();
        }
        return false;
    }

    @Override
    public CharSequence performSubstitution(CharSequence cs, String script, String language) {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).performSubstitution(cs, script, language);
        }
        return cs;
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence cs, int[][] gpa, String script, String language) {
        this.load(true);
        if (this.realFontDescriptor instanceof Substitutable) {
            return ((Substitutable)((Object)this.realFontDescriptor)).reorderCombiningMarks(cs, gpa, script, language);
        }
        return cs;
    }

    @Override
    public boolean performsPositioning() {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performsPositioning();
        }
        return false;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language, int fontSize) {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performPositioning(cs, script, language, fontSize);
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language) {
        this.load(true);
        if (this.realFontDescriptor instanceof Positionable) {
            return ((Positionable)((Object)this.realFontDescriptor)).performPositioning(cs, script, language);
        }
        return null;
    }

    @Override
    public boolean isSubsetEmbedded() {
        this.load(true);
        if (this.realFont.isMultiByte() && this.embeddingMode == EmbeddingMode.FULL) {
            return false;
        }
        return this.realFont.isMultiByte();
    }
}

