/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFSerializer;
import org.apache.xmlgraphics.util.DoubleFormatUtil;

public final class IFUtil {
    private IFUtil() {
    }

    private static String format(double value) {
        if (value == -0.0) {
            value = 0.0;
        }
        StringBuffer buf = new StringBuffer();
        DoubleFormatUtil.formatDouble((double)value, (int)6, (int)6, (StringBuffer)buf);
        return buf.toString();
    }

    public static StringBuffer toString(AffineTransform transform, StringBuffer sb) {
        if (transform.isIdentity()) {
            return sb;
        }
        double[] matrix = new double[6];
        transform.getMatrix(matrix);
        if (matrix[0] == 1.0 && matrix[3] == 1.0 && matrix[1] == 0.0 && matrix[2] == 0.0) {
            sb.append("translate(");
            sb.append(IFUtil.format(matrix[4]));
            if (matrix[5] != 0.0) {
                sb.append(',').append(IFUtil.format(matrix[5]));
            }
        } else {
            sb.append("matrix(");
            for (int i = 0; i < 6; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(IFUtil.format(matrix[i]));
            }
        }
        sb.append(')');
        return sb;
    }

    public static StringBuffer toString(AffineTransform[] transforms, StringBuffer sb) {
        int c = transforms.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            IFUtil.toString(transforms[i], sb);
        }
        return sb;
    }

    public static String toString(AffineTransform[] transforms) {
        return IFUtil.toString(transforms, new StringBuffer()).toString();
    }

    public static String toString(AffineTransform transform) {
        return IFUtil.toString(transform, new StringBuffer()).toString();
    }

    public static String toString(int[] coordinates) {
        if (coordinates == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int c = coordinates.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(Integer.toString(coordinates[i]));
        }
        return sb.toString();
    }

    public static String toString(Rectangle rect) {
        if (rect == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(rect.x).append(' ').append(rect.y).append(' ');
        sb.append(rect.width).append(' ').append(rect.height);
        return sb.toString();
    }

    public static void setupFonts(IFDocumentHandler documentHandler, FontInfo fontInfo) throws FOPException {
        IFDocumentHandlerConfigurator configurator;
        IFSerializer serializer;
        if (fontInfo == null) {
            fontInfo = new FontInfo();
        }
        if (documentHandler instanceof IFSerializer && (serializer = (IFSerializer)documentHandler).getMimickedDocumentHandler() != null) {
            documentHandler = serializer.getMimickedDocumentHandler();
        }
        if ((configurator = documentHandler.getConfigurator()) != null) {
            configurator.setupFontInfo(documentHandler.getMimeType(), fontInfo);
            documentHandler.setFontInfo(fontInfo);
        } else {
            documentHandler.setDefaultFontInfo(fontInfo);
        }
    }

    public static void setupFonts(IFDocumentHandler documentHandler) throws FOPException {
        IFUtil.setupFonts(documentHandler, null);
    }

    public static String getEffectiveMIMEType(IFDocumentHandler documentHandler) {
        IFDocumentHandler mimic;
        if (documentHandler instanceof IFSerializer && (mimic = ((IFSerializer)documentHandler).getMimickedDocumentHandler()) != null) {
            return mimic.getMimeType();
        }
        return documentHandler.getMimeType();
    }

    public static int[] convertDPToDX(int[][] dp, int count) {
        int[] dx;
        if (dp != null) {
            dx = new int[count];
            int n = count;
            for (int i = 0; i < n; ++i) {
                dx[i] = dp[i][0];
            }
        } else {
            dx = null;
        }
        return dx;
    }

    public static int[] convertDPToDX(int[][] dp) {
        return IFUtil.convertDPToDX(dp, dp != null ? dp.length : 0);
    }

    public static int[][] convertDXToDP(int[] dx, int count) {
        int[][] dp;
        if (dx != null) {
            dp = new int[count][4];
            int n = count;
            for (int i = 0; i < n; ++i) {
                int d;
                int[] pa = dp[i];
                pa[0] = d = dx[i];
                pa[2] = d;
            }
        } else {
            dp = null;
        }
        return dp;
    }

    public static int[][] convertDXToDP(int[] dx) {
        return IFUtil.convertDXToDP(dx, dx != null ? dx.length : 0);
    }

    public static boolean isPAIdentity(int[] pa) {
        if (pa == null) {
            return true;
        }
        for (int k = 0; k < 4; ++k) {
            if (pa[k] == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDPIdentity(int[][] dp) {
        if (dp == null) {
            return true;
        }
        int n = dp.length;
        for (int i = 0; i < n; ++i) {
            if (IFUtil.isPAIdentity(dp[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isDPOnlyDX(int[][] dp) {
        if (dp == null) {
            return false;
        }
        for (int[] pa : dp) {
            if (pa[0] == pa[2]) continue;
            return false;
        }
        return true;
    }

    public static void adjustPA(int[] paDst, int[] paSrc) {
        if (paDst != null && paSrc != null) {
            assert (paDst.length == 4);
            assert (paSrc.length == 4);
            for (int i = 0; i < 4; ++i) {
                int n = i;
                paDst[n] = paDst[n] + paSrc[i];
            }
        }
    }

    public static int[][] copyDP(int[][] dp, int offset, int count) {
        if (dp == null || offset > dp.length || offset + count > dp.length) {
            throw new IllegalArgumentException();
        }
        int[][] dpNew = new int[count][4];
        int n = count;
        for (int i = 0; i < n; ++i) {
            int[] paDst = dpNew[i];
            int[] paSrc = dp[i + offset];
            for (int k = 0; k < 4; ++k) {
                paDst[k] = paSrc[k];
            }
        }
        return dpNew;
    }
}

