/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.FontMetricsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomFontMetricsMapper
extends Typeface
implements FontMetricsMapper {
    private Typeface typeface;
    private Font font;
    private float size = 1.0f;
    private static final int TYPE1_FONT = 1;

    public CustomFontMetricsMapper(CustomFont fontMetrics) throws FontFormatException, IOException {
        this.typeface = fontMetrics;
        this.initialize(fontMetrics.getInputStream());
    }

    public CustomFontMetricsMapper(LazyFont fontMetrics, InputStream fontSource) throws FontFormatException, IOException {
        this.typeface = fontMetrics;
        this.initialize(fontSource);
    }

    private void initialize(InputStream inStream) throws FontFormatException, IOException {
        int type = 0;
        if (FontType.TYPE1.equals(this.typeface.getFontType())) {
            type = 1;
        }
        this.font = Font.createFont(type, inStream);
        inStream.close();
    }

    @Override
    public final String getEncodingName() {
        return null;
    }

    @Override
    public final boolean hasChar(char c) {
        return this.font.canDisplay(c);
    }

    @Override
    public final char mapChar(char c) {
        return this.typeface.mapChar(c);
    }

    @Override
    public final Font getFont(int size) {
        if (this.size == (float)size) {
            return this.font;
        }
        this.size = (float)size / 1000.0f;
        this.font = this.font.deriveFont(this.size);
        return this.font;
    }

    @Override
    public final int getAscender(int size) {
        return this.typeface.getAscender(size);
    }

    @Override
    public final int getCapHeight(int size) {
        return this.typeface.getCapHeight(size);
    }

    @Override
    public final int getDescender(int size) {
        return this.typeface.getDescender(size);
    }

    @Override
    public final String getEmbedFontName() {
        return this.typeface.getEmbedFontName();
    }

    @Override
    public final Set<String> getFamilyNames() {
        return this.typeface.getFamilyNames();
    }

    @Override
    public final String getFontName() {
        return this.typeface.getFontName();
    }

    @Override
    public final FontType getFontType() {
        return this.typeface.getFontType();
    }

    @Override
    public final String getFullName() {
        return this.typeface.getFullName();
    }

    public final Map getKerningInfo() {
        return this.typeface.getKerningInfo();
    }

    @Override
    public final int getWidth(int i, int size) {
        return this.typeface.getWidth(i, size);
    }

    @Override
    public final int[] getWidths() {
        return this.typeface.getWidths();
    }

    @Override
    public final int getXHeight(int size) {
        return this.typeface.getXHeight(size);
    }

    @Override
    public final boolean hasKerningInfo() {
        return this.typeface.hasKerningInfo();
    }
}

