/*
 * Decompiled with CFR 0.152.
 */
package de.obj.db.task;

import de.obj.utils.XMLPrintWriter2;
import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.Table;
import de.timeglobe.db.BackupTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import net.obj.task.AbstractTask;
import net.obj.task.NotificationTyp;
import net.obj.task.TaskInfo;

public abstract class AbstractBackupByXMLStructureTask
extends AbstractTask {
    private boolean schemaOnly = false;
    int totalTables = 0;
    int doneTables = 0;
    Object taskInfoSync = new Object();
    String proccessText = "";

    public AbstractBackupByXMLStructureTask() {
        super("XML Backup");
    }

    @Override
    public int getKind() {
        return 20;
    }

    protected abstract PrintWriter getPrintWriter();

    protected abstract void closePrintWriter(PrintWriter var1);

    protected abstract Connection getConnection() throws Exception;

    protected abstract void closeConnection(Connection var1);

    protected abstract String getBackupDir();

    protected abstract String getFileName();

    protected abstract Catalog getCatalog(Connection var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        block37: {
            this.sendUpdate();
            if (this.schemaOnly) {
                System.err.println("Start Export schema");
            } else {
                System.err.println("Start Backup");
            }
            PrintWriter w = this.getPrintWriter();
            File bf = null;
            try {
                try {
                    Object catalog;
                    w.flush();
                    ZipOutputStream target = null;
                    XMLPrintWriter2 xw = null;
                    Connection c = null;
                    try {
                        c = this.getConnection();
                        catalog = this.getCatalog(c);
                        Manifest manifest = new Manifest();
                        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
                        File dir = new File(this.getBackupDir());
                        dir.mkdirs();
                        File baf = new File(dir, String.valueOf(this.getFileName()) + ".jar");
                        if (this.schemaOnly) {
                            w.println("Export schema to " + baf.getAbsolutePath());
                        } else {
                            w.println("Backup to " + baf.getAbsolutePath());
                        }
                        w.flush();
                        target = new JarOutputStream((OutputStream)new FileOutputStream(baf), manifest);
                        xw = new XMLPrintWriter2(new PrintWriter(new OutputStreamWriter((OutputStream)target, "UTF-8")));
                        this.totalTables = ((Catalog)catalog).getTables().size();
                        for (String tn : ((Catalog)catalog).getTables().keySet()) {
                            if (this.isStop()) {
                                if (this.schemaOnly) {
                                    w.println("Stopped - Schema incomplete.");
                                    break;
                                }
                                w.println("Stopped - Backup incomplete.");
                                break;
                            }
                            Table t = ((Catalog)catalog).getTables().get(tn);
                            BackupTable bu = new BackupTable(t.getName(), xw, (JarOutputStream)target, w);
                            try {
                                if (this.schemaOnly) {
                                    w.println("Exporting schema " + t.getName());
                                    t.writeTableMetadata(c, bu, w);
                                } else {
                                    w.println("Exporting " + t.getName());
                                    t.backupTableWithMeta(c, bu, w);
                                }
                                w.flush();
                            }
                            catch (SQLException ex) {
                                ex.printStackTrace();
                            }
                            bu.closeEntry();
                            Object object = this.taskInfoSync;
                            synchronized (object) {
                                ++this.doneTables;
                                this.proccessText = String.valueOf(this.doneTables) + "/" + this.totalTables;
                            }
                            this.sendUpdate(NotificationTyp.INFO, this.proccessText);
                        }
                        if (this.schemaOnly) {
                            w.println("Schema created.");
                        } else {
                            w.println("Backup created.");
                        }
                        w.flush();
                        bf = baf;
                    }
                    finally {
                        if (c != null) {
                            this.closeConnection(c);
                        }
                        if (target != null) {
                            target.close();
                        }
                    }
                    if (bf == null) break block37;
                    catalog = this.taskInfoSync;
                    synchronized (catalog) {
                        this.proccessText = " \u00dcbermittle Backup ";
                    }
                    this.sendUpdate(NotificationTyp.INFO, this.proccessText);
                    try {
                        this.transferBackup(bf);
                        catalog = this.taskInfoSync;
                        synchronized (catalog) {
                            this.proccessText = " Backup \u00fcbermittelt";
                        }
                        this.sendUpdate(NotificationTyp.INFO, this.proccessText);
                    }
                    catch (Exception ex) {
                        this.sendUpdate(NotificationTyp.ERROR, "TransferOfBackupFailed");
                        w.println("Transfer failed");
                        ex.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    this.sendUpdate(NotificationTyp.ERROR, "backupFailed");
                    throw e;
                }
                catch (UnsupportedEncodingException e) {
                    this.sendUpdate(NotificationTyp.ERROR, "backupFailed");
                    throw e;
                }
                catch (IOException e) {
                    this.sendUpdate(NotificationTyp.ERROR, "backupFailed");
                    throw e;
                }
            }
            finally {
                this.closePrintWriter(w);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskInfo getTaskInfo() {
        TaskInfo ti = super.getTaskInfo();
        Object object = this.taskInfoSync;
        synchronized (object) {
            ti.setProcessText(this.proccessText);
        }
        return ti;
    }

    protected void transferBackup(File file) {
    }

    public boolean isSchemaOnly() {
        return this.schemaOnly;
    }

    public void setSchemaOnly(boolean schemaOnly) {
        this.schemaOnly = schemaOnly;
    }
}

