/*
 * Decompiled with CFR 0.152.
 */
package de.obj.db.task;

import de.obj.db.task.BackupException;
import de.obj.utils.FileUtils;
import de.obj.utils.ICompression;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Statement;
import net.obj.task.AbstractTask;

public abstract class BackupByDerbyFreezeTask
extends AbstractTask {
    ICompression compress;
    Boolean isStopped = false;
    private String databaseLocation;

    public BackupByDerbyFreezeTask() {
        super("Derby Freeze Backup");
    }

    protected abstract PrintWriter getPrintWriter();

    protected abstract void closePrintWriter(PrintWriter var1);

    protected abstract Connection getConnection() throws Exception;

    protected abstract void closeConnection(Connection var1);

    protected abstract String getBackupDir();

    protected abstract String getFileName();

    protected abstract String getDataBaseLocation();

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public void execute() throws Exception {
        this.backupDatabase(this.getConnection(), this.getBackupDir(), this.getFileName(), this.getPrintWriter());
    }

    private void backupDatabase(Connection connection, String backupDir, String fileName, PrintWriter w) throws Exception {
        block9: {
            try {
                if (this.databaseLocation != null) {
                    if (!backupDir.endsWith("/") || !backupDir.endsWith("\\")) {
                        backupDir = String.valueOf(backupDir) + File.separator;
                    }
                    String fileLocation = String.valueOf(backupDir) + fileName;
                    Statement s = connection.createStatement();
                    s.executeUpdate("CALL SYSCS_UTIL.SYSCS_FREEZE_DATABASE()");
                    if (!this.isStop()) {
                        FileUtils utils = new FileUtils();
                        utils.copySourceToTarget(this.getDatabaseLocation(), fileLocation);
                    } else {
                        w.println("Did not copy anything");
                        w.flush();
                    }
                    s.executeUpdate("CALL SYSCS_UTIL.SYSCS_UNFREEZE_DATABASE()");
                    s.close();
                    this.closeConnection(connection);
                    w.println("Backup to " + fileLocation);
                    w.flush();
                    break block9;
                }
                w.println("No databaseLocation for copy operation set");
                w.flush();
                throw new BackupException("No databaseLocation for copy operation set");
            }
            finally {
                this.closePrintWriter(w);
            }
        }
    }

    private Boolean compressBackup(String dataBaseLocation, String fileLocation, PrintWriter w) {
        if (this.compress != null) {
            w.println("Compress " + dataBaseLocation + " to " + fileLocation + this.compress.getCompressionSuffix());
            this.compress.compressSourceToTarget(dataBaseLocation, String.valueOf(fileLocation) + this.compress.getCompressionSuffix());
            return true;
        }
        return false;
    }

    public void setCompress(ICompression compress) {
        this.compress = compress;
    }

    public String getDatabaseLocation() {
        return this.databaseLocation;
    }

    public void setDatabaseLocation(String databaselocation) {
        this.databaseLocation = databaselocation;
    }
}

