/*
 * Decompiled with CFR 0.152.
 */
package de.obj.db.task;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class CleanUpBackupsTasks {
    private String backupDirectory;
    private long deleteFromTimeStamp;

    public void setBackupDirectory(String backupDirectory) {
        this.backupDirectory = backupDirectory;
    }

    public void cleanUp() {
        Path sourcePath = Paths.get(this.backupDirectory, new String[0]);
        try {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.creationTime().toMillis() <= CleanUpBackupsTasks.this.deleteFromTimeStamp) {
                        Files.delete(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public long getDeleteFromTimeStamp() {
        return this.deleteFromTimeStamp;
    }

    public void setDeleteFromTimeStamp(long deleteFromTimeStamp) {
        this.deleteFromTimeStamp = deleteFromTimeStamp;
    }
}

