/*
 * Decompiled with CFR 0.152.
 */
package de.obj.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;

public class XMLPrintWriter2 {
    private PrintWriter out;
    private PrintStream ps;

    public XMLPrintWriter2(PrintWriter out) {
        this.out = out;
    }

    public XMLPrintWriter2(PrintStream ps) {
        this.ps = ps;
    }

    public void print(String s) throws IOException {
        if (this.ps != null) {
            this.ps.print(s);
        } else {
            this.out.print(s);
        }
    }

    public void println(String s) throws IOException {
        if (this.ps != null) {
            this.ps.println(s);
        } else {
            this.out.println(s);
        }
    }

    public static String quoteString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer result = null;
        int i = 0;
        int max = s.length();
        int delta = 0;
        while (i < max) {
            char c = s.charAt(i);
            String replacement = null;
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '\r') {
                replacement = "&#13;";
            } else if (c == '\n') {
                replacement = "&#10;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '\'') {
                replacement = "&apos;";
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuffer(s);
                }
                result.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    public void printQuoted(String s) throws IOException {
        if (s == null) {
            return;
        }
        this.print(XMLPrintWriter2.quoteString(s));
    }

    public void printTagQuoted(String tag, String content) throws IOException {
        if (content != null) {
            this.print("<" + tag + ">");
            this.printQuoted(content);
            this.println("</" + tag + ">");
        }
    }

    public void printAttribute(String key, Object value) throws IOException {
        if (value != null) {
            if (value.toString().trim().equals("")) {
                return;
            }
            this.print(" " + key + "=\"");
            this.printQuoted(value.toString());
            this.print("\"");
        }
    }

    public void printAttribute2(String key, Object value) throws IOException {
        this.print(" " + key + "=\"");
        this.printQuoted(value == null ? "" : value.toString());
        this.print("\"");
    }

    public void flush() {
        if (this.ps != null) {
            this.ps.flush();
        } else {
            this.out.flush();
        }
    }

    public void close() {
        if (this.ps != null) {
            this.ps.flush();
            this.ps.close();
        } else {
            this.out.flush();
            this.out.close();
        }
    }
}

