/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.ForeignKey;
import de.timeglobe.catalog.ForeignKeyColumn;
import de.timeglobe.catalog.Index;
import de.timeglobe.catalog.IndexColumn;
import de.timeglobe.catalog.PrimaryKeyColumn;
import de.timeglobe.catalog.SqlType;
import de.timeglobe.catalog.Table;
import de.timeglobe.catalog.TableColumn;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BackupCatalog {
    public Catalog load(JarFile f, String dbName) throws IOException {
        Catalog c = new Catalog(dbName);
        this.readMeta(f, c);
        return c;
    }

    public Catalog load(File f, String name) throws IOException {
        JarFile jf = new JarFile(f);
        return this.load(jf, name);
    }

    private void readMeta(JarFile jarFile, Catalog c) throws IOException {
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (!entry.getName().toLowerCase().endsWith(".xml")) continue;
            this.parse(jarFile.getInputStream(entry), c);
        }
    }

    private void parse(InputStream in, Catalog c) throws IOException {
        RestoreHandler handler = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            handler = new RestoreHandler(c);
            InputSource inputSource = new InputSource(in);
            saxParser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXParseException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            if (!e.getMessage().equals("stop here")) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class RestoreHandler
    extends DefaultHandler {
        private Catalog catalog;
        private Table table;
        private ForeignKey foreignKey;
        private Index index;
        private TableColumn tableColumn;
        private ForeignKeyColumn foreignKeyColumn;
        private IndexColumn indexColumn;

        public RestoreHandler(Catalog catalog) throws SQLException {
            this.catalog = catalog;
        }

        @Override
        public void endElement(String uri, String localname, String qname) throws SAXException {
            try {
                if (qname.equals("m")) {
                    this.catalog.addTable(this.table);
                    throw new SAXException("stop here");
                }
                if (qname.equals("i")) {
                    this.table.addIndex(this.index);
                    this.index = null;
                } else if (qname.equals("f")) {
                    this.table.addForeignKey(this.foreignKey);
                    this.foreignKey = null;
                } else if (qname.equals("t")) {
                    this.catalog.addTable(this.table);
                    this.table = null;
                } else if (qname.equals("d")) {
                    this.table.addTableColumn(this.tableColumn);
                    this.tableColumn = null;
                } else if (qname.equals("fc")) {
                    this.foreignKey.addForeignKeyColumn(this.foreignKeyColumn);
                    this.foreignKeyColumn = null;
                } else if (qname.equals("ic")) {
                    this.index.addIndexColumn(this.indexColumn);
                    this.indexColumn = null;
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            if (qname.equals("t")) {
                String tn = attributes.getValue("n");
                this.table = new Table(tn);
                return;
            } else if (qname.equals("i")) {
                if (this.table == null || this.index != null) return;
                boolean unique = false;
                String de = attributes.getValue("ui");
                if (de != null && de.equalsIgnoreCase("1")) {
                    unique = true;
                }
                this.index = new Index(this.table, attributes.getValue("n"), unique);
                return;
            } else if (qname.equals("f")) {
                if (this.table == null || this.foreignKey != null) return;
                try {
                    this.foreignKey = new ForeignKey(this.table, attributes.getValue("n"), attributes.getValue("ref"));
                    return;
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            } else if (qname.equals("d")) {
                if (this.table == null) return;
                try {
                    SqlType sqlType = this.parseIntString(attributes.getValue("t"));
                    String pk = attributes.getValue("pk");
                    boolean isIdentity = false;
                    String ident = attributes.getValue("ident");
                    if (ident != null && ident.equalsIgnoreCase("1")) {
                        isIdentity = true;
                    }
                    if (pk != null) {
                        if (!pk.equalsIgnoreCase("1")) return;
                        this.tableColumn = new PrimaryKeyColumn(attributes.getValue("n"), sqlType, isIdentity);
                        return;
                    }
                    boolean nulls = true;
                    String nn = attributes.getValue("nn");
                    if (nn != null && nn.equalsIgnoreCase("1")) {
                        nulls = false;
                    }
                    this.tableColumn = new TableColumn(attributes.getValue("n"), sqlType, nulls, isIdentity);
                    return;
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            } else if (qname.equals("fc")) {
                if (this.foreignKey == null) return;
                this.foreignKeyColumn = new ForeignKeyColumn(attributes.getValue("n"), attributes.getValue("ref"));
                return;
            } else {
                if (!qname.equals("ic") || this.index == null) return;
                boolean desc = false;
                String de = attributes.getValue("sort");
                if (de != null && de.equalsIgnoreCase("desc")) {
                    desc = true;
                }
                this.indexColumn = new IndexColumn(attributes.getValue("n"), desc);
            }
        }

        private SqlType parseIntString(String typeText) throws Exception {
            int type;
            SqlType sqlType = null;
            int length = 0;
            int precision = 0;
            int detailsStart = typeText.indexOf("(");
            if (detailsStart == -1) {
                type = Integer.valueOf(typeText);
            } else {
                int comma = typeText.indexOf(",");
                type = Integer.valueOf(typeText.substring(0, detailsStart));
                if (comma == -1) {
                    length = Integer.valueOf(typeText.substring(detailsStart + 1, typeText.length() - 1));
                } else {
                    length = Integer.valueOf(typeText.substring(detailsStart + 1, comma));
                    precision = Integer.valueOf(typeText.substring(comma + 1, typeText.length() - 1));
                }
            }
            sqlType = new SqlType(type, length, precision);
            return sqlType;
        }
    }
}

