/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import de.obj.utils.XMLPrintWriter2;
import de.timeglobe.catalog.CatalogUtils;
import de.timeglobe.catalog.ForeignKey;
import de.timeglobe.catalog.IBackupWriter;
import de.timeglobe.catalog.Index;
import de.timeglobe.catalog.Table;
import de.timeglobe.catalog.View;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Vector;

public class Catalog
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MSSQL = 1;
    public static final int DERBY = 2;
    public static final int PGSQL = 3;
    private final LinkedHashMap<String, Table> tables = new LinkedHashMap();
    private final LinkedHashMap<String, View> views = new LinkedHashMap();
    private String name;

    public Catalog(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LinkedHashMap<String, Table> getTables() {
        return this.tables;
    }

    public Table addTable(Table table) {
        this.tables.put(table.getName(), table);
        return table;
    }

    public Table getTable(String name) {
        return this.tables.get(name);
    }

    public View addView(View view) {
        this.views.put(view.getName(), view);
        return view;
    }

    public View getView(String name) {
        return this.views.get(name);
    }

    public void solveReferences() throws Exception {
        for (String tn : this.tables.keySet()) {
            Table t = this.tables.get(tn);
            t.solveReferences(this);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<catalog name=\"" + this.name + "\">");
        for (String tn : this.tables.keySet()) {
            Table t = this.tables.get(tn);
            buf.append(t);
        }
        buf.append("</catalog>");
        return buf.toString();
    }

    public void dropTables(Connection c, int dialect, boolean failOnError, PrintWriter printWriter) throws SQLException {
        for (String tn : this.tables.keySet()) {
            Table t = this.tables.get(tn);
            printWriter.println("Drop table: " + t.getName());
            Throwable throwable = null;
            Object var9_10 = null;
            try (Statement s = c.createStatement();){
                String sql = t.getDDLDrop(dialect);
                try {
                    s.executeUpdate(sql);
                }
                catch (SQLException e) {
                    printWriter.println("SQL:" + sql + " results in error: " + e.getMessage());
                    if (!failOnError) continue;
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void exportCatalog(Connection c, IBackupWriter backUpWriter, XMLPrintWriter2 xmlWriter, PrintWriter printWriter) throws SQLException, IOException {
        xmlWriter.println("<c>");
        for (String tn : this.getTables().keySet()) {
            Table t = this.getTables().get(tn);
            backUpWriter.writeTableMetadata(t);
            xmlWriter.println("</t>");
            xmlWriter.flush();
        }
        xmlWriter.println("</c>");
        xmlWriter.flush();
    }

    public void dropViews(Connection c, int dialect, boolean failOnError, PrintWriter printWriter) throws SQLException {
        for (String tn : this.views.keySet()) {
            View t = this.views.get(tn);
            Throwable throwable = null;
            Object var9_10 = null;
            try (Statement s = c.createStatement();){
                String sql = t.getDDLDrop(dialect);
                try {
                    s.executeUpdate(sql);
                }
                catch (SQLException e) {
                    printWriter.println("SQL:" + sql + " results in error: " + e.getMessage());
                    if (!failOnError) continue;
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void createTables(Connection c, int dialect, boolean failOnError, PrintWriter printWriter) throws SQLException {
        for (String tn : this.tables.keySet()) {
            Table t = this.tables.get(tn);
            Throwable throwable = null;
            Object var9_10 = null;
            try (Statement s = c.createStatement();){
                String sql = t.getDDLCreate(dialect);
                printWriter.println("Create table: " + t.getName());
                try {
                    s.executeUpdate(sql);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    if (!failOnError) continue;
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public void createIndices(Connection c, int dialect, boolean failOnError, PrintWriter printWriter) throws SQLException {
        for (String tn : this.tables.keySet()) {
            Table t = this.tables.get(tn);
            printWriter.println("Create indices for table: " + t.getName());
            for (String in : t.getIndices().keySet()) {
                Index ix = t.getIndices().get(in);
                Throwable throwable = null;
                Object var12_13 = null;
                try (Statement s = c.createStatement();){
                    String sql = ix.getDDLCreate(dialect);
                    try {
                        s.executeUpdate(sql);
                        c.commit();
                    }
                    catch (SQLException e) {
                        System.err.println("SQL:" + sql + " results in error: " + e.getMessage());
                        printWriter.println("SQL:" + sql + " results in error: " + e.getMessage());
                        if (!failOnError) continue;
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void dropIndices(Connection c, int dialect, boolean failOnError, PrintWriter printWriter) throws SQLException {
        for (String tn : this.tables.keySet()) {
            Table t = this.tables.get(tn);
            printWriter.println("Drop indices for table: " + t.getName());
            for (String in : t.getIndices().keySet()) {
                Index ix = t.getIndices().get(in);
                Throwable throwable = null;
                Object var12_13 = null;
                try (Statement s = c.createStatement();){
                    String sql = ix.getDDLDrop(dialect);
                    try {
                        s.executeUpdate(sql);
                    }
                    catch (SQLException e) {
                        System.err.println("SQL:" + sql + " results in error: " + e.getMessage());
                        printWriter.println("SQL:" + sql + " results in error: " + e.getMessage());
                        if (!failOnError) continue;
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void createForeignKeys(Connection c, int dialect, boolean failOnError, PrintWriter printWriter) throws SQLException {
        for (String tn : this.tables.keySet()) {
            Table t = this.tables.get(tn);
            printWriter.println("Create foreign keys for table: " + t.getName());
            for (String in : t.getForeignKeys().keySet()) {
                ForeignKey fk = t.getForeignKeys().get(in);
                Throwable throwable = null;
                Object var12_13 = null;
                try (Statement s = c.createStatement();){
                    String sql = fk.getDDLCreate(dialect);
                    try {
                        s.executeUpdate(sql);
                        c.commit();
                    }
                    catch (SQLException e) {
                        printWriter.println("SQL:" + sql + " results in error: " + e.getMessage());
                        System.err.println("SQL:" + sql + " results in error: " + e.getMessage());
                        if (!failOnError) continue;
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public void dropForeignKeys(Connection c, int dialect, boolean failOnError, PrintWriter printWriter) throws SQLException {
        for (String tn : this.tables.keySet()) {
            Table t = this.tables.get(tn);
            printWriter.println("Drop foreign keys for table: " + t.getName());
            for (String in : t.getForeignKeys().keySet()) {
                ForeignKey fk = t.getForeignKeys().get(in);
                Throwable throwable = null;
                Object var12_13 = null;
                try (Statement s = c.createStatement();){
                    String sql = fk.getDDLDrop(dialect);
                    try {
                        s.executeUpdate(sql);
                    }
                    catch (SQLException e) {
                        printWriter.println("SQL:" + sql + " results in error: " + e.getMessage());
                        System.err.println("SQL:" + sql + " results in error: " + e.getMessage());
                        if (!failOnError) continue;
                        throw e;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    public String getHash() throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuffer b = new StringBuffer();
        for (String n : this.tables.keySet()) {
            b.append(this.tables.get(n).getHash());
        }
        return CatalogUtils.getHash(b.toString());
    }

    public boolean compare(Catalog o, boolean stopCompareOnDiff) {
        for (String n : this.tables.keySet()) {
            Table tableA;
            block7: {
                tableA = this.tables.get(n);
                Table tableB = o.tables.get(n);
                if (tableB == null) break block7;
                if (tableA.getHash().equals(tableB.getHash())) continue;
                System.err.println(String.valueOf(tableA.getName()) + ": " + tableA.getHash() + " : " + tableB.getHash());
                tableA.compare(tableB, stopCompareOnDiff);
                if (!stopCompareOnDiff) continue;
                return false;
            }
            try {
                System.err.println(String.valueOf(tableA.getName()) + ": " + tableA.getHash() + " : ");
                if (!stopCompareOnDiff) continue;
                return false;
            }
            catch (InvalidKeyException e) {
                e.printStackTrace();
            }
            catch (SignatureException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public boolean compare(Catalog template, Vector<String> ddls) {
        Table tableTemplate;
        Table table;
        boolean changes = false;
        for (String key : template.tables.keySet()) {
            Table tableTemplate2 = template.tables.get(key);
            Table table2 = this.tables.get(key);
            if (table2 != null) continue;
            ddls.add("create table " + tableTemplate2.getName());
            changes = true;
        }
        for (String key : this.tables.keySet()) {
            table = this.tables.get(key);
            tableTemplate = template.tables.get(key);
            if (tableTemplate != null) continue;
            ddls.add("drop table " + table.getName());
            changes = true;
        }
        for (String key : this.tables.keySet()) {
            table = this.tables.get(key);
            tableTemplate = template.tables.get(key);
            if (tableTemplate == null || !table.compareColumns(tableTemplate, ddls)) continue;
            changes = true;
        }
        return true;
    }
}

