/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.ForeignKey;
import de.timeglobe.catalog.ForeignKeyColumn;
import de.timeglobe.catalog.Index;
import de.timeglobe.catalog.IndexColumn;
import de.timeglobe.catalog.PrimaryKeyColumn;
import de.timeglobe.catalog.SqlType;
import de.timeglobe.catalog.Table;
import de.timeglobe.catalog.TableColumn;
import de.timeglobe.catalog.View;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.Vector;

public class JdbcCatalog {
    public Catalog load(Connection c, int dialect, String databaseName) throws Exception {
        return this.load(c, dialect, databaseName, null, true);
    }

    public Catalog load(Connection c, int dialect, String databaseName, Vector<String> skipTables, boolean validate) throws Exception {
        String tableName;
        String tn;
        ResultSet r;
        String metaCatalog;
        String string = metaCatalog = dialect == 2 ? null : databaseName;
        String metaSchemaPattern = dialect == 2 ? "APP" : (dialect == 1 ? "dbo" : null);
        DatabaseMetaData dbmd = c.getMetaData();
        Catalog catalog = new Catalog(databaseName);
        Throwable throwable = null;
        Object var11_13 = null;
        try {
            r = dbmd.getTables(metaCatalog, metaSchemaPattern, null, new String[]{"VIEW"});
            try {
                while (r.next()) {
                    tn = r.getString("TABLE_NAME");
                    tableName = tn.toLowerCase();
                    if (tableName.equals("sysdiagrams")) continue;
                    View view = new View(tableName);
                    catalog.addView(view);
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var11_13 = null;
        try {
            r = dbmd.getTables(metaCatalog, metaSchemaPattern, null, new String[]{"TABLE"});
            try {
                while (r.next()) {
                    Object r2;
                    Object r22;
                    tn = r.getString("TABLE_NAME");
                    tableName = tn.toLowerCase();
                    if (skipTables != null && skipTables.contains(tableName) || tableName.equals("sysdiagrams")) continue;
                    Table table = new Table(tableName);
                    catalog.addTable(table);
                    String cn = r.getString("TABLE_CAT");
                    String sn = r.getString("TABLE_SCHEM");
                    TreeMap<Integer, String> pk = new TreeMap<Integer, String>();
                    Hashtable<String, Integer> kp = new Hashtable<String, Integer>();
                    Throwable throwable3 = null;
                    Object var21_26 = null;
                    try {
                        r22 = dbmd.getPrimaryKeys(cn, sn, tn);
                        try {
                            while (r22.next()) {
                                int ks32 = r22.getInt("KEY_SEQ");
                                String pkcn = r22.getString("COLUMN_NAME").toLowerCase();
                                pk.put(new Integer(ks32), pkcn);
                                kp.put(pkcn, new Integer(ks32));
                            }
                        }
                        finally {
                            if (r22 != null) {
                                r22.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                    TreeMap<String, TableColumn> pkcols = new TreeMap<String, TableColumn>();
                    TreeMap<Integer, TableColumn> cols = new TreeMap<Integer, TableColumn>();
                    r22 = null;
                    Object ks32 = null;
                    try {
                        r2 = dbmd.getColumns(cn, sn, tn, null);
                        try {
                            while (r2.next()) {
                                TableColumn tabc;
                                String x;
                                int op = r2.getInt("ORDINAL_POSITION");
                                String coln = r2.getString("COLUMN_NAME").toLowerCase();
                                int sqlt = r2.getInt("DATA_TYPE");
                                int len = r2.getInt("COLUMN_SIZE");
                                int decimal = r2.getInt("DECIMAL_DIGITS");
                                SqlType sqlType = new SqlType(dialect, sqlt, len, decimal);
                                boolean nullable = r2.getInt("NULLABLE") == 1;
                                boolean isIdentity = false;
                                if (dialect == 2 && (x = r2.getString("IS_AUTOINCREMENT")) != null && x.equals("YES")) {
                                    isIdentity = true;
                                }
                                if (kp.get(coln) != null) {
                                    tabc = new PrimaryKeyColumn(coln, sqlType, isIdentity);
                                    pkcols.put(tabc.getName(), tabc);
                                    table.addTableColumn(tabc);
                                    continue;
                                }
                                tabc = new TableColumn(coln, sqlType, nullable, isIdentity);
                                cols.put(new Integer(op), tabc);
                                table.addTableColumn(tabc);
                            }
                        }
                        finally {
                            if (r2 != null) {
                                r2.close();
                            }
                        }
                    }
                    catch (Throwable ks32) {
                        if (r22 == null) {
                            r22 = ks32;
                        } else if (r22 != ks32) {
                            ((Throwable)r22).addSuppressed(ks32);
                        }
                        throw r22;
                    }
                    r22 = null;
                    ks32 = null;
                    try {
                        r2 = dbmd.getIndexInfo(cn, sn, tn, false, false);
                        try {
                            while (r2.next()) {
                                Index ind;
                                String indexName = r2.getString("INDEX_NAME");
                                if (indexName == null) continue;
                                if (dialect == 2) {
                                    if (indexName.startsWith("SQL")) {
                                        continue;
                                    }
                                } else if (dialect != 3 ? dialect != 1 || indexName.startsWith("PK__") : indexName.endsWith("_pkey")) continue;
                                if ((ind = table.getIndices().get(indexName)) == null) {
                                    boolean unique;
                                    if (dialect == 3) {
                                        String non_unique = r2.getString("NON_UNIQUE");
                                        unique = non_unique.equals("f");
                                    } else {
                                        unique = r2.getInt("NON_UNIQUE") != 1;
                                    }
                                    ind = new Index(table, indexName.toLowerCase(), unique);
                                    table.getIndices().put(indexName, ind);
                                }
                                boolean descending = r2.getString("ASC_OR_DESC") != "A";
                                IndexColumn indCol = new IndexColumn(r2.getString("COLUMN_NAME").toLowerCase(), descending);
                                ind.addIndexColumn(indCol);
                            }
                        }
                        finally {
                            if (r2 != null) {
                                r2.close();
                            }
                        }
                    }
                    catch (Throwable ks32) {
                        if (r22 == null) {
                            r22 = ks32;
                        } else if (r22 != ks32) {
                            ((Throwable)r22).addSuppressed(ks32);
                        }
                        throw r22;
                    }
                    LinkedHashMap<String, String> fkTab = new LinkedHashMap<String, String>();
                    LinkedHashMap<String, LinkedHashMap<String, String>> fkCols = new LinkedHashMap<String, LinkedHashMap<String, String>>();
                    r2 = null;
                    Iterator iterator = null;
                    try (ResultSet r23 = dbmd.getImportedKeys(cn, sn, tn);){
                        while (r23.next()) {
                            String fkn = r23.getString("fk_name").toLowerCase();
                            String reft = r23.getString("pktable_name").toLowerCase();
                            if (fkTab.get(fkn) == null) {
                                fkTab.put(fkn, reft);
                            }
                            String fkc = r23.getString("fkcolumn_name").toLowerCase();
                            String pkc = r23.getString("pkcolumn_name").toLowerCase();
                            LinkedHashMap<String, String> fkCol = (LinkedHashMap<String, String>)fkCols.get(fkn);
                            if (fkCol == null) {
                                fkCol = new LinkedHashMap<String, String>();
                                fkCols.put(fkn, fkCol);
                            }
                            fkCol.put(fkc, pkc);
                        }
                    }
                    catch (Throwable throwable5) {
                        if (r2 == null) {
                            r2 = throwable5;
                        } else if (r2 != throwable5) {
                            ((Throwable)r2).addSuppressed(throwable5);
                        }
                        throw r2;
                    }
                    for (String fkn : fkTab.keySet()) {
                        String pkt = (String)fkTab.get(fkn);
                        ForeignKey foreignKey = new ForeignKey(table, fkn, pkt);
                        LinkedHashMap fkCol = (LinkedHashMap)fkCols.get(fkn);
                        for (String fkc : fkCol.keySet()) {
                            String pkc = (String)fkCol.get(fkc);
                            foreignKey.addForeignKeyColumn(new ForeignKeyColumn(fkc, pkc));
                        }
                        table.addForeignKey(foreignKey);
                    }
                }
                if (validate) {
                    catalog.solveReferences();
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        return catalog;
    }
}

