/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import java.io.Serializable;
import java.text.ParseException;

public class SqlType
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int VARCHAR = 12;
    public static final int CHAR = 1;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int LONGVARBINARY = -4;
    public static final int DATETIME = 93;
    public static final int DOUBLE = 8;
    public static final int BYTE = -6;
    public static final int BOOLEAN = 16;
    public static final int SHORT = 5;
    public static final int INT = 4;
    public static final int LONG = -5;
    public static final int MSSQL_MAXVARCHAR_LENGTH = 8000;
    public static final int PGSQL_MAXVARCHAR_LENGTH = 8000;
    private int type;
    private int length;
    private int precision;

    public SqlType(String text) throws ParseException {
        this.parse(text);
    }

    public SqlType(int type, int length, int precision) throws Exception {
        this.type = type;
        this.length = length;
        this.precision = precision;
    }

    public SqlType(int dialect, int type, int length, int precision) throws Exception {
        this.type = type;
        this.length = length;
        this.precision = precision;
        switch (type) {
            case -9: {
                this.type = 12;
                break;
            }
            case 12: {
                break;
            }
            case 1: {
                break;
            }
            case 2005: {
                break;
            }
            case -1: {
                if (dialect != 1) break;
                this.type = 2005;
                break;
            }
            case -4: 
            case 2004: {
                break;
            }
            case 4: {
                break;
            }
            case -6: {
                break;
            }
            case -7: {
                this.type = 16;
                break;
            }
            case 16: {
                break;
            }
            case 5: {
                break;
            }
            case -5: {
                break;
            }
            case 93: {
                break;
            }
            case 8: {
                break;
            }
            case 2: 
            case 3: {
                this.type = 8;
                break;
            }
            default: {
                throw new ParseException("unable to assign type (exception): " + type, 0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(String text) throws ParseException {
        if (text == null) throw new ParseException("unable to parse sql type: " + text, 0);
        text = text.toLowerCase().trim();
        int l = text.indexOf(40);
        String typeName = text;
        int length = 0;
        int precision = 0;
        boolean hasLength = false;
        boolean hasPrecision = false;
        if (l > 0) {
            typeName = text.substring(0, l).trim();
            String s = text.substring(l + 1);
            if ((l = s.indexOf(41)) <= 0) throw new ParseException("unable to parse sql type (syntax): " + text, 0);
            String p = s.substring(0, l).replace('\t', ' ').replace(',', '\t');
            String[] ap = p.split("\t");
            if (ap.length == 1) {
                try {
                    length = Integer.parseInt(ap[0].trim());
                    hasLength = true;
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("unable to parse sql type (number format exception): " + ap[0], 0);
                }
            }
            if (ap.length != 2) throw new ParseException("unable to parse sql type (too many arguments): " + text, 0);
            try {
                length = Integer.parseInt(ap[0].trim());
                precision = Integer.parseInt(ap[1].trim());
                hasLength = true;
                hasPrecision = true;
            }
            catch (NumberFormatException ex) {
                throw new ParseException("unable to parse sql type (number format exception): " + text, 0);
            }
        }
        if (typeName.equals("varchar")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (!hasLength) {
                throw new ParseException("unable to parse sql type (missing length arg): " + text, 0);
            }
            this.type = 12;
        }
        if (typeName.equals("char")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (!hasLength) {
                throw new ParseException("unable to parse sql type (missing length arg): " + text, 0);
            }
            this.type = 1;
        } else if (typeName.equals("clob")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (!hasLength) {
                throw new ParseException("unable to parse sql type (missing length arg): " + text, 0);
            }
            this.type = 2005;
        } else if (typeName.equals("blob")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (!hasLength) {
                throw new ParseException("unable to parse sql type (missing length arg): " + text, 0);
            }
            this.type = 2004;
        } else if (typeName.equals("byte")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (hasLength) {
                throw new ParseException("unable to parse sql type (invalid length arg): " + text, 0);
            }
            this.type = -6;
        } else if (typeName.equals("short")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (hasLength) {
                throw new ParseException("unable to parse sql type (invalid length arg): " + text, 0);
            }
            this.type = 5;
        } else if (typeName.equals("int")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (hasLength) {
                throw new ParseException("unable to parse sql type (invalid length arg): " + text, 0);
            }
            this.type = 4;
        } else if (typeName.equals("long")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (hasLength) {
                throw new ParseException("unable to parse sql type (invalid length arg): " + text, 0);
            }
            this.type = -5;
        } else if (typeName.equals("boolean")) {
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            if (hasLength) {
                throw new ParseException("unable to parse sql type (invalid length arg): " + text, 0);
            }
            this.type = 16;
        } else if (typeName.equals("decimal")) {
            if (!hasLength) {
                throw new ParseException("unable to parse sql type (missing length arg): " + text, 0);
            }
            if (!hasPrecision) {
                throw new ParseException("unable to parse sql type (missing precision arg): " + text, 0);
            }
            if (precision > length) {
                throw new ParseException("unable to parse sql type (precision: bad value): " + text, 0);
            }
            this.type = 8;
        } else if (typeName.equals("datetime")) {
            if (hasLength) {
                throw new ParseException("unable to parse sql type (invalid length arg): " + text, 0);
            }
            if (hasPrecision) {
                throw new ParseException("unable to parse sql type (invalid precision arg): " + text, 0);
            }
            this.type = 93;
        }
        this.length = length;
        this.precision = precision;
    }

    public String toSqlString(int dialect) {
        switch (this.type) {
            case 12: {
                if (dialect == 1) {
                    return "VARCHAR(" + (this.length == 0 || this.length > 8000 ? "MAX" : Integer.valueOf(this.length)) + ")";
                }
                if (dialect == 3) {
                    return "VARCHAR(" + (this.length == 0 || this.length > 8000 ? "10485760" : Integer.valueOf(this.length)) + ")";
                }
                return "VARCHAR(" + (this.length == 0 ? "MAX" : Integer.valueOf(this.length)) + ")";
            }
            case 1: {
                if (dialect == 1) {
                    return "CHAR(" + (this.length == 0 || this.length > 8000 ? "MAX" : Integer.valueOf(this.length)) + ")";
                }
                if (dialect == 3) {
                    return "CHAR(" + (this.length == 0 || this.length > 8000 ? "10485760" : Integer.valueOf(this.length)) + ")";
                }
                return "CHAR(" + (this.length == 0 ? "MAX" : Integer.valueOf(this.length)) + ")";
            }
            case 2005: {
                return "CLOB(" + (this.length == 0 ? "MAX" : Integer.valueOf(this.length)) + ")";
            }
            case -4: {
                return "CLOB(" + (this.length == 0 ? "MAX" : Integer.valueOf(this.length)) + ")";
            }
            case 2004: {
                return "BLOB(" + (this.length == 0 ? "MAX" : Integer.valueOf(this.length)) + ")";
            }
            case 4: {
                return "INTEGER";
            }
            case -6: {
                if (dialect == 2 || dialect == 3) {
                    return "SMALLINT";
                }
                return "TINYINT";
            }
            case 16: {
                if (dialect == 2 || dialect == 3) {
                    return "SMALLINT";
                }
                return "BIT";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 93: {
                if (dialect == 2 || dialect == 3) {
                    return "TIMESTAMP";
                }
                return "DATETIME";
            }
            case 8: {
                return "DECIMAL(" + this.length + "," + this.precision + ")";
            }
        }
        return null;
    }

    public int getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public static void main(String[] args) {
        try {
            System.err.println(new SqlType("int").toSqlString(2));
            System.err.println(new SqlType("varchar  (2)").toSqlString(2));
            System.err.println(new SqlType("clob  (2)").toSqlString(2));
            System.err.println(new SqlType("blob  (0)").toSqlString(2));
            System.err.println(new SqlType("varchar  (2921)").toSqlString(2));
            System.err.println(new SqlType("varchar  (0)").toSqlString(2));
            System.err.println(new SqlType("boolean").toSqlString(2));
            System.err.println(new SqlType("byte").toSqlString(2));
            System.err.println(new SqlType("long").toSqlString(2));
            System.err.println(new SqlType("decimal  (2,1)").toSqlString(2));
            System.err.println(new SqlType("decimal   (12,2)").toSqlString(2));
            System.err.println(new SqlType(" short ").toSqlString(2));
            System.err.println(new SqlType("int  ").toSqlString(2));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public String toCompareString() {
        if (this.type == 8) {
            return "SqlType [derbySQL=" + this.toSqlString(2) + ", length=" + this.length + ", precision=" + this.precision + "]";
        }
        return "SqlType [derbySQL=" + this.toSqlString(2) + "]";
    }
}

