/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import de.timeglobe.catalog.AbstractColumn;
import de.timeglobe.catalog.CatalogUtils;
import de.timeglobe.catalog.SqlType;
import de.timeglobe.catalog.Table;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Vector;

public class TableColumn
extends AbstractColumn {
    private static final long serialVersionUID = 1L;
    private boolean nullable;
    private SqlType sqlType;
    private String renderingHints;
    private boolean isIdentity;

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public void setIdentity(boolean isIdentity) {
        this.isIdentity = isIdentity;
    }

    public TableColumn(String name, SqlType sqlType, boolean nullable, boolean isIdentity) {
        super(name);
        this.sqlType = sqlType;
        this.setNullable(nullable);
        this.setIdentity(isIdentity);
    }

    public TableColumn(String name, SqlType sqlType, boolean nullable) {
        super(name);
        this.sqlType = sqlType;
        this.setNullable(nullable);
        this.setIdentity(false);
    }

    public TableColumn(String name) {
        super(name);
        this.setNullable(true);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public SqlType getSqlType() {
        return this.sqlType;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<column name=\"" + this.getName() + "\" sqlType=\"" + this.getSqlType().toSqlString(1) + "\"/>\n");
        return buf.toString();
    }

    public String getDDLCreate(int dialect) {
        StringBuffer buf = new StringBuffer();
        buf.append(String.valueOf(this.getName()) + " " + this.getSqlType().toSqlString(dialect) + (this.nullable ? "" : " NOT NULL "));
        if (dialect == 1) {
            buf.append(this.isIdentity ? " IDENTITY " : "");
        }
        return buf.toString();
    }

    @Override
    public String getHash() throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnsupportedEncodingException {
        return CatalogUtils.getHash(String.valueOf(this.getName()) + "." + this.sqlType.toCompareString() + "." + this.nullable);
    }

    public boolean compare(TableColumn o) {
        try {
            if (!this.getHash().equals(o.getHash())) {
                System.err.println("   TableColumnA : " + this.getName() + " Type " + this.sqlType.toCompareString() + "." + this.nullable);
                System.err.println("   TableColumnB : " + o.getName() + " Type " + o.getSqlType().toCompareString() + "." + o.nullable);
            }
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean compare(Table table, TableColumn template, Vector<String> ddls) {
        try {
            if (!this.getHash().equals(template.getHash())) {
                ddls.add(String.valueOf(this.getName()) + "Table " + table.getName() + " +  Type " + this.sqlType.toCompareString() + "." + this.nullable + " != " + template.getName() + " Type " + template.getSqlType().toCompareString() + "." + template.nullable);
                return true;
            }
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getRenderingHints() {
        return this.renderingHints;
    }

    public void setRenderingHints(String renderingHints) {
        this.renderingHints = renderingHints;
    }
}

