/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.ForeignKey;
import de.timeglobe.catalog.ForeignKeyColumn;
import de.timeglobe.catalog.Index;
import de.timeglobe.catalog.IndexColumn;
import de.timeglobe.catalog.PrimaryKeyColumn;
import de.timeglobe.catalog.SqlType;
import de.timeglobe.catalog.Table;
import de.timeglobe.catalog.TableColumn;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.LinkedHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlCatalog {
    public LinkedHashMap<String, Catalog> parse(InputStream in) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLHandler handler = new XMLHandler();
            InputSource inputSource = new InputSource(in);
            saxParser.parse(inputSource, (DefaultHandler)handler);
            return handler.catalogs;
        }
        catch (SAXParseException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        File f = new File("../pos-beans/pos.xml");
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (FileInputStream in = new FileInputStream(f);){
                XmlCatalog s = new XmlCatalog();
                LinkedHashMap<String, Catalog> linkedHashMap = s.parse(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        private Catalog catalog;
        private Table table;
        private ForeignKey foreignKey;
        private Index index;
        private TableColumn tableColumn;
        private ForeignKeyColumn foreignKeyColumn;
        private IndexColumn indexColumn;
        private LinkedHashMap<String, Catalog> catalogs = new LinkedHashMap();

        private XMLHandler() {
        }

        @Override
        public void endElement(String uri, String localname, String qname) throws SAXException {
            try {
                if (qname.equals("catalog")) {
                    this.catalogs.put(this.catalog.getName(), this.catalog);
                    this.catalog.solveReferences();
                    this.catalog = null;
                } else if (qname.equals("index")) {
                    this.table.addIndex(this.index);
                    this.index = null;
                } else if (qname.equals("foreign-key")) {
                    this.table.addForeignKey(this.foreignKey);
                    this.foreignKey = null;
                } else if (qname.equals("table")) {
                    this.catalog.addTable(this.table);
                    this.table = null;
                } else if (qname.equals("column")) {
                    this.table.addTableColumn(this.tableColumn);
                    this.tableColumn = null;
                } else if (!qname.equals("constant")) {
                    if (qname.equals("fk-col")) {
                        this.foreignKey.addForeignKeyColumn(this.foreignKeyColumn);
                        this.foreignKeyColumn = null;
                    } else if (qname.equals("ix-col")) {
                        this.index.addIndexColumn(this.indexColumn);
                        this.indexColumn = null;
                    }
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            if (qname.equals("catalog")) {
                if (this.catalog != null) return;
                this.catalog = new Catalog(attributes.getValue("name"));
                return;
            } else if (qname.equals("index")) {
                if (this.table == null || this.index != null) return;
                boolean unique = false;
                String de = attributes.getValue("unique");
                if (de != null && de.equalsIgnoreCase("1")) {
                    unique = true;
                }
                this.index = new Index(this.table, attributes.getValue("name"), unique);
                return;
            } else if (qname.equals("foreign-key")) {
                if (this.table == null || this.foreignKey != null) return;
                try {
                    this.foreignKey = new ForeignKey(this.table, attributes.getValue("name"), attributes.getValue("ref"));
                    this.foreignKey.setReplication(attributes.getValue("replication"));
                    return;
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            } else if (qname.equals("table")) {
                if (this.catalog == null || this.table != null) return;
                this.table = new Table(attributes.getValue("name"));
                this.table.setReplication(attributes.getValue("replication"));
                return;
            } else if (qname.equals("constant")) {
                if (this.catalog == null || this.table == null) return;
                this.table.addConstant(attributes.getValue("name"), attributes.getValue("value"));
                return;
            } else if (qname.equals("column")) {
                if (this.table == null) return;
                String type = attributes.getValue("type");
                try {
                    String renderingHints;
                    SqlType sqlType = new SqlType(type);
                    String pk = attributes.getValue("pk");
                    if (pk != null) {
                        if (pk.equalsIgnoreCase("1")) {
                            this.tableColumn = new PrimaryKeyColumn(attributes.getValue("name"), sqlType);
                        }
                    } else {
                        boolean nulls = true;
                        String nn = attributes.getValue("nn");
                        if (nn != null && nn.equalsIgnoreCase("1")) {
                            nulls = false;
                        }
                        this.tableColumn = new TableColumn(attributes.getValue("name"), sqlType, nulls);
                    }
                    if ((renderingHints = attributes.getValue("rendering-hints")) == null) return;
                    this.tableColumn.setRenderingHints(renderingHints);
                    return;
                }
                catch (ParseException e) {
                    throw new SAXException(e);
                }
            } else if (qname.equals("fk-col")) {
                if (this.foreignKey == null) return;
                this.foreignKeyColumn = new ForeignKeyColumn(attributes.getValue("name"), attributes.getValue("ref"));
                return;
            } else {
                if (!qname.equals("ix-col") || this.index == null) return;
                boolean desc = false;
                String de = attributes.getValue("desc");
                if (de != null && de.equalsIgnoreCase("1")) {
                    desc = true;
                }
                this.indexColumn = new IndexColumn(attributes.getValue("name"), desc);
            }
        }
    }
}

