/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.db;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.Table;
import de.timeglobe.catalog.TableColumn;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class RestoreByXMLStructure {
    String backUpDirectory;
    String fileName;
    Connection connection;
    Catalog catalog;
    Boolean stopOnError = false;
    private Hashtable<String, Object> keyReplacements = new Hashtable();

    public Hashtable<String, Object> getKeyReplacements() {
        return this.keyReplacements;
    }

    public void setKeyReplacements(Hashtable<String, Object> keyReplacements) {
        this.keyReplacements = keyReplacements;
    }

    public void addKeyReplacement(String key, Object value) {
        this.keyReplacements.put(key, value);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setBackUpDirectory(String backUpDirectory) {
        this.backUpDirectory = backUpDirectory;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public Boolean getStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(Boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public void execute() throws Exception {
        String logFilename = String.valueOf(this.fileName) + ".log";
        File dir = new File(this.backUpDirectory);
        dir.mkdirs();
        File file = new File(this.backUpDirectory, logFilename);
        try (PrintWriter printWriter = null;){
            try {
                printWriter = new PrintWriter(file);
                this.restoreDatabase(this.connection, this.backUpDirectory, this.fileName, printWriter);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (this.stopOnError.booleanValue()) {
                    throw new Exception(e);
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }

    public void executeImmediately(PrintWriter printWriter) throws Exception {
        this.restoreDatabase(this.connection, this.backUpDirectory, this.fileName, printWriter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void restoreDatabase(Connection c, String backupDir, String fileName, PrintWriter w) throws Exception {
        ZipFile source = null;
        try {
            try {
                File f = fileName.endsWith(".jar") ? new File(new File(backupDir), fileName) : new File(new File(backupDir), String.valueOf(fileName) + ".jar");
                w.println("restore database from " + f);
                source = new JarFile(f.getAbsolutePath());
                for (String tn : this.catalog.getTables().keySet()) {
                    Table t = this.catalog.getTables().get(tn);
                    w.println("restore table " + t.getName());
                    w.flush();
                    this.activateIdentity_InsertIfRequired(c, t);
                    JarEntry entry = ((JarFile)source).getJarEntry(String.valueOf(t.getName()) + ".xml");
                    InputStream jin = null;
                    try {
                        try {
                            if (entry != null) {
                                jin = ((JarFile)source).getInputStream(entry);
                                this.parse(new MonitorInputStream(jin), t, c, w);
                            } else {
                                w.println("No file for backup of table " + t.getName() + " found in backup file => Could be a new table");
                            }
                        }
                        catch (Exception ex) {
                            if (this.stopOnError.booleanValue()) {
                                throw new Exception(ex);
                            }
                            ex.printStackTrace(w);
                            this.disableIdentity_InsertIfRequired(c, t);
                            if (jin == null) continue;
                            jin.close();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        this.disableIdentity_InsertIfRequired(c, t);
                        if (jin == null) throw throwable;
                        jin.close();
                        throw throwable;
                    }
                    this.disableIdentity_InsertIfRequired(c, t);
                    if (jin == null) continue;
                    jin.close();
                }
                return;
            }
            catch (FileNotFoundException e) {
                if (this.stopOnError.booleanValue()) {
                    throw new Exception(e);
                }
                e.printStackTrace();
                if (source == null) return;
                try {
                    source.close();
                    return;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                if (this.stopOnError.booleanValue()) {
                    throw new Exception(e);
                }
                e.printStackTrace();
                if (source == null) return;
                try {
                    source.close();
                    return;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (source != null) {
                try {
                    source.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void activateIdentity_InsertIfRequired(Connection c, Table t) throws Exception {
        if (this.hasIdentityColumn(t)) {
            String setIdentityOnSQL = "SET IDENTITY_INSERT " + t.getName() + " ON";
            Statement s = null;
            try {
                s = c.createStatement();
                s.executeUpdate(setIdentityOnSQL);
                c.commit();
            }
            catch (SQLException e) {
                try {
                    s.close();
                }
                catch (SQLException e1) {
                    if (this.stopOnError.booleanValue()) {
                        throw new Exception("Set identity insert ON failed ", e);
                    }
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    private void disableIdentity_InsertIfRequired(Connection c, Table t) throws Exception {
        if (this.hasIdentityColumn(t)) {
            Statement s = null;
            try {
                String setIdentityOnSQL = "SET IDENTITY_INSERT " + t.getName() + " OFF";
                s = c.createStatement();
                s.executeUpdate(setIdentityOnSQL);
            }
            catch (SQLException e) {
                try {
                    s.close();
                }
                catch (SQLException e1) {
                    if (this.stopOnError.booleanValue()) {
                        throw new Exception("Set identity insert Off failed ", e);
                    }
                    e1.printStackTrace();
                }
                e.printStackTrace();
            }
        }
    }

    private boolean hasIdentityColumn(Table t) {
        for (TableColumn tableCol : t.getTableColumns().values()) {
            if (!tableCol.isIdentity()) continue;
            return true;
        }
        return false;
    }

    private void parse(InputStream in, Table t, Connection c, PrintWriter w) throws Exception {
        try (RestoreHandler handler = null;){
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                handler = new RestoreHandler(t, c, w);
                InputSource inputSource = new InputSource(in);
                saxParser.parse(inputSource, (DefaultHandler)handler);
            }
            catch (SAXParseException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(w);
                throw e;
            }
        }
    }

    private class MonitorInputStream
    extends FilterInputStream {
        public MonitorInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            byte[] fbuf = new byte[b.length];
            int bytes = super.read(fbuf, off, len);
            if (bytes == -1) {
                return bytes;
            }
            int wbytes = 0;
            int i = 0;
            while (i < bytes) {
                switch (fbuf[i + off]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        System.err.println("2 Skipped " + Integer.toHexString(fbuf[i + off]));
                        break;
                    }
                    default: {
                        b[wbytes + off] = fbuf[i + off];
                        ++wbytes;
                    }
                }
                ++i;
            }
            return wbytes;
        }

        @Override
        public int read(byte[] b) throws IOException {
            byte[] fbuf = new byte[b.length];
            int bytes = super.read(fbuf);
            if (bytes == -1) {
                return bytes;
            }
            int wbytes = 0;
            int i = 0;
            while (i < bytes) {
                if (fbuf[i] != 30) {
                    if (fbuf[i] != 0) {
                        if (fbuf[i] != 31) {
                            b[wbytes] = fbuf[i];
                            ++wbytes;
                        } else {
                            System.err.println("2 Skipped 0x1f");
                        }
                    } else {
                        System.err.println("2 Skipped 0x0");
                    }
                } else {
                    System.err.println("2 Skipped 0x1e");
                }
                ++i;
            }
            return wbytes;
        }

        @Override
        public int read() throws IOException {
            int b;
            while (true) {
                if ((b = super.read()) == 30) {
                    System.err.println("3 Skipped 0x1e");
                    continue;
                }
                if (b == 31) {
                    System.err.println("3 Skipped 0x1f");
                    continue;
                }
                if (b != 0) break;
                System.err.println("3 Skipped 0");
            }
            return b;
        }
    }

    private class RestoreHandler
    extends DefaultHandler {
        private Table t;
        private Connection c = null;
        private PreparedStatement ps = null;
        private LinkedHashMap<Integer, String> columnNames = new LinkedHashMap();
        private LinkedHashMap<Integer, Object> columnValues = new LinkedHashMap();
        private LinkedHashMap<String, Integer> columnPositions = new LinkedHashMap();
        private String sql;
        private PrintWriter w;
        private SimpleDateFormat sdfTs = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
        private int rowsInBatch = 0;

        public RestoreHandler(Table t, Connection c, PrintWriter w) throws SQLException {
            this.t = t;
            this.w = w;
            StringBuffer buf = new StringBuffer();
            StringBuffer cols = new StringBuffer();
            StringBuffer vars = new StringBuffer();
            String sep = "";
            buf.append("INSERT INTO " + t.getName() + " (");
            for (String tcn : t.getTableColumns().keySet()) {
                TableColumn tc = t.getTableColumns().get(tcn);
                cols.append(String.valueOf(sep) + tc.getName());
                vars.append(String.valueOf(sep) + "?");
                sep = ",";
            }
            buf.append(cols);
            buf.append(") VALUES (");
            buf.append(vars);
            buf.append(")");
            this.c = c;
            this.sql = buf.toString();
            try {
                this.ps = c.prepareStatement(this.sql);
            }
            catch (SQLException e) {
                e.getMessage();
                throw new SQLException("SQL: " + this.sql + " Error Message " + e.getMessage(), e.getCause());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void endElement(String uri, String localname, String qname) throws SAXException {
            if (qname.equals("r")) {
                int p = 1;
                for (String tcn : this.t.getTableColumns().keySet()) {
                    TableColumn tc = this.t.getTableColumns().get(tcn);
                    Integer pos = this.columnPositions.get(tc.getName());
                    Object value = null;
                    if (pos != null) {
                        value = this.columnValues.get(pos);
                    }
                    try {
                        Object rvalue = RestoreByXMLStructure.this.keyReplacements.get(tc.getName());
                        if (rvalue != null) {
                            value = rvalue;
                        }
                        if (value == null) {
                            this.ps.setObject(p++, null);
                            continue;
                        }
                        if (tc.getSqlType().getType() == 4) {
                            this.ps.setInt(p++, Integer.parseInt(value.toString()));
                            continue;
                        }
                        if (tc.getSqlType().getType() == -6) {
                            this.ps.setByte(p++, Byte.parseByte(value.toString()));
                            continue;
                        }
                        if (tc.getSqlType().getType() == -5) {
                            this.ps.setLong(p++, Long.parseLong(value.toString()));
                            continue;
                        }
                        if (tc.getSqlType().getType() == 16) {
                            if (value.equals("true")) {
                                value = "1";
                            } else if (value.equals("false")) {
                                value = "0";
                            }
                            this.ps.setString(p++, value.toString());
                            continue;
                        }
                        if (tc.getSqlType().getType() == 93) {
                            try {
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(this.sdfTs.parse(value.toString()));
                                if (cal.get(1) < 1900) {
                                    this.ps.setObject(p, null);
                                } else if (cal.get(1) > 2200) {
                                    this.ps.setObject(p, null);
                                } else {
                                    this.ps.setTimestamp(p, new Timestamp(cal.getTimeInMillis()));
                                }
                                ++p;
                            }
                            catch (SQLException e) {
                                this.ps.setObject(p, null);
                                ++p;
                                e.printStackTrace();
                            }
                            catch (ParseException e) {
                                this.ps.setObject(p, null);
                                ++p;
                                e.printStackTrace();
                            }
                            continue;
                        }
                        this.ps.setString(p++, value.toString());
                    }
                    catch (SQLException e) {
                        this.w.print(p + ": " + tc.getName() + "=" + value + "; ");
                        throw new SAXException(e);
                    }
                }
                try {
                    this.ps.addBatch();
                    ++this.rowsInBatch;
                    if (this.rowsInBatch % 1000 != 0) return;
                    this.ps.executeBatch();
                    this.c.commit();
                    return;
                }
                catch (SQLException e) {
                    System.err.println(this.sql);
                    throw new SAXException(e);
                }
            } else if (qname.equals("t")) {
                try {
                    this.ps.executeBatch();
                    this.c.commit();
                    return;
                }
                catch (SQLException e) {
                    throw new SAXException(e);
                }
            } else {
                if (!qname.equals("m")) return;
                for (Integer p : this.columnNames.keySet()) {
                    TableColumn tc = this.t.getTableColumn(this.columnNames.get(p));
                    if (tc == null) continue;
                    this.columnPositions.put(tc.getName(), p);
                }
            }
        }

        @Override
        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            if (qname.equals("r")) {
                this.columnValues.clear();
            } else if (qname.equals("d")) {
                this.columnNames.put(new Integer(attributes.getValue("p")), attributes.getValue("n").toLowerCase());
            } else if (qname.equals("c")) {
                this.columnValues.put(new Integer(attributes.getValue("p")), attributes.getValue("v"));
            }
        }

        public void close() {
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

