/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import net.obj.transaction.CacheTable;
import net.obj.transaction.TRow;
import net.obj.transaction.TransactException;

public class CacheTableColumn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int NULLABLE = 1;
    public static final int PRIMARY_KEY = 2;
    public static final int IDENTITY = 4;
    public static final int CLIENT_ID = 8;
    public static final int TENANT_NO = 8;
    public static final int BOOLEAN = 16;
    public static final int VARCHAR = 12;
    public static final int INTEGER = 4;
    public static final int BIGINT = -5;
    public static final int DECIMAL = 3;
    public static final int TIMESTAMP = 93;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int DOUBLE = 8;
    private String columnName;
    private int sqlType;
    private int length;
    private int precision;
    private boolean nullable;
    private boolean primaryKey;
    private boolean identity;
    private boolean clientId;
    private String getterName;
    private String setterName;
    private String javaTypeName;
    private String fieldName;
    private Class<?> parameterClass = null;
    private CacheTable cacheTable;
    private String renderingHints;

    public CacheTableColumn(CacheTable cacheTable, String columnName, int sqlType, int length, int precision, int options, String renderingHints) {
        this.cacheTable = cacheTable;
        this.renderingHints = renderingHints;
        if ((options & 1) == 1) {
            this.nullable = true;
        }
        if ((options & 2) == 2) {
            this.primaryKey = true;
            this.nullable = false;
        }
        if ((options & 4) == 4) {
            this.identity = true;
        }
        if ((options & 8) == 8) {
            this.clientId = true;
        }
        this.columnName = columnName;
        this.sqlType = sqlType;
        this.fieldName = this.replaceUS();
        this.getterName = "get" + this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
        this.setterName = "set" + this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
        switch (sqlType) {
            case 12: 
            case 2005: {
                this.javaTypeName = "String";
                this.parameterClass = String.class;
                break;
            }
            case 3: 
            case 8: {
                this.javaTypeName = "Double";
                this.parameterClass = Double.class;
                break;
            }
            case -5: {
                this.javaTypeName = "Long";
                this.parameterClass = Long.class;
                break;
            }
            case 4: {
                this.javaTypeName = "Integer";
                this.parameterClass = Integer.class;
                break;
            }
            case 16: {
                this.javaTypeName = "Boolean";
                this.parameterClass = Boolean.class;
                break;
            }
            case 93: {
                this.javaTypeName = "java.util.Date";
                this.parameterClass = Date.class;
            }
        }
        this.length = length;
        this.precision = precision;
    }

    private String replaceUS() {
        boolean next = false;
        StringBuffer b = new StringBuffer();
        int i = 0;
        while (i < this.columnName.length()) {
            char c = this.columnName.charAt(i);
            if (c == '_') {
                next = true;
            } else if (next) {
                b.append(Character.toUpperCase(c));
                next = false;
            } else {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isIdentity() {
        return this.identity;
    }

    public boolean isClientId() {
        return this.clientId;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getValue(TRow bean) throws TransactException {
        try {
            Method getter = bean.getClass().getMethod(this.getterName, new Class[0]);
            Object o = getter.invoke((Object)bean, new Object[0]);
            return o;
        }
        catch (SecurityException e) {
            throw new TransactException(e);
        }
        catch (NoSuchMethodException e) {
            throw new TransactException(e);
        }
        catch (IllegalArgumentException e) {
            throw new TransactException(e);
        }
        catch (IllegalAccessException e) {
            throw new TransactException(e);
        }
        catch (InvocationTargetException e) {
            throw new TransactException(e);
        }
    }

    public void setStatement(PreparedStatement ps, int pos, Object o) throws SQLException {
        if (o == null) {
            ps.setString(pos, null);
            return;
        }
        switch (this.sqlType) {
            case 12: {
                if (!(o instanceof String)) break;
                String t = (String)o;
                if (t != null) {
                    if ((t = t.trim()).length() == 0) {
                        t = null;
                    }
                    if (t != null && this.length != 0 && t.length() > this.length) {
                        t = t.substring(0, this.length);
                    }
                    o = t;
                }
                if (t == null) {
                    ps.setObject(pos, o);
                    break;
                }
                ps.setString(pos, (String)o);
                break;
            }
            case 3: 
            case 8: {
                if (!(o instanceof Double)) break;
                ps.setDouble(pos, (Double)o);
                break;
            }
            case -5: {
                if (!(o instanceof Long)) break;
                ps.setLong(pos, (Long)o);
                break;
            }
            case 4: {
                if (!(o instanceof Integer)) break;
                ps.setLong(pos, ((Integer)o).longValue());
                break;
            }
            case 16: {
                if (!(o instanceof Boolean)) break;
                ps.setByte(pos, (byte)((Boolean)o != false ? 1 : 0));
                break;
            }
            case 93: {
                if (!(o instanceof Date)) break;
                ps.setTimestamp(pos, new Timestamp(((Date)o).getTime()));
                break;
            }
            default: {
                throw new SQLException("Unsupported type: " + this.sqlType);
            }
        }
    }

    public void setStatement(PreparedStatement ps, int pos, TRow bean) throws SQLException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method getter = bean.getClass().getMethod(this.getterName, new Class[0]);
        this.setStatement(ps, pos, getter.invoke((Object)bean, new Object[0]));
    }

    public void getResult(TRow bean, ResultSet r, int pos) throws SQLException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] ao = new Object[]{null};
        switch (this.sqlType) {
            case 12: {
                String s = r.getString(pos);
                if (s == null) break;
                ao[0] = s;
                break;
            }
            case 3: 
            case 8: {
                double d = r.getDouble(pos);
                if (r.wasNull()) break;
                ao[0] = new Double(d);
                break;
            }
            case -5: {
                long l = r.getLong(pos);
                if (r.wasNull()) break;
                ao[0] = new Long(l);
                break;
            }
            case 4: {
                int i = r.getInt(pos);
                if (r.wasNull()) break;
                ao[0] = new Integer(i);
                break;
            }
            case 16: {
                byte by = r.getByte(pos);
                if (r.wasNull()) break;
                ao[0] = new Boolean(by != 0);
                break;
            }
            case 93: {
                Timestamp t = r.getTimestamp(pos);
                if (r.wasNull()) break;
                ao[0] = new Date(t.getTime());
                break;
            }
            default: {
                throw new SQLException("Unsupported type: " + this.sqlType);
            }
        }
        Method setter = bean.getClass().getMethod(this.setterName, this.parameterClass);
        setter.invoke((Object)bean, ao);
    }

    public void setValue(TRow bean, Object value) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object[] ao = new Object[]{value};
        Method setter = bean.getClass().getMethod(this.setterName, this.parameterClass);
        setter.invoke((Object)bean, ao);
    }

    public String getCreateSQL() {
        switch (this.sqlType) {
            case 12: {
                return String.valueOf(this.columnName) + " VARCHAR(" + (this.length == 0 ? "max" : "" + this.length) + ")" + (this.nullable ? "" : " NOT NULL");
            }
            case 3: 
            case 8: {
                return String.valueOf(this.columnName) + " DECIMAL(" + this.length + "," + this.precision + ")" + (this.nullable ? "" : " NOT NULL");
            }
            case 4: {
                return String.valueOf(this.columnName) + " INTEGER" + (this.identity ? " IDENTITY" : "") + (this.nullable ? "" : " NOT NULL");
            }
            case 16: {
                return String.valueOf(this.columnName) + " TINYINT" + (this.nullable ? "" : " NOT NULL");
            }
            case -5: {
                return String.valueOf(this.columnName) + " BIGINT" + (this.identity ? " IDENTITY" : "") + (this.nullable ? "" : " NOT NULL");
            }
            case 93: {
                return String.valueOf(this.columnName) + " DATETIME" + (this.nullable ? "" : " NOT NULL");
            }
        }
        return "undefined";
    }

    public Class<?> getParameterClass() {
        return this.parameterClass;
    }

    public void setRenderingHints(String renderingHints) {
        this.renderingHints = renderingHints;
    }

    public String getRenderingHints() {
        return this.renderingHints == null ? "" : this.renderingHints;
    }
}

