/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA512 {
    public static final int STREAM_BUFFER_LENGTH = 100000;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private MessageDigest md = MessageDigest.getInstance("SHA-512");

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int i = 0;
        int j = 0;
        while (i < l) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
            ++i;
        }
        return out;
    }

    public static String sha512(File file) throws IOException, NoSuchAlgorithmException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            byte[] buffer = new byte[100000];
            int read = in.read(buffer, 0, 100000);
            while (read > -1) {
                md.update(buffer, 0, read);
                read = in.read(buffer, 0, 100000);
            }
            String string = new String(SHA512.encodeHex(md.digest(), DIGITS_LOWER));
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getSHA512() {
        return new String(SHA512.encodeHex(this.md.digest(), DIGITS_LOWER));
    }

    public void update(byte[] buffer, int length) throws IOException, NoSuchAlgorithmException {
        this.md.update(buffer, 0, length);
    }
}

