/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.sql.Connection;
import net.obj.logging.ILog;
import net.obj.transaction.Cache;
import net.obj.transaction.ReplicationTransaction;
import net.obj.transaction.TRow;
import net.obj.transaction.TransactException;

public class TReplicationDelete
extends ReplicationTransaction {
    private static final long serialVersionUID = 1L;
    private TRow key;

    public void setKey(TRow key) {
        this.key = key;
    }

    public TRow getKey() {
        return this.key;
    }

    @Override
    public Serializable executeSQL(Connection connection, Cache cache) throws TransactException {
        return this.executeSQL(connection, cache, null);
    }

    @Override
    public Serializable executeSQL(Connection connection, Cache cache, ILog log) throws TransactException {
        TRow key;
        if (this.key == null) {
            throw new TransactException(14, "cannot delete null key");
        }
        try {
            key = cache.getCacheTable(this.key.getClass().getName()).delete(connection, this.key);
        }
        catch (TransactException e) {
            if (log != null) {
                String s = "";
                if (this.getKey() != null) {
                    s = String.valueOf(s) + this.getKey().getClass().getName() + " (" + this.getKey().getKey() + ")";
                }
                log.log("TDelete[" + s + "]", e);
            } else {
                e.printStackTrace();
            }
            throw e;
        }
        this.setNotify(false);
        return key;
    }

    @Override
    public Serializable executeCache(Cache cache) throws TransactException {
        return this.executeCache(cache, null);
    }

    @Override
    public Serializable executeCache(Cache cache, ILog log) throws TransactException {
        if (this.key == null) {
            throw new TransactException(14, "cannot delete null key");
        }
        TRow key = cache.getCacheTable(this.key.getClass().getName()).delete(cache.getRows(this.key.getClass().getName()), this.key);
        this.setNotify(false);
        return key;
    }
}

