/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.Serializable;
import java.sql.Connection;
import net.obj.transaction.Cache;
import net.obj.transaction.TRow;
import net.obj.transaction.TransactException;
import net.obj.transaction.Transaction;

public class TUpdate
extends Transaction {
    private static final long serialVersionUID = 1L;
    private TRow row;
    private TRow oldRow;

    public void setRow(TRow row) {
        this.row = row;
    }

    public TRow getRow() {
        return this.row;
    }

    public void setOldRow(TRow oldRow) {
        this.oldRow = oldRow;
    }

    public TRow getOldRow() {
        return this.oldRow;
    }

    @Override
    public Serializable executeSQL(Connection connection, Cache cache) throws TransactException {
        if (this.row == null) {
            throw new TransactException(14, "cannot update null row");
        }
        if (this.oldRow == null) {
            throw new TransactException(14, "cannot update null row");
        }
        TRow row = cache.getCacheTable(this.row.getClass().getName()).update(connection, this.row, this.oldRow);
        this.setNotify(true);
        return row;
    }

    @Override
    public Serializable executeCache(Cache cache) throws TransactException {
        if (this.row == null) {
            throw new TransactException(14, "cannot delete null row");
        }
        if (this.oldRow == null) {
            throw new TransactException(14, "cannot delete null row");
        }
        TRow row = cache.getCacheTable(this.row.getClass().getName()).update(cache.getRows(this.row.getClass().getName()), this.row, this.oldRow);
        this.setNotify(true);
        return row;
    }
}

