/*
 * Decompiled with CFR 0.152.
 */
package net.obj.transaction;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.obj.transaction.AsyncTransaction;
import net.obj.transaction.Cache;
import net.obj.transaction.CacheTable;
import net.obj.transaction.IAsyncResultListener;
import net.obj.transaction.TRow;
import net.obj.transaction.TransactException;

public class TView
extends AsyncTransaction {
    private static final long serialVersionUID = 1L;
    protected String rowClassName;

    public TView(String rowClassName) {
        this.rowClassName = rowClassName;
    }

    public String getRowClassName() {
        return this.rowClassName;
    }

    @Override
    public void executeSQL(Connection connection, Cache cache, IAsyncResultListener l) throws TransactException {
        Statement ps = null;
        ResultSet r = null;
        try {
            try {
                CacheTable cacheTable = cache.getCacheTable(this.rowClassName);
                Class<?> cls = Class.forName(this.getRowClassName());
                ps = connection.prepareStatement(cacheTable.getPopulateSQL());
                if (cacheTable.getClientIdColumn() != null) {
                    Integer clientId = this.getSession().getClientNo();
                    ps.setInt(1, clientId);
                }
                r = ps.executeQuery();
                r.setFetchSize(2000);
                while (r.next()) {
                    TRow row = (TRow)cls.newInstance();
                    cacheTable.getResult(row, r, 1);
                    if (!l.processResult(row)) continue;
                    break;
                }
            }
            catch (SQLException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (SecurityException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (IllegalArgumentException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (IllegalAccessException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (InvocationTargetException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (IOException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (ClassNotFoundException ex) {
                throw new TransactException("read failed", ex);
            }
            catch (InstantiationException ex) {
                throw new TransactException(ex);
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void executeCache(Cache cache, IAsyncResultListener l) throws TransactException {
        LinkedHashMap<String, TRow> rows = cache.getRows(this.getRowClassName());
        Iterator<String> i = rows.keySet().iterator();
        while (i.hasNext()) {
            TRow row = rows.get(i.next());
            try {
                TRow vr = this.makeVR(cache, (TRow)row.clone());
                if (!this.matchesFilter(vr) || !l.processResult(vr)) continue;
                break;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public TRow makeVR(Cache cache, TRow row) {
        return row;
    }

    public boolean matchesFilter(TRow vr) {
        return true;
    }
}

