/*
 * Decompiled with CFR 0.152.
 */
package net.obj.util;

import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static boolean equalsDay(Date d1, Date d2) {
        if (d1 == null) {
            return false;
        }
        if (d2 == null) {
            return false;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    public static Date stripTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Integer getIntegerDay(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return new Integer(c.get(1) * 10000 + (c.get(2) + 1) * 100 + c.get(5));
    }

    public static boolean isToday(Date date) {
        return DateUtils.sameDay(date, new Date());
    }

    public static Integer getIntegerTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return new Integer(c.get(11) * 10000 + c.get(12) * 100 + c.get(13));
    }

    public static Date getDate(Integer day, Integer time) {
        int iDay = 0;
        int iTime = 0;
        if (day == null) {
            return null;
        }
        iDay = day;
        if (time != null) {
            iTime = time;
        }
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, iDay / 10000);
        c.set(2, iDay / 100 % 100 - 1);
        c.set(5, iDay % 100);
        c.set(11, iTime / 10000);
        c.set(12, iTime / 100 % 100);
        c.set(13, iTime % 100);
        return c.getTime();
    }

    public static Date getFirstOfMonth(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(5, 1);
        return c.getTime();
    }

    public static int getMinutes(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        return c.get(11) * 60 + c.get(12);
    }

    public static int getMinutes2(Date d) {
        return (int)(d.getTime() % 86400000L) / 60000;
    }

    public static int getMinutes2(Date from, Date to) {
        return (int)((to.getTime() - from.getTime()) / 60000L);
    }

    public static Date addSeconds(Date d, int second) {
        if (d == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d);
        c1.add(11, second / 3600);
        c1.add(12, second / 60 % 60);
        c1.add(13, second % 60);
        return c1.getTime();
    }

    public static Date addMillis(Date d, long millis) {
        if (d == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d);
        long millipart = millis % 86400000L;
        long daypart = millis / 86400000L;
        c1.add(14, (int)millipart);
        if (daypart > 0L) {
            c1.add(6, (int)daypart);
        }
        return c1.getTime();
    }

    public static Date addDays(Date d, int days) {
        if (d == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d);
        c1.add(5, days);
        return c1.getTime();
    }

    public static Date addMonths(Date d, int months) {
        if (d == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d);
        c1.add(2, months);
        return c1.getTime();
    }

    public static Date addYears(Date d, int year) {
        if (d == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d);
        c1.add(1, year);
        return c1.getTime();
    }

    public static Date floorMinutes(Date d, int minute) {
        if (d == null) {
            return null;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d);
        c1.set(12, c1.get(12) / minute * minute);
        c1.set(13, 0);
        c1.set(14, 0);
        return c1.getTime();
    }

    public static boolean sameDay(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            Integer d1 = DateUtils.getIntegerDay(date1);
            Integer d2 = DateUtils.getIntegerDay(date2);
            return d1.intValue() == d2.intValue();
        }
        return false;
    }

    public static boolean sameDayInYear(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            Integer d1 = DateUtils.getIntegerDay(date1);
            Integer d2 = DateUtils.getIntegerDay(date2);
            return d1 % 10000 == d2 % 10000;
        }
        return false;
    }

    public static Date getWeekStart(Date date, int weeks) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int dayOfWeek = c.get(7) - 1;
        c.add(6, -dayOfWeek + weeks * 7);
        return c.getTime();
    }

    public static Date endOfDayTime(Date d) {
        if (d == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }
}

