/*
 * Decompiled with CFR 0.152.
 */
package net.obj.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class Utils {
    public static String coalesce(String s, String t) {
        return s == null ? t : s;
    }

    public static Integer coalesce(Integer s, Integer t) {
        return s == null ? t : s;
    }

    public static Long coalesce(Long s, Long t) {
        return s == null ? t : s;
    }

    public static Double coalesce(Double s, Double t) {
        return s == null ? t : s;
    }

    public static Boolean coalesce(Boolean s, Boolean t) {
        return s == null ? t : s;
    }

    public static Date coalesce(Date s, Date t) {
        return s == null ? t : s;
    }

    public static boolean equals(Integer s, Integer t) {
        if (s == null) {
            return t == null;
        }
        if (t == null) {
            return false;
        }
        return s.equals(t);
    }

    public static boolean equals(Boolean s, Boolean t) {
        if (s == null) {
            return t == null;
        }
        if (t == null) {
            return false;
        }
        return s.equals(t);
    }

    public static boolean equals(String s, String t) {
        if (s == null) {
            return t == null;
        }
        if (t == null) {
            return false;
        }
        return s.equals(t);
    }

    public static boolean isTrue(Boolean b) {
        return b == null ? false : b;
    }

    public static boolean equals(Long s, Long t) {
        if (s == null) {
            return t == null;
        }
        if (t == null) {
            return false;
        }
        return s.equals(t);
    }

    public static boolean equals(Date s, Date t) {
        if (s == null) {
            return t == null;
        }
        if (t == null) {
            return false;
        }
        return s.equals(t);
    }

    public static boolean equals(Double s, Double t) {
        if (s == null) {
            return t == null;
        }
        if (t == null) {
            return false;
        }
        return s.equals(t);
    }

    public static boolean isEmptyOrNull(Integer s) {
        return s == null;
    }

    public static boolean isEmptyOrNull(Double s) {
        return s == null;
    }

    public static boolean isEmptyOrNull(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().isEmpty();
    }

    public static Date max(Date s, Date t) {
        Date date1 = Utils.coalesce(s, t);
        Date date2 = Utils.coalesce(t, s);
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.after(date2)) {
            return date1;
        }
        return date2;
    }

    public static String parseString(ResultSet rs, int index) throws SQLException {
        if (rs != null) {
            return rs.getString(index);
        }
        return null;
    }

    public static Date parseDate(ResultSet rs, int index) throws SQLException {
        if (rs != null) {
            Timestamp timestamp = rs.getTimestamp(index);
            if (!rs.wasNull()) {
                return new Date(timestamp.getTime());
            }
        }
        return null;
    }

    public static Integer parseInteger(ResultSet rs, int index) throws SQLException {
        if (rs != null) {
            int i = rs.getInt(index);
            if (!rs.wasNull()) {
                return i;
            }
        }
        return null;
    }

    public static Long parseLong(ResultSet rs, int index) throws SQLException {
        if (rs != null) {
            long i = rs.getLong(index);
            if (!rs.wasNull()) {
                return i;
            }
        }
        return null;
    }

    public static Float parseFloat(ResultSet rs, int index) throws SQLException {
        if (rs != null) {
            float i = rs.getFloat(index);
            if (!rs.wasNull()) {
                return Float.valueOf(i);
            }
        }
        return null;
    }

    public static Double parseDouble(ResultSet rs, int index) throws SQLException {
        if (rs != null) {
            double i = rs.getDouble(index);
            if (!rs.wasNull()) {
                return i;
            }
        }
        return null;
    }

    public static String quoteString(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer result = null;
        int i = 0;
        int max = s.length();
        int delta = 0;
        while (i < max) {
            char c = s.charAt(i);
            String replacement = null;
            if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '\r') {
                replacement = "&#13;";
            } else if (c == '\n') {
                replacement = "&#10;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\"') {
                replacement = "&quot;";
            } else if (c == '\'') {
                replacement = "&apos;";
            }
            if (replacement != null) {
                if (result == null) {
                    result = new StringBuffer(s);
                }
                result.replace(i + delta, i + delta + 1, replacement);
                delta += replacement.length() - 1;
            }
            ++i;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }
}

