/*
 * Decompiled with CFR 0.152.
 */
package net.timeglobe.dbtool;

import de.timeglobe.catalog.BackupCatalog;
import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.JdbcCatalog;
import de.timeglobe.catalog.XmlCatalog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class CompareTask {
    private String dbms1;
    private String database1;
    private String driver1;
    private String url1;
    private String uid1;
    private String pwd1;
    private String dbms2;
    private String database2;
    private String driver2;
    private String url2;
    private String uid2;
    private String pwd2;
    private String file1;
    private String file2;

    public Connection getConnection(String driver, String url, String uid, String pwd) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        Connection connection = DriverManager.getConnection(url, uid, pwd);
        connection.setAutoCommit(false);
        return connection;
    }

    public void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void execute(Connection connection, String sql) throws SQLException {
        PreparedStatement ps = null;
        try {
            System.err.println(sql);
            ps = connection.prepareStatement(sql);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void execute() throws Exception {
        System.err.println(System.getenv());
        JdbcCatalog jc1 = new JdbcCatalog();
        JdbcCatalog jc2 = new JdbcCatalog();
        System.err.println("Execute");
        Connection c1 = null;
        Connection c2 = null;
        Catalog catalog1 = null;
        Catalog catalog2 = null;
        try {
            if (this.file1 == null) {
                System.err.println("getDatabaseCatalog 1");
                c1 = this.getConnection(this.driver1, this.url1, this.uid1, this.pwd1);
                System.err.println("Retrieved connection 1");
                catalog1 = jc1.load(c1, this.getDatabaseDialect(this.dbms1), this.database1);
            } else {
                System.err.println("getFileCatalog 1");
                catalog1 = this.getFileCatalog(this.file1, this.database1);
            }
            if (this.file2 == null) {
                System.err.println("getDatabaseCatalog 2");
                c2 = this.getConnection(this.driver2, this.url2, this.uid2, this.pwd2);
                System.err.println("Retrieved connection 2");
                catalog2 = jc2.load(c2, this.getDatabaseDialect(this.dbms2), this.database2);
            } else {
                System.err.println("getFileCatalog 2");
                catalog2 = this.getFileCatalog(this.file2, this.database2);
            }
            System.err.println("Compare");
            catalog1.solveReferences();
            catalog2.solveReferences();
            catalog1.compare(catalog2, false);
            String h1 = catalog1.getHash();
            System.err.println("Hash A" + h1);
            String h2 = catalog2.getHash();
            System.err.println("Hash A" + h2);
            System.err.println(h1.equals(h2));
        }
        catch (Throwable throwable) {
            this.closeConnection(c1);
            this.closeConnection(c2);
            throw throwable;
        }
        this.closeConnection(c1);
        this.closeConnection(c2);
    }

    private Catalog getFileCatalog(String file, String name) throws IOException {
        if (file.toLowerCase().endsWith(".jar")) {
            return this.getJarFileCatalog(file, name);
        }
        File f = new File(file);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (FileInputStream in = new FileInputStream(f);){
                XmlCatalog s = new XmlCatalog();
                LinkedHashMap<String, Catalog> catalogs = s.parse(in);
                Iterator<String> iterator = catalogs.keySet().iterator();
                if (iterator.hasNext()) {
                    String catalog = iterator.next();
                    return catalogs.get(catalog);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Catalog getJarFileCatalog(String file, String name) throws IOException {
        BackupCatalog jarFileCatalog = new BackupCatalog();
        return jarFileCatalog.load(new File(file), name);
    }

    private int getDatabaseDialect(String dbms) {
        if (dbms.equals("derby")) {
            return 2;
        }
        return 1;
    }

    public String getDatabase1() {
        return this.database1;
    }

    public void setDatabase1(String database1) {
        this.database1 = database1;
    }

    public String getDriver1() {
        return this.driver1;
    }

    public void setDriver1(String driver1) {
        this.driver1 = driver1;
    }

    public String getUrl1() {
        return this.url1;
    }

    public void setUrl1(String url1) {
        this.url1 = url1;
    }

    public String getUid1() {
        return this.uid1;
    }

    public void setUid1(String uid1) {
        this.uid1 = uid1;
    }

    public String getPwd1() {
        return this.pwd1;
    }

    public void setPwd1(String pwd1) {
        this.pwd1 = pwd1;
    }

    public String getDatabase2() {
        return this.database2;
    }

    public void setDatabase2(String database2) {
        this.database2 = database2;
    }

    public String getDriver2() {
        return this.driver2;
    }

    public void setDriver2(String driver2) {
        this.driver2 = driver2;
    }

    public String getUrl2() {
        return this.url2;
    }

    public void setUrl2(String url2) {
        this.url2 = url2;
    }

    public String getUid2() {
        return this.uid2;
    }

    public void setUid2(String uid2) {
        this.uid2 = uid2;
    }

    public String getPwd2() {
        return this.pwd2;
    }

    public void setPwd2(String pwd2) {
        this.pwd2 = pwd2;
    }

    public String getDbms1() {
        return this.dbms1;
    }

    public void setDbms1(String dbms1) {
        this.dbms1 = dbms1;
    }

    public String getDbms2() {
        return this.dbms2;
    }

    public void setDbms2(String dbms2) {
        this.dbms2 = dbms2;
    }

    public String getFile1() {
        return this.file1;
    }

    public void setFile1(String file1) {
        this.file1 = file1;
    }

    public String getFile2() {
        return this.file2;
    }

    public void setFile2(String file2) {
        this.file2 = file2;
    }
}

