/*
 * Decompiled with CFR 0.152.
 */
package net.timeglobe.dbtool;

import de.timeglobe.catalog.BackupCatalog;
import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.JdbcCatalog;
import de.timeglobe.catalog.XmlCatalog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import net.timeglobe.dbtool.BackupByXMLStructure;
import net.timeglobe.dbtool.RestoreDatabase;

public class DbTool {
    private String args;
    private LinkedHashMap<String, AbstractCommand> commands = new LinkedHashMap();

    public void execute() throws Exception {
        String[] argsList = this.args.split(" ");
        DbTool dbTool = new DbTool();
        dbTool.execute(argsList);
    }

    public void execute(String[] args) throws Exception {
        AbstractCommand command = this.parseArgs(args);
        if (command.check()) {
            command.execute();
        }
    }

    public static void main(String[] args) throws Exception {
        DbTool dbTool = new DbTool();
        dbTool.execute(args);
    }

    public AbstractCommand addCommand(AbstractCommand command) {
        this.commands.put(command.getName(), command);
        return command;
    }

    private Catalog getXMLCatalog(String file) {
        File f = new File(file);
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (FileInputStream in = new FileInputStream(f);){
                XmlCatalog s = new XmlCatalog();
                LinkedHashMap<String, Catalog> catalogs = s.parse(in);
                Iterator<String> iterator = catalogs.keySet().iterator();
                if (iterator.hasNext()) {
                    String catalog = iterator.next();
                    return catalogs.get(catalog);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String extractAttributeValue(String keyReplacementString, String attribute, String seperator, String assignmentString) throws Exception {
        String[] keyStrings = keyReplacementString.split(seperator);
        int i = 0;
        while (i < keyStrings.length) {
            String d = keyStrings[i];
            String[] ad = d.split(assignmentString);
            if (ad.length == 2 && ad[0].equals(attribute)) {
                return ad[1];
            }
            ++i;
        }
        return null;
    }

    public Connection getConnection(String driver, String url, String uid, String pwd) throws SQLException, ClassNotFoundException {
        Class.forName(driver);
        Connection connection = DriverManager.getConnection(url, uid, pwd);
        connection.setAutoCommit(false);
        return connection;
    }

    public DbTool() {
        this.addCommand(new RestoreCommand());
        this.addCommand(new BackupCommand());
        this.addCommand(new SchemaExportCommand());
        this.addCommand(new SchemaCompareCommand());
    }

    private void usage() {
        for (String n : this.commands.keySet()) {
            AbstractCommand ac = this.commands.get(n);
            System.err.println(ac.usage());
        }
    }

    private AbstractCommand parseArgs(String[] args) throws Exception {
        String name;
        AbstractCommand command;
        if (args.length == 0) {
            this.usage();
        } else if (args.length >= 1 && (command = this.commands.get(name = args[0].toLowerCase())) != null) {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            int i = 1;
            while (i < args.length) {
                String d = args[i];
                String[] ad = d.split(":=");
                if (ad.length <= 2) {
                    if (ad.length == 1) {
                        values.put(ad[0], "");
                    } else {
                        values.put(ad[0], ad[1]);
                    }
                } else {
                    throw new Exception("invalid: " + d);
                }
                ++i;
            }
            command.setValues(values);
            return command;
        }
        throw new Exception("invalid arguments");
    }

    protected void closeConnection(Connection c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    private abstract class AbstractCommand {
        private String name;
        private LinkedHashMap<String, CommandAttribute> attributes = new LinkedHashMap();

        public AbstractCommand(String name) {
            this.setName(name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CommandAttribute addAttribute(String name, boolean required) {
            name = name.toLowerCase();
            CommandAttribute attribute = new CommandAttribute(name, null, required);
            this.attributes.put(name, attribute);
            return attribute;
        }

        public void setValues(LinkedHashMap<String, String> values) {
            for (String key : this.attributes.keySet()) {
                String v = values.get(key);
                if (v == null) continue;
                CommandAttribute attribute = this.attributes.get(key);
                attribute.setValue(v);
            }
        }

        public boolean check() throws Exception {
            for (String key : this.attributes.keySet()) {
                CommandAttribute attribute = this.attributes.get(key);
                if (attribute.check()) continue;
                return false;
            }
            return true;
        }

        public String usage() {
            StringBuffer buf = new StringBuffer();
            buf.append("dbtool " + this.name);
            String sep = "\n    ";
            for (String key : this.attributes.keySet()) {
                CommandAttribute attribute = this.attributes.get(key);
                if (attribute.isRequired()) {
                    buf.append(sep);
                    buf.append("{" + key + ":=<value>" + "}");
                    continue;
                }
                buf.append(sep);
                buf.append("[" + key + ":=<value>" + "]");
            }
            return buf.toString();
        }

        public abstract void execute() throws Exception;

        public String getAttributeValue(String name) {
            CommandAttribute ca = this.attributes.get(name);
            if (ca != null) {
                return ca.getValue();
            }
            return null;
        }
    }

    private class BackupCommand
    extends AbstractCommand {
        public BackupCommand() {
            super("backup");
            this.addAttribute("jarfile", true);
            this.addAttribute("source-db", true);
            this.addAttribute("database-type", true);
            this.addAttribute("user-id", false);
            this.addAttribute("password", false);
        }

        @Override
        public void execute() throws Exception {
            BackupByXMLStructure backup = new BackupByXMLStructure();
            PrintWriter printWriter = new PrintWriter(System.out);
            String jarFile = this.getAttributeValue("jarfile");
            String databaseType = this.getAttributeValue("database-type");
            String databaseLocation = this.getAttributeValue("source-db");
            String driver = null;
            String url = null;
            String uid = "";
            if (databaseType.equals("derby")) {
                backup.setDatabaseDialect(2);
                driver = "org.apache.derby.jdbc.EmbeddedDriver";
                url = databaseLocation.startsWith("jdbc:derby:") ? databaseLocation : "jdbc:derby:" + databaseLocation;
                backup.setDatabaseName("");
            } else if (databaseType.equals("pgsql")) {
                backup.setDatabaseDialect(3);
                driver = "org.postgresql.Driver";
                url = databaseLocation.startsWith("jdbc:postgresql:") ? databaseLocation : "jdbc:postgresql:" + databaseLocation;
                backup.setDatabaseName(url.substring(url.lastIndexOf(47) + 1));
            } else if (databaseType.equals("mssql")) {
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                backup.setDatabaseDialect(1);
                url = databaseLocation;
                backup.setDatabaseName(DbTool.this.extractAttributeValue(url, "databaseName", ";", "="));
            } else {
                throw new Exception("database-type not implemented.");
            }
            if (this.getAttributeValue("user-id") != null) {
                uid = this.getAttributeValue("user-id");
            }
            String password = "";
            if (this.getAttributeValue("password") != null) {
                password = this.getAttributeValue("password");
            }
            Connection connection = DbTool.this.getConnection(driver, url, uid, password);
            backup.setJarFileWithLocation(jarFile);
            backup.setPrintWriter(printWriter);
            backup.setConnection(connection);
            backup.execute();
            printWriter.close();
            DbTool.this.closeConnection(connection);
        }
    }

    private class CommandAttribute {
        private String name;
        private String value;
        private boolean required;

        public CommandAttribute(String name, String value, boolean required) {
            this.name = name;
            this.value = value;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean check() throws Exception {
            if (this.isRequired() && this.value == null) {
                throw new Exception("missing attribute: " + this.name);
            }
            return true;
        }
    }

    private class RestoreCommand
    extends AbstractCommand {
        public RestoreCommand() {
            super("restore");
            this.addAttribute("jarfile", true);
            this.addAttribute("target-db", true);
            this.addAttribute("database-type", true);
            this.addAttribute("create-db", false);
            this.addAttribute("catalog-file", false);
            this.addAttribute("script-file", false);
            this.addAttribute("key-replacements", false);
            this.addAttribute("user-id", false);
            this.addAttribute("password", false);
            this.addAttribute("stop-on-error", false);
        }

        @Override
        public void execute() throws Exception {
            String jarFile = this.getAttributeValue("jarfile");
            String targetDatabase = this.getAttributeValue("target-db");
            String databaseName = "";
            String databaseType = this.getAttributeValue("database-type");
            String catalogFile = this.getAttributeValue("catalog-file");
            String scriptFile = this.getAttributeValue("script-file");
            String keyReplacements = this.getAttributeValue("key-replacements");
            Boolean createDatabase = Boolean.valueOf(this.getAttributeValue("create-db"));
            Boolean stopOnError = Boolean.TRUE;
            if (this.getAttributeValue("stop-on-error") != null) {
                stopOnError = Boolean.valueOf(this.getAttributeValue("stop-on-error"));
            }
            Integer catalogDatabaseId = null;
            PrintWriter printWriter = new PrintWriter(System.out);
            Connection connection = null;
            String driver = null;
            String url = null;
            String uid = "";
            String password = "";
            Catalog catalog = null;
            if (catalogFile != null) {
                catalog = DbTool.this.getXMLCatalog(catalogFile);
            } else {
                BackupCatalog jarFileCatalog = new BackupCatalog();
                catalog = jarFile.endsWith(".jar") ? jarFileCatalog.load(new File(jarFile), "") : jarFileCatalog.load(new File(String.valueOf(jarFile) + ".jar"), "");
            }
            catalog.solveReferences();
            if (databaseType.equals("derby")) {
                catalogDatabaseId = 2;
                driver = "org.apache.derby.jdbc.EmbeddedDriver";
                url = targetDatabase.startsWith("jdbc:derby:") ? targetDatabase : "jdbc:derby:" + targetDatabase;
                if (createDatabase.booleanValue()) {
                    url = String.valueOf(url) + ";create=true;";
                }
            } else if (databaseType.equals("pgsql")) {
                catalogDatabaseId = 3;
                driver = "org.postgresql.Driver";
                url = targetDatabase.startsWith("jdbc:postgresql:") ? targetDatabase : "jdbc:postgresql:" + targetDatabase;
                databaseName = url.substring(url.lastIndexOf(47) + 1);
            } else if (databaseType.equals("mssql")) {
                catalogDatabaseId = 1;
                url = targetDatabase;
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                databaseName = DbTool.this.extractAttributeValue(url, "databaseName", ";", "=");
            } else {
                throw new Exception("database-type not implemented.");
            }
            if (this.getAttributeValue("user-id") != null) {
                uid = this.getAttributeValue("user-id");
            }
            if (this.getAttributeValue("password") != null) {
                password = this.getAttributeValue("password");
            }
            connection = DbTool.this.getConnection(driver, url, uid, password);
            RestoreDatabase restoreDB = new RestoreDatabase();
            restoreDB.setCatalogDatabaseId(catalogDatabaseId);
            restoreDB.setDataBaseName(databaseName);
            if (keyReplacements != null) {
                this.addRestoreKeys(restoreDB, keyReplacements);
            }
            restoreDB.restoreDatabase(printWriter, connection, catalog, jarFile, scriptFile, stopOnError);
            printWriter.close();
            DbTool.this.closeConnection(connection);
        }

        private void addRestoreKeys(RestoreDatabase restoreDB, String keyReplacements) throws Exception {
            String[] keyStrings = keyReplacements.split(";");
            int i = 0;
            while (i < keyStrings.length) {
                String d = keyStrings[i];
                String[] ad = d.split(":");
                if (ad.length != 2) {
                    throw new Exception("KeyReplacements invalid: " + d);
                }
                restoreDB.addKeyReplacement(ad[0], ad[1]);
                System.out.println(String.valueOf(ad[0]) + " : " + ad[1]);
                ++i;
            }
        }
    }

    private class SchemaCompareCommand
    extends AbstractCommand {
        public SchemaCompareCommand() {
            super("schema-compare");
            this.addAttribute("source-db-1", true);
            this.addAttribute("database-type-1", true);
            this.addAttribute("user-id-1", false);
            this.addAttribute("password-1", false);
            this.addAttribute("source-db-2", true);
            this.addAttribute("database-type-2", true);
            this.addAttribute("user-id-2", false);
            this.addAttribute("password-2", false);
        }

        private Catalog getCatalog(String suffix) throws Exception {
            JdbcCatalog jdbcCatalog = new JdbcCatalog();
            String databaseType = this.getAttributeValue("database-type-" + suffix);
            String databaseLocation = this.getAttributeValue("source-db-" + suffix);
            String driver = null;
            String url = null;
            String uid = "";
            int dialect = 1;
            String databaseName = "";
            if (databaseType.equals("derby")) {
                dialect = 2;
                driver = "org.apache.derby.jdbc.EmbeddedDriver";
                url = databaseLocation.startsWith("jdbc:derby:") ? databaseLocation : "jdbc:derby:" + databaseLocation;
            } else if (databaseType.equals("pgsql")) {
                dialect = 3;
                driver = "org.postgresql.Driver";
                url = databaseLocation.startsWith("jdbc:postgresql:") ? databaseLocation : "jdbc:postgresql:" + databaseLocation;
            } else {
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                url = databaseLocation;
                databaseName = DbTool.this.extractAttributeValue(url, "databaseName", ";", "=");
            }
            if (this.getAttributeValue("user-id-" + suffix) != null) {
                uid = this.getAttributeValue("user-id-" + suffix);
            }
            String password = "";
            if (this.getAttributeValue("password-" + suffix) != null) {
                password = this.getAttributeValue("password-" + suffix);
            }
            Connection c = null;
            try {
                System.err.println("Load " + url);
                c = DbTool.this.getConnection(driver, url, uid, password);
                Catalog catalog = jdbcCatalog.load(c, dialect, databaseName);
                DbTool.this.closeConnection(c);
                return catalog;
            }
            catch (Throwable throwable) {
                DbTool.this.closeConnection(c);
                throw throwable;
            }
        }

        @Override
        public void execute() throws Exception {
            Vector<String> ddls;
            Catalog catalog2;
            Catalog catalog1 = this.getCatalog("1");
            if (catalog1.compare(catalog2 = this.getCatalog("2"), ddls = new Vector<String>())) {
                for (String ddl : ddls) {
                    System.out.println(ddl);
                }
            }
        }
    }

    private class SchemaExportCommand
    extends AbstractCommand {
        public SchemaExportCommand() {
            super("schema-export");
            this.addAttribute("jarfile", true);
            this.addAttribute("source-db", true);
            this.addAttribute("database-type", true);
            this.addAttribute("user-id", false);
            this.addAttribute("password", false);
        }

        @Override
        public void execute() throws Exception {
            BackupByXMLStructure backup = new BackupByXMLStructure();
            PrintWriter printWriter = new PrintWriter(System.out);
            String jarFile = this.getAttributeValue("jarfile");
            String databaseType = this.getAttributeValue("database-type");
            String databaseLocation = this.getAttributeValue("source-db");
            String driver = null;
            String url = null;
            String uid = "";
            if (databaseType.equals("derby")) {
                backup.setDatabaseDialect(2);
                driver = "org.apache.derby.jdbc.EmbeddedDriver";
                backup.setDatabaseName("");
                url = databaseLocation.startsWith("jdbc:derby:") ? databaseLocation : "jdbc:derby:" + databaseLocation;
            } else {
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                backup.setDatabaseDialect(1);
                url = databaseLocation;
                backup.setDatabaseName(DbTool.this.extractAttributeValue(url, "databaseName", ";", "="));
            }
            if (this.getAttributeValue("user-id") != null) {
                uid = this.getAttributeValue("user-id");
            }
            String password = "";
            if (this.getAttributeValue("password") != null) {
                password = this.getAttributeValue("password");
            }
            Connection connection = DbTool.this.getConnection(driver, url, uid, password);
            backup.setJarFileWithLocation(jarFile);
            backup.setPrintWriter(printWriter);
            backup.setConnection(connection);
            backup.setSchemaOnly(true);
            backup.execute();
            printWriter.close();
            DbTool.this.closeConnection(connection);
        }
    }
}

