/*
 * Decompiled with CFR 0.152.
 */
package net.timeglobe.dbtool.script;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtractSQLsSimple {
    private final String pattern = "(\\'.*\\')|(--.*)|(\\/\\*(?:.|\\n|\\r|\\t)*\\*\\/)";
    private final String sqlPattern = "(SELECT\\b(?:\\s|\\n)*?)|(UPDATE\\b(?:\\s|\\n)*?)|(INSERT\\b(?:\\s|\\n)*?)|(DROP\\b(?:\\s|\\n)*?)|(CREATE\\b(?:\\s|\\n)*?)|(DELETE\\b(?:\\s|\\n)*?)|(ALTER\\b(?:\\s|\\n)*?)";

    public ArrayList<SQLObject> getSQLs(String sql) {
        Pattern regExpPattern = Pattern.compile("(\\'.*\\')|(--.*)|(\\/\\*(?:.|\\n|\\r|\\t)*\\*\\/)");
        ArrayList<SQLObject> listSqls = new ArrayList<SQLObject>();
        String sqls = String.valueOf(this.removeCommentsAndReplaceSemicolonInText(regExpPattern, sql)) + ";";
        String[] sqlsSplit = sqls.split(";");
        SQLObject sqlObj = null;
        String[] stringArray = sqlsSplit;
        int n = sqlsSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String sqlSplit = stringArray[n2];
            sqlObj = this.extractSQL(sqlSplit);
            if (sqlObj != null) {
                listSqls.add(this.extractSQL(sqlSplit));
            }
            ++n2;
        }
        return listSqls;
    }

    private String removeCommentsAndReplaceSemicolonInText(Pattern regExpPattern, String sql) {
        Matcher matcher = regExpPattern.matcher(sql);
        StringBuilder stringBuilder = new StringBuilder(sql);
        String replaceSemicolon = "_Semicolon_";
        if (matcher.find()) {
            if (matcher.group(1) != null) {
                int offset = 0;
                int i = matcher.start(1);
                while (i < matcher.end(1) + offset) {
                    if (stringBuilder.charAt(i) == ';') {
                        stringBuilder = stringBuilder.replace(i, i + 1, replaceSemicolon);
                        offset = offset + replaceSemicolon.length() - 1;
                    }
                    ++i;
                }
                stringBuilder = stringBuilder.replace(matcher.end(1) + offset, stringBuilder.length(), this.removeCommentsAndReplaceSemicolonInText(regExpPattern, stringBuilder.substring(matcher.end() + offset)));
            } else if (matcher.group(3) != null) {
                stringBuilder = stringBuilder.replace(matcher.start(3), matcher.end(3), " ");
                stringBuilder = new StringBuilder(this.removeCommentsAndReplaceSemicolonInText(regExpPattern, stringBuilder.toString()));
            } else if (matcher.group(2) != null) {
                stringBuilder = stringBuilder.replace(matcher.start(2), matcher.end(2), " ");
                stringBuilder = new StringBuilder(this.removeCommentsAndReplaceSemicolonInText(regExpPattern, stringBuilder.toString()));
            }
        }
        return stringBuilder.toString();
    }

    private SQLObject extractSQL(String possibleSql) {
        Pattern pattern = Pattern.compile("(SELECT\\b(?:\\s|\\n)*?)|(UPDATE\\b(?:\\s|\\n)*?)|(INSERT\\b(?:\\s|\\n)*?)|(DROP\\b(?:\\s|\\n)*?)|(CREATE\\b(?:\\s|\\n)*?)|(DELETE\\b(?:\\s|\\n)*?)|(ALTER\\b(?:\\s|\\n)*?)", 2);
        Matcher matcher = pattern.matcher(possibleSql);
        if (matcher.find()) {
            int i = 1;
            while (i <= matcher.groupCount()) {
                if (matcher.group(i) != null) {
                    return new SQLObject(i, possibleSql.replaceAll("_Semicolon_", ";"));
                }
                ++i;
            }
        }
        return null;
    }

    public class SQLObject {
        public static final int SelectType = 1;
        public static final int UpdateType = 2;
        public static final int InsertType = 3;
        public static final int DropType = 4;
        public static final int CreateType = 5;
        public static final int DeleteType = 6;
        public static final int AlterType = 7;
        private int sqlType;
        private String sql;

        public SQLObject(int sqlType, String sql) {
            this.sqlType = sqlType;
            this.setSql(sql);
        }

        public int getSqlType() {
            return this.sqlType;
        }

        public String getSql() {
            return this.sql;
        }

        private void setSql(String sql) {
            this.sql = sql.endsWith(";") ? sql.substring(0, sql.length() - 1) : sql;
        }
    }
}

