/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class GetConfig {
    public void run() throws IOException {
        File d = new File("../launch-9980/config");
        if (!d.exists()) {
            throw new IOException("launcher config dir " + d.getAbsolutePath() + " does not exist.");
        }
        File pf = new File("../launch-9980/config/launch.properties");
        Properties p = this.loadProperties(pf);
        String uid = p.getProperty("unique_id");
        if (uid != null) {
            throw new IOException("Station already registered as " + uid);
        }
        File d2 = new File("../../pos/possat-8080/conf/Catalina/localhost");
        if (!d2.exists()) {
            throw new IOException("pos config dir " + d2.getAbsolutePath() + " does not exist.");
        }
        File[] af = d2.listFiles();
        int scanned = 0;
        File[] fileArray = af;
        int n = af.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(".xml")) {
                System.out.println("scanning " + f.getAbsolutePath());
                FileInputStream in = null;
                try {
                    in = new FileInputStream(f);
                    Properties ip = this.parse(in);
                    if (ip != null) {
                        System.out.println("properties are " + ip);
                        System.out.println("store properties in " + pf);
                        this.storeProperties(pf, ip);
                        break;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                ++scanned;
            }
            ++n2;
        }
        if (scanned == 0) {
            throw new IOException("no pos config available in " + d2.getAbsolutePath());
        }
    }

    private Properties parse(InputStream in) throws Exception {
        ContextHandler handler = new ContextHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            InputSource inputSource = new InputSource(in);
            saxParser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXParseException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return handler.getProperties();
    }

    private Properties loadProperties(File file) {
        Properties properties;
        block12: {
            properties = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    properties.load(fis);
                }
                catch (Exception exception) {
                    if (fis == null) break block12;
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    private void storeProperties(File file, Properties properties) {
        block12: {
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(file);
                    properties.store(fos, "");
                }
                catch (Exception cause) {
                    cause.printStackTrace();
                    if (fos == null) break block12;
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void main(String[] args) {
        GetConfig es = new GetConfig();
        try {
            es.run();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    private class ContextHandler
    extends DefaultHandler {
        private String customerCd = null;
        private String siteCd = null;
        private String stationCd = null;

        private ContextHandler() {
        }

        @Override
        public void startElement(String uri, String localname, String qname, Attributes attributes) throws SAXException {
            String name;
            if (qname.equals("Environment") && (name = attributes.getValue("name")) != null) {
                if (name.equals("esafe-owner-cd")) {
                    this.customerCd = attributes.getValue("value");
                } else if (name.equals("esafe-site-cd")) {
                    this.siteCd = attributes.getValue("value");
                } else if (name.equals("esafe-station-cd")) {
                    this.stationCd = attributes.getValue("value");
                }
            }
        }

        public Properties getProperties() {
            if (this.customerCd == null) {
                return null;
            }
            if (this.customerCd.isEmpty()) {
                return null;
            }
            if (this.siteCd == null) {
                return null;
            }
            if (this.siteCd.isEmpty()) {
                return null;
            }
            if (this.stationCd == null) {
                return null;
            }
            if (this.stationCd.isEmpty()) {
                return null;
            }
            Properties properties = new Properties();
            properties.setProperty("customer_cd", this.customerCd);
            properties.setProperty("site_cd", this.siteCd);
            properties.setProperty("site_nm", this.siteCd);
            properties.setProperty("station_cd", this.stationCd);
            properties.setProperty("station_nm", this.stationCd);
            return properties;
        }
    }
}

