/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.remote;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.remote.RemoteDebuggerClient;
import sun.jvm.hotspot.debugger.remote.RemoteOopHandle;

class RemoteAddress
implements Address {
    protected RemoteDebuggerClient debugger;
    protected long addr;

    RemoteAddress(RemoteDebuggerClient debugger, long addr) {
        this.debugger = debugger;
        this.addr = addr;
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof RemoteAddress)) {
            return false;
        }
        return this.addr == ((RemoteAddress)arg).addr;
    }

    @Override
    public int hashCode() {
        return (int)this.addr;
    }

    public String toString() {
        return this.debugger.addressValueToString(this.addr);
    }

    @Override
    public long getCIntegerAt(long offset, long numBytes, boolean isUnsigned) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCInteger(this.addr + offset, numBytes, isUnsigned);
    }

    @Override
    public Address getAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readAddress(this.addr + offset);
    }

    @Override
    public Address getCompOopAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCompOopAddress(this.addr + offset);
    }

    @Override
    public Address getCompKlassAddressAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readCompKlassAddress(this.addr + offset);
    }

    @Override
    public boolean getJBooleanAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJBoolean(this.addr + offset);
    }

    @Override
    public byte getJByteAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJByte(this.addr + offset);
    }

    @Override
    public char getJCharAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJChar(this.addr + offset);
    }

    @Override
    public double getJDoubleAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJDouble(this.addr + offset);
    }

    @Override
    public float getJFloatAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJFloat(this.addr + offset);
    }

    @Override
    public int getJIntAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJInt(this.addr + offset);
    }

    @Override
    public long getJLongAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJLong(this.addr + offset);
    }

    @Override
    public short getJShortAt(long offset) throws UnalignedAddressException, UnmappedAddressException {
        return this.debugger.readJShort(this.addr + offset);
    }

    @Override
    public OopHandle getOopHandleAt(long offset) throws UnalignedAddressException, UnmappedAddressException, NotInHeapException {
        return this.debugger.readOopHandle(this.addr + offset);
    }

    @Override
    public OopHandle getCompOopHandleAt(long offset) throws UnalignedAddressException, UnmappedAddressException, NotInHeapException {
        return this.debugger.readCompOopHandle(this.addr + offset);
    }

    @Override
    public void setCIntegerAt(long offset, long numBytes, long value) {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setAddressAt(long offset, Address value) {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJBooleanAt(long offset, boolean value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJByteAt(long offset, byte value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJCharAt(long offset, char value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJDoubleAt(long offset, double value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJFloatAt(long offset, float value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJIntAt(long offset, int value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJLongAt(long offset, long value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setJShortAt(long offset, short value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public void setOopHandleAt(long offset, OopHandle value) throws UnmappedAddressException, UnalignedAddressException {
        throw new DebuggerException("Unimplemented");
    }

    @Override
    public Address addOffsetTo(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new RemoteAddress(this.debugger, value);
    }

    @Override
    public OopHandle addOffsetToAsOopHandle(long offset) throws UnsupportedOperationException {
        long value = this.addr + offset;
        if (value == 0L) {
            return null;
        }
        return new RemoteOopHandle(this.debugger, value);
    }

    @Override
    public long minus(Address arg) {
        if (arg == null) {
            return this.addr;
        }
        return this.addr - ((RemoteAddress)arg).addr;
    }

    @Override
    public boolean lessThan(Address arg) {
        if (arg == null) {
            return false;
        }
        RemoteAddress remoteArg = (RemoteAddress)arg;
        if (this.addr >= 0L && remoteArg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && remoteArg.addr >= 0L) {
            return false;
        }
        return this.addr < remoteArg.addr;
    }

    @Override
    public boolean lessThanOrEqual(Address arg) {
        if (arg == null) {
            return false;
        }
        RemoteAddress remoteArg = (RemoteAddress)arg;
        if (this.addr >= 0L && remoteArg.addr < 0L) {
            return true;
        }
        if (this.addr < 0L && remoteArg.addr >= 0L) {
            return false;
        }
        return this.addr <= remoteArg.addr;
    }

    @Override
    public boolean greaterThan(Address arg) {
        if (arg == null) {
            return true;
        }
        RemoteAddress remoteArg = (RemoteAddress)arg;
        if (this.addr >= 0L && remoteArg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && remoteArg.addr >= 0L) {
            return true;
        }
        return this.addr > remoteArg.addr;
    }

    @Override
    public boolean greaterThanOrEqual(Address arg) {
        if (arg == null) {
            return true;
        }
        RemoteAddress remoteArg = (RemoteAddress)arg;
        if (this.addr >= 0L && remoteArg.addr < 0L) {
            return false;
        }
        if (this.addr < 0L && remoteArg.addr >= 0L) {
            return true;
        }
        return this.addr >= remoteArg.addr;
    }

    @Override
    public Address andWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr & mask;
        if (value == 0L) {
            return null;
        }
        return new RemoteAddress(this.debugger, value);
    }

    @Override
    public Address orWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr | mask;
        if (value == 0L) {
            return null;
        }
        return new RemoteAddress(this.debugger, value);
    }

    @Override
    public Address xorWithMask(long mask) throws UnsupportedOperationException {
        long value = this.addr ^ mask;
        if (value == 0L) {
            return null;
        }
        return new RemoteAddress(this.debugger, value);
    }

    long getValue() {
        return this.addr;
    }

    private static void check(boolean arg, String failMessage) {
        if (!arg) {
            System.err.println(failMessage + ": FAILED");
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        RemoteAddress p1 = new RemoteAddress(null, 0x7FFFFFFFFFFFFFF0L);
        RemoteAddress p2 = (RemoteAddress)p1.addOffsetTo(10L);
        RemoteAddress n1 = (RemoteAddress)p2.addOffsetTo(10L);
        RemoteAddress n2 = (RemoteAddress)n1.addOffsetTo(10L);
        RemoteAddress.check(p1.lessThan(p2), "lessThan 1");
        RemoteAddress.check(p1.lessThan(n1), "lessThan 2");
        RemoteAddress.check(p1.lessThan(n2), "lessThan 3");
        RemoteAddress.check(p2.lessThan(n1), "lessThan 4");
        RemoteAddress.check(p2.lessThan(n2), "lessThan 5");
        RemoteAddress.check(n1.lessThan(n2), "lessThan 6");
        RemoteAddress.check(!p1.lessThan(p1), "lessThan 7");
        RemoteAddress.check(!p2.lessThan(p2), "lessThan 8");
        RemoteAddress.check(!n1.lessThan(n1), "lessThan 9");
        RemoteAddress.check(!n2.lessThan(n2), "lessThan 10");
        RemoteAddress.check(!p2.lessThan(p1), "lessThan 11");
        RemoteAddress.check(!n1.lessThan(p1), "lessThan 12");
        RemoteAddress.check(!n2.lessThan(p1), "lessThan 13");
        RemoteAddress.check(!n1.lessThan(p2), "lessThan 14");
        RemoteAddress.check(!n2.lessThan(p2), "lessThan 15");
        RemoteAddress.check(!n2.lessThan(n1), "lessThan 16");
        RemoteAddress.check(p1.lessThanOrEqual(p1), "lessThanOrEqual 1");
        RemoteAddress.check(p2.lessThanOrEqual(p2), "lessThanOrEqual 2");
        RemoteAddress.check(n1.lessThanOrEqual(n1), "lessThanOrEqual 3");
        RemoteAddress.check(n2.lessThanOrEqual(n2), "lessThanOrEqual 4");
        RemoteAddress.check(p1.lessThanOrEqual(p2), "lessThanOrEqual 5");
        RemoteAddress.check(p1.lessThanOrEqual(n1), "lessThanOrEqual 6");
        RemoteAddress.check(p1.lessThanOrEqual(n2), "lessThanOrEqual 7");
        RemoteAddress.check(p2.lessThanOrEqual(n1), "lessThanOrEqual 8");
        RemoteAddress.check(p2.lessThanOrEqual(n2), "lessThanOrEqual 9");
        RemoteAddress.check(n1.lessThanOrEqual(n2), "lessThanOrEqual 10");
        RemoteAddress.check(!p2.lessThanOrEqual(p1), "lessThanOrEqual 11");
        RemoteAddress.check(!n1.lessThanOrEqual(p1), "lessThanOrEqual 12");
        RemoteAddress.check(!n2.lessThanOrEqual(p1), "lessThanOrEqual 13");
        RemoteAddress.check(!n1.lessThanOrEqual(p2), "lessThanOrEqual 14");
        RemoteAddress.check(!n2.lessThanOrEqual(p2), "lessThanOrEqual 15");
        RemoteAddress.check(!n2.lessThanOrEqual(n1), "lessThanOrEqual 16");
        RemoteAddress.check(n2.greaterThan(p1), "greaterThan 1");
        RemoteAddress.check(n2.greaterThan(p2), "greaterThan 2");
        RemoteAddress.check(n2.greaterThan(n1), "greaterThan 3");
        RemoteAddress.check(n1.greaterThan(p1), "greaterThan 4");
        RemoteAddress.check(n1.greaterThan(p2), "greaterThan 5");
        RemoteAddress.check(p2.greaterThan(p1), "greaterThan 6");
        RemoteAddress.check(!p1.greaterThan(p1), "greaterThan 7");
        RemoteAddress.check(!p2.greaterThan(p2), "greaterThan 8");
        RemoteAddress.check(!n1.greaterThan(n1), "greaterThan 9");
        RemoteAddress.check(!n2.greaterThan(n2), "greaterThan 10");
        RemoteAddress.check(!p1.greaterThan(n2), "greaterThan 11");
        RemoteAddress.check(!p2.greaterThan(n2), "greaterThan 12");
        RemoteAddress.check(!n1.greaterThan(n2), "greaterThan 13");
        RemoteAddress.check(!p1.greaterThan(n1), "greaterThan 14");
        RemoteAddress.check(!p2.greaterThan(n1), "greaterThan 15");
        RemoteAddress.check(!p1.greaterThan(p2), "greaterThan 16");
        RemoteAddress.check(p1.greaterThanOrEqual(p1), "greaterThanOrEqual 1");
        RemoteAddress.check(p2.greaterThanOrEqual(p2), "greaterThanOrEqual 2");
        RemoteAddress.check(n1.greaterThanOrEqual(n1), "greaterThanOrEqual 3");
        RemoteAddress.check(n2.greaterThanOrEqual(n2), "greaterThanOrEqual 4");
        RemoteAddress.check(n2.greaterThanOrEqual(p1), "greaterThanOrEqual 5");
        RemoteAddress.check(n2.greaterThanOrEqual(p2), "greaterThanOrEqual 6");
        RemoteAddress.check(n2.greaterThanOrEqual(n1), "greaterThanOrEqual 7");
        RemoteAddress.check(n1.greaterThanOrEqual(p1), "greaterThanOrEqual 8");
        RemoteAddress.check(n1.greaterThanOrEqual(p2), "greaterThanOrEqual 9");
        RemoteAddress.check(p2.greaterThanOrEqual(p1), "greaterThanOrEqual 10");
        RemoteAddress.check(!p1.greaterThanOrEqual(n2), "greaterThanOrEqual 11");
        RemoteAddress.check(!p2.greaterThanOrEqual(n2), "greaterThanOrEqual 12");
        RemoteAddress.check(!n1.greaterThanOrEqual(n2), "greaterThanOrEqual 13");
        RemoteAddress.check(!p1.greaterThanOrEqual(n1), "greaterThanOrEqual 14");
        RemoteAddress.check(!p2.greaterThanOrEqual(n1), "greaterThanOrEqual 15");
        RemoteAddress.check(!p1.greaterThanOrEqual(p2), "greaterThanOrEqual 16");
        System.err.println("RemoteAddress: all tests passed successfully.");
    }
}

