/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverIntProperty;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerXADataSource;
import com.microsoft.sqlserver.jdbc.Util;
import com.microsoft.sqlserver.jdbc.XAReturnValue;
import com.microsoft.sqlserver.jdbc.XidImpl;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public final class SQLServerXAResource
implements XAResource {
    private int timeoutSeconds;
    static final int XA_START = 0;
    static final int XA_END = 1;
    static final int XA_PREPARE = 2;
    static final int XA_COMMIT = 3;
    static final int XA_ROLLBACK = 4;
    static final int XA_FORGET = 5;
    static final int XA_RECOVER = 6;
    static final int XA_PREPARE_EX = 7;
    static final int XA_ROLLBACK_EX = 8;
    static final int XA_FORGET_EX = 9;
    static final int XA_INIT = 10;
    private SQLServerConnection controlConnection;
    private SQLServerConnection con;
    private boolean serverInfoRetrieved;
    private String version;
    private String instanceName;
    private int ArchitectureMSSQL;
    private int ArchitectureOS;
    private static boolean xaInitDone;
    private static Integer xaInitLock;
    private String sResourceManagerId;
    private int enlistedTransactionCount;
    private final Logger xaLogger;
    private static int baseResourceID;
    private int tightlyCoupled = 0;
    private int isTransacrionTimeoutSet = 0;
    public static final int SSTRANSTIGHTLYCPLD = 32768;
    private SQLServerCallableStatement[] xaStatements = new SQLServerCallableStatement[]{null, null, null, null, null, null, null, null, null, null};
    private final String traceID = " XAResourceID:" + SQLServerXAResource.nextResourceID();

    public String toString() {
        return this.traceID;
    }

    SQLServerXAResource(SQLServerConnection sQLServerConnection, SQLServerConnection sQLServerConnection2, String string) {
        this.xaLogger = SQLServerXADataSource.xaLogger;
        this.controlConnection = sQLServerConnection2;
        this.con = sQLServerConnection;
        Properties properties = sQLServerConnection.activeConnectionProperties;
        this.sResourceManagerId = properties == null ? "" : properties.getProperty(SQLServerDriverStringProperty.SERVER_NAME.toString()) + "." + properties.getProperty(SQLServerDriverStringProperty.DATABASE_NAME.toString()) + "." + properties.getProperty(SQLServerDriverIntProperty.PORT_NUMBER.toString());
        if (this.xaLogger.isLoggable(Level.FINE)) {
            this.xaLogger.fine(this.toString() + " created by (" + string + ")");
        }
        this.serverInfoRetrieved = false;
        this.version = "0";
        this.instanceName = "";
        this.ArchitectureMSSQL = 0;
        this.ArchitectureOS = 0;
    }

    private synchronized SQLServerCallableStatement getXACallableStatementHandle(int n) throws SQLServerException {
        assert (n >= 0 && n <= 9);
        assert (n < this.xaStatements.length);
        if (null != this.xaStatements[n]) {
            return this.xaStatements[n];
        }
        CallableStatement callableStatement = null;
        switch (n) {
            case 0: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_start(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 1: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_end(?, ?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 2: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_prepare(?, ?, ?, ?, ?)}");
                break;
            }
            case 3: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_commit(?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 4: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_rollback(?, ?, ?, ?, ?)}");
                break;
            }
            case 5: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_forget(?, ?, ?, ?, ?)}");
                break;
            }
            case 6: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_recover(?, ?, ?, ?)}");
                break;
            }
            case 7: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_prepare_ex(?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 8: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_rollback_ex(?, ?, ?, ?, ?, ?)}");
                break;
            }
            case 9: {
                callableStatement = this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_forget_ex(?, ?, ?, ?, ?, ?)}");
                break;
            }
            default: {
                assert (false) : "Bad handle request:" + n;
                break;
            }
        }
        this.xaStatements[n] = (SQLServerCallableStatement)callableStatement;
        return this.xaStatements[n];
    }

    private synchronized void closeXAStatements() throws SQLServerException {
        for (int i = 0; i < this.xaStatements.length; ++i) {
            if (null == this.xaStatements[i]) continue;
            this.xaStatements[i].close();
            this.xaStatements[i] = null;
        }
    }

    final synchronized void close() throws SQLServerException {
        block3: {
            try {
                this.closeXAStatements();
            }
            catch (Exception exception) {
                if (!this.xaLogger.isLoggable(Level.WARNING)) break block3;
                this.xaLogger.warning(this.toString() + "Closing exception ignored: " + exception);
            }
        }
        if (null != this.controlConnection) {
            this.controlConnection.close();
        }
    }

    private String flagsDisplay(int n) {
        if (0 == n) {
            return "TMNOFLAGS";
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        if (0 != (0x800000 & n)) {
            stringBuilder.append("TMENDRSCAN");
        }
        if (0 != (0x20000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMFAIL");
        }
        if (0 != (0x200000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMJOIN");
        }
        if (0 != (0x40000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMONEPHASE");
        }
        if (0 != (0x8000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMRESUME");
        }
        if (0 != (0x1000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSTARTRSCAN");
        }
        if (0 != (0x4000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSUCCESS");
        }
        if (0 != (0x2000000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("TMSUSPEND");
        }
        if (0 != (0x8000 & n)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("|");
            }
            stringBuilder.append("SSTRANSTIGHTLYCPLD");
        }
        return stringBuilder.toString();
    }

    private String cookieDisplay(byte[] byArray) {
        return Util.byteToHexDisplayString(byArray);
    }

    private String typeDisplay(int n) {
        switch (n) {
            case 0: {
                return "XA_START";
            }
            case 1: {
                return "XA_END";
            }
            case 2: {
                return "XA_PREPARE";
            }
            case 3: {
                return "XA_COMMIT";
            }
            case 4: {
                return "XA_ROLLBACK";
            }
            case 5: {
                return "XA_FORGET";
            }
            case 6: {
                return "XA_RECOVER";
            }
        }
        return "UNKNOWN" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final XAReturnValue DTC_XA_Interface(int var1_1, Xid var2_2, int var3_3) throws XAException {
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " Calling XA function for type:" + this.typeDisplay(var1_1) + " flags:" + this.flagsDisplay(var3_3) + " xid:" + XidImpl.xidDisplay(var2_2));
        }
        var4_4 = 0;
        var5_5 = null;
        var6_6 = null;
        if (var2_2 != null) {
            var4_4 = var2_2.getFormatId();
            var5_5 = var2_2.getGlobalTransactionId();
            var6_6 = var2_2.getBranchQualifier();
        }
        var7_7 = "DTC_XA_";
        var8_8 = 1;
        var9_9 = 0;
        var10_10 = new XAReturnValue();
        var11_11 = null;
        try {
            var12_12 = this;
            synchronized (var12_12) {
                if (this.controlConnection == null) {
                    try {
                        var13_15 = SQLServerXAResource.xaInitLock;
                        synchronized (var13_15) {
                            if (!SQLServerXAResource.xaInitDone) {
                                var14_20 = null;
                                var14_20 = (SQLServerCallableStatement)this.controlConnection.prepareCall("{call master..xp_sqljdbc_xa_init_ex(?, ?,?)}");
                                var14_20.registerOutParameter(1, 4);
                                var14_20.registerOutParameter(2, 1);
                                var14_20.registerOutParameter(3, 1);
                                try {
                                    var14_20.execute();
                                }
                                catch (SQLServerException var15_22) {
                                    block70: {
                                        try {
                                            var14_20.close();
                                            this.controlConnection.close();
                                        }
                                        catch (SQLException var16_31) {
                                            if (!this.xaLogger.isLoggable(Level.FINER)) break block70;
                                            this.xaLogger.finer(this.toString() + " Ignoring exception when closing failed execution. exception:" + var16_31);
                                        }
                                    }
                                    if (this.xaLogger.isLoggable(Level.FINER)) {
                                        this.xaLogger.finer(this.toString() + " exception:" + var15_22);
                                    }
                                    throw var15_22;
                                }
                                var15_23 = var14_20.getInt(1);
                                var16_32 = var14_20.getString(2);
                                var17_34 = var14_20.getString(3);
                                if (this.xaLogger.isLoggable(Level.FINE)) {
                                    this.xaLogger.fine(this.toString() + " Server XA DLL version:" + var17_34);
                                }
                                var14_20.close();
                                if (0 != var15_23) {
                                    if (!(SQLServerXAResource.$assertionsDisabled || null != var16_32 && var16_32.length() > 1)) {
                                        throw new AssertionError();
                                    }
                                    this.controlConnection.close();
                                    var18_35 = new MessageFormat(SQLServerException.getErrString("R_failedToInitializeXA"));
                                    var19_36 = new Object[]{String.valueOf(var15_23), var16_32};
                                    var20_37 = new XAException(var18_35.format(var19_36));
                                    var20_37.errorCode = var15_23;
                                    if (this.xaLogger.isLoggable(Level.FINER)) {
                                        this.xaLogger.finer(this.toString() + " exception:" + var20_37);
                                    }
                                    throw var20_37;
                                }
                                SQLServerXAResource.xaInitDone = true;
                            }
                        }
                    }
                    catch (SQLServerException var13_16) {
                        var14_20 = new MessageFormat(SQLServerException.getErrString("R_failedToCreateXAConnection"));
                        var15_24 = new Object[]{new String(var13_16.getMessage())};
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " exception:" + var14_20.format(var15_24));
                        }
                        SQLServerException.makeFromDriverError(null, null, var14_20.format(var15_24), null, true);
                    }
                }
            }
            switch (var1_1) {
                case 0: {
                    if (this.serverInfoRetrieved) ** GOTO lbl107
                    try {
                        this.serverInfoRetrieved = true;
                        var12_12 = "select convert(varchar(100), SERVERPROPERTY('Edition'))as edition,  convert(varchar(100), SERVERPROPERTY('InstanceName'))as instance, convert(varchar(100), SERVERPROPERTY('ProductVersion')) as version";
                        var13_15 = this.controlConnection.createStatement();
                        var14_20 = var13_15.executeQuery((String)var12_12);
                        var14_20.next();
                        var15_25 = var14_20.getString(1);
                        this.ArchitectureMSSQL = null != var15_25 && var15_25.contains("(64-bit)") != false ? 64 : 32;
                        this.instanceName = var14_20.getString(2) == null ? "MSSQLSERVER" : var14_20.getString(2);
                        this.version = var14_20.getString(3);
                        if (null == this.version) {
                            this.version = "0";
                        } else if (-1 != this.version.indexOf(46)) {
                            this.version = this.version.substring(0, this.version.indexOf(46));
                        }
                        var12_12 = "SELECT SUBSTRING(@@VERSION, CHARINDEX('<', @@VERSION)+2, 2)";
                        var14_20 = var13_15.executeQuery((String)var12_12);
                        var14_20.next();
                        this.ArchitectureOS = Integer.parseInt(var14_20.getString(1));
                        var14_20.close();
                        var13_15.close();
                    }
                    catch (Exception var12_13) {
                        if (!this.xaLogger.isLoggable(Level.WARNING)) ** GOTO lbl107
                        this.xaLogger.warning(this.toString() + " Cannot retrieve server information: :" + var12_13.getMessage());
                    }
lbl107:
                    // 4 sources

                    var7_7 = "START:";
                    var11_11 = this.getXACallableStatementHandle(0);
                    var11_11.registerOutParameter(var8_8++, 4);
                    var11_11.registerOutParameter(var8_8++, 1);
                    var11_11.setBytes(var8_8++, var5_5);
                    var11_11.setBytes(var8_8++, var6_6);
                    var11_11.setInt(var8_8++, var3_3);
                    var11_11.registerOutParameter(var8_8++, -2);
                    var11_11.setInt(var8_8++, this.timeoutSeconds);
                    var11_11.setInt(var8_8++, var4_4);
                    var11_11.registerOutParameter(var8_8++, 1);
                    var11_11.setInt(var8_8++, Integer.parseInt(this.version));
                    var11_11.setInt(var8_8++, this.instanceName.length());
                    var11_11.setBytes(var8_8++, this.instanceName.getBytes());
                    var11_11.setInt(var8_8++, this.ArchitectureMSSQL);
                    var11_11.setInt(var8_8++, this.ArchitectureOS);
                    var11_11.setInt(var8_8++, this.isTransacrionTimeoutSet);
                    var11_11.registerOutParameter(var8_8++, -2);
                    break;
                }
                case 1: {
                    var7_7 = "END:";
                    var11_11 = this.getXACallableStatementHandle(1);
                    var11_11.registerOutParameter(var8_8++, 4);
                    var11_11.registerOutParameter(var8_8++, 1);
                    var11_11.setBytes(var8_8++, var5_5);
                    var11_11.setBytes(var8_8++, var6_6);
                    var11_11.setInt(var8_8++, var3_3);
                    var11_11.setInt(var8_8++, var4_4);
                    var11_11.registerOutParameter(var8_8++, -2);
                    break;
                }
                case 2: {
                    var7_7 = "PREPARE:";
                    var11_11 = (32768 & var3_3) == 32768 ? this.getXACallableStatementHandle(7) : this.getXACallableStatementHandle(2);
                    var11_11.registerOutParameter(var8_8++, 4);
                    var11_11.registerOutParameter(var8_8++, 1);
                    var11_11.setBytes(var8_8++, var5_5);
                    var11_11.setBytes(var8_8++, var6_6);
                    if ((32768 & var3_3) == 32768) {
                        var11_11.setInt(var8_8++, var3_3);
                    }
                    var11_11.setInt(var8_8++, var4_4);
                    break;
                }
                case 3: {
                    var7_7 = "COMMIT:";
                    var11_11 = this.getXACallableStatementHandle(3);
                    var11_11.registerOutParameter(var8_8++, 4);
                    var11_11.registerOutParameter(var8_8++, 1);
                    var11_11.setBytes(var8_8++, var5_5);
                    var11_11.setBytes(var8_8++, var6_6);
                    var11_11.setInt(var8_8++, var3_3);
                    var11_11.setInt(var8_8++, var4_4);
                    break;
                }
                case 4: {
                    var7_7 = "ROLLBACK:";
                    var11_11 = (32768 & var3_3) == 32768 ? this.getXACallableStatementHandle(8) : this.getXACallableStatementHandle(4);
                    var11_11.registerOutParameter(var8_8++, 4);
                    var11_11.registerOutParameter(var8_8++, 1);
                    var11_11.setBytes(var8_8++, var5_5);
                    var11_11.setBytes(var8_8++, var6_6);
                    if ((32768 & var3_3) == 32768) {
                        var11_11.setInt(var8_8++, var3_3);
                    }
                    var11_11.setInt(var8_8++, var4_4);
                    break;
                }
                case 5: {
                    var7_7 = "FORGET:";
                    var11_11 = (32768 & var3_3) == 32768 ? this.getXACallableStatementHandle(9) : this.getXACallableStatementHandle(5);
                    var11_11.registerOutParameter(var8_8++, 4);
                    var11_11.registerOutParameter(var8_8++, 1);
                    var11_11.setBytes(var8_8++, var5_5);
                    var11_11.setBytes(var8_8++, var6_6);
                    if ((32768 & var3_3) == 32768) {
                        var11_11.setInt(var8_8++, var3_3);
                    }
                    var11_11.setInt(var8_8++, var4_4);
                    break;
                }
                case 6: {
                    var7_7 = "RECOVER:";
                    var11_11 = this.getXACallableStatementHandle(6);
                    var11_11.registerOutParameter(var8_8++, 4);
                    var11_11.registerOutParameter(var8_8++, 1);
                    var11_11.setInt(var8_8++, var3_3);
                    var11_11.registerOutParameter(var8_8++, -2);
                    break;
                }
                default: {
                    if (!SQLServerXAResource.$assertionsDisabled) {
                        throw new AssertionError((Object)("Unknown execution type:" + var1_1));
                    }
                    break;
                }
            }
            var11_11.execute();
            var9_9 = var11_11.getInt(1);
            var12_12 = var11_11.getString(2);
            if (var1_1 == 0) {
                var13_15 = var11_11.getString(9);
                if (this.xaLogger.isLoggable(Level.FINE)) {
                    this.xaLogger.fine(this.toString() + " Server XA DLL version:" + (String)var13_15);
                    if (null != var11_11.getString(16)) {
                        var14_20 = new StringBuffer(var11_11.getString(16));
                        var14_20.insert(20, '-');
                        var14_20.insert(16, '-');
                        var14_20.insert(12, '-');
                        var14_20.insert(8, '-');
                        this.xaLogger.fine(this.toString() + " XID to UoW mapping for XA type:XA_START XID: " + XidImpl.xidDisplay(var2_2) + " UoW: " + var14_20.toString());
                    }
                }
            }
            if (var1_1 == 1 && this.xaLogger.isLoggable(Level.FINE) && null != var11_11.getString(7)) {
                var13_15 = new StringBuffer(var11_11.getString(7));
                var13_15.insert(20, '-');
                var13_15.insert(16, '-');
                var13_15.insert(12, '-');
                var13_15.insert(8, '-');
                this.xaLogger.fine(this.toString() + " XID to UoW mapping for XA type:XA_END XID: " + XidImpl.xidDisplay(var2_2) + " UoW: " + var13_15.toString());
            }
            if (3 == var9_9 && 1 != var1_1 && 2 != var1_1 || 0 != var9_9 && 3 != var9_9) {
                block72: {
                    if (!(SQLServerXAResource.$assertionsDisabled || null != var12_12 && var12_12.length() > 1)) {
                        throw new AssertionError();
                    }
                    var13_15 = new MessageFormat(SQLServerException.getErrString("R_failedFunctionXA"));
                    var14_20 = new Object[]{var7_7, String.valueOf(var9_9), var12_12};
                    var15_26 = new XAException(var13_15.format(var14_20));
                    var15_26.errorCode = var9_9;
                    if (var1_1 == 1 && -7 == var9_9) {
                        try {
                            if (this.xaLogger.isLoggable(Level.FINER)) {
                                this.xaLogger.finer(this.toString() + " Begin un-enlist, enlisted count:" + this.enlistedTransactionCount);
                            }
                            this.con.JTAUnenlistConnection();
                            --this.enlistedTransactionCount;
                            if (this.xaLogger.isLoggable(Level.FINER)) {
                                this.xaLogger.finer(this.toString() + " End un-enlist, enlisted count:" + this.enlistedTransactionCount);
                            }
                        }
                        catch (SQLServerException var16_33) {
                            if (!this.xaLogger.isLoggable(Level.FINER)) break block72;
                            this.xaLogger.finer(this.toString() + " Ignoring exception:" + var16_33);
                        }
                    }
                }
                throw var15_26;
            }
            if (var1_1 == 0) {
                var13_15 = var11_11.getBytes(6);
                if (var13_15 == null) {
                    var14_20 = new MessageFormat(SQLServerException.getErrString("R_noTransactionCookie"));
                    var15_27 = new Object[]{var7_7};
                    SQLServerException.makeFromDriverError(null, null, var14_20.format(var15_27), null, true);
                } else {
                    try {
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " Begin enlisting, cookie:" + this.cookieDisplay((byte[])var13_15) + " enlisted count:" + this.enlistedTransactionCount);
                        }
                        this.con.JTAEnlistConnection((byte[])var13_15);
                        ++this.enlistedTransactionCount;
                        if (this.xaLogger.isLoggable(Level.FINER)) {
                            this.xaLogger.finer(this.toString() + " End enlisting, cookie:" + this.cookieDisplay((byte[])var13_15) + " enlisted count:" + this.enlistedTransactionCount);
                        }
                    }
                    catch (SQLServerException var14_21) {
                        var15_28 = new MessageFormat(SQLServerException.getErrString("R_failedToEnlist"));
                        var16_32 = new Object[]{var14_21.getMessage()};
                        SQLServerException.makeFromDriverError(null, null, var15_28.format(var16_32), null, true);
                    }
                }
            }
            if (var1_1 == 1) {
                try {
                    if (this.xaLogger.isLoggable(Level.FINER)) {
                        this.xaLogger.finer(this.toString() + " Begin un-enlist, enlisted count:" + this.enlistedTransactionCount);
                    }
                    this.con.JTAUnenlistConnection();
                    --this.enlistedTransactionCount;
                    if (this.xaLogger.isLoggable(Level.FINER)) {
                        this.xaLogger.finer(this.toString() + " End un-enlist, enlisted count:" + this.enlistedTransactionCount);
                    }
                }
                catch (SQLServerException var13_17) {
                    var14_20 = new MessageFormat(SQLServerException.getErrString("R_failedToUnEnlist"));
                    var15_29 = new Object[]{var13_17.getMessage()};
                    SQLServerException.makeFromDriverError(null, null, var14_20.format(var15_29), null, true);
                }
            }
            if (var1_1 == 6) {
                try {
                    var10_10.bData = var11_11.getBytes(4);
                }
                catch (SQLServerException var13_18) {
                    var14_20 = new MessageFormat(SQLServerException.getErrString("R_failedToReadRecoveryXIDs"));
                    var15_30 = new Object[]{var13_18.getMessage()};
                    SQLServerException.makeFromDriverError(null, null, var14_20.format(var15_30), null, true);
                }
            }
        }
        catch (SQLServerException var12_14) {
            if (this.xaLogger.isLoggable(Level.FINER)) {
                this.xaLogger.finer(this.toString() + " exception:" + var12_14);
            }
            var13_19 = new XAException(var12_14.toString());
            var13_19.errorCode = -3;
            throw var13_19;
        }
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " Status:" + var9_9);
        }
        var10_10.nStatus = var9_9;
        return var10_10;
    }

    @Override
    public void start(Xid xid, int n) throws XAException {
        this.tightlyCoupled = n & 0x8000;
        this.DTC_XA_Interface(0, xid, n);
    }

    @Override
    public void end(Xid xid, int n) throws XAException {
        this.DTC_XA_Interface(1, xid, n | this.tightlyCoupled);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int n = 0;
        XAReturnValue xAReturnValue = this.DTC_XA_Interface(2, xid, this.tightlyCoupled);
        n = xAReturnValue.nStatus;
        return n;
    }

    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        this.DTC_XA_Interface(3, xid, (bl ? 0x40000000 : 0) | this.tightlyCoupled);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.DTC_XA_Interface(4, xid, this.tightlyCoupled);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.DTC_XA_Interface(5, xid, this.tightlyCoupled);
    }

    @Override
    public Xid[] recover(int n) throws XAException {
        int n2;
        int n3;
        XAReturnValue xAReturnValue = this.DTC_XA_Interface(6, null, n | this.tightlyCoupled);
        Vector<XidImpl> vector = new Vector<XidImpl>();
        if (null == xAReturnValue.bData) {
            return new XidImpl[0];
        }
        for (int i = 0; i < xAReturnValue.bData.length; i += n3) {
            int n4;
            int n5 = 1;
            n2 = 0;
            for (n4 = 0; n4 < 4; ++n4) {
                n3 = xAReturnValue.bData[i + n4] & 0xFF;
                n2 += (n3 *= n5);
                n5 *= 256;
            }
            i += 4;
            n4 = xAReturnValue.bData[i++] & 0xFF;
            n3 = xAReturnValue.bData[i++] & 0xFF;
            byte[] byArray = new byte[n4];
            byte[] byArray2 = new byte[n3];
            System.arraycopy(xAReturnValue.bData, i, byArray, 0, n4);
            System.arraycopy(xAReturnValue.bData, i += n4, byArray2, 0, n3);
            XidImpl xidImpl = new XidImpl(n2, byArray, byArray2);
            vector.add(xidImpl);
        }
        Xid[] xidArray = new XidImpl[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            xidArray[n2] = (XidImpl)vector.elementAt(n2);
            if (!this.xaLogger.isLoggable(Level.FINER)) continue;
            this.xaLogger.finer(this.toString() + ((XidImpl)xidArray[n2]).toString());
        }
        return xidArray;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " xares:" + xAResource);
        }
        if (!(xAResource instanceof SQLServerXAResource)) {
            return false;
        }
        SQLServerXAResource sQLServerXAResource = (SQLServerXAResource)xAResource;
        return sQLServerXAResource.sResourceManagerId.equals(this.sResourceManagerId);
    }

    @Override
    public boolean setTransactionTimeout(int n) throws XAException {
        this.isTransacrionTimeoutSet = 1;
        this.timeoutSeconds = n;
        if (this.xaLogger.isLoggable(Level.FINER)) {
            this.xaLogger.finer(this.toString() + " TransactionTimeout:" + n);
        }
        return true;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeoutSeconds;
    }

    private static synchronized int nextResourceID() {
        return ++baseResourceID;
    }

    static {
        baseResourceID = 0;
        xaInitLock = new Integer(0);
    }
}

