/*
 * Decompiled with CFR 0.152.
 */
package de.obj.utils;

import de.obj.utils.FileException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class FileUtils {
    public void deleteDirectoryOrFolder(String fileLocation) throws FileException {
        Path sourceDirectory = Paths.get(fileLocation, new String[0]);
        try {
            Files.walkFileTree(sourceDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new FileException("Error while deleting directory " + e.getMessage());
        }
    }

    public void copySourceToTarget(String source, String target) throws FileException {
        final Path targetPath = Paths.get(target, new String[0]);
        final Path sourcePath = Paths.get(source, new String[0]);
        try {
            Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new FileException("Error while creating directory " + e.getMessage());
        }
    }
}

