/*
 * Decompiled with CFR 0.152.
 */
package de.obj.utils;

import de.obj.utils.ICompression;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipCompress
implements ICompression {
    @Override
    public String getCompressionSuffix() {
        return ".zip";
    }

    @Override
    public void compressSourceToTarget(String source, String target) {
        block29: {
            Path targetPath = Paths.get(target, new String[0]);
            final Path sourcePath = Paths.get(source, new String[0]);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(targetPath.toFile());
                final ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                try {
                    try {
                        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                zipOutputStream.putNextEntry(new ZipEntry(sourcePath.relativize(file).toString()));
                                Files.copy(file, zipOutputStream);
                                zipOutputStream.closeEntry();
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                zipOutputStream.putNextEntry(new ZipEntry(String.valueOf(sourcePath.relativize(dir).toString()) + "/"));
                                zipOutputStream.closeEntry();
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (zipOutputStream == null) break block29;
                        try {
                            zipOutputStream.closeEntry();
                            zipOutputStream.close();
                        }
                        catch (IOException iOException) {
                        }
                    }
                    catch (IOException iOException) {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                        }
                        if (zipOutputStream == null) break block29;
                        try {
                            zipOutputStream.closeEntry();
                            zipOutputStream.close();
                        }
                        catch (IOException iOException3) {}
                    }
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zipOutputStream != null) {
                        try {
                            zipOutputStream.closeEntry();
                            zipOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

