/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.CatalogUtils;
import de.timeglobe.catalog.ForeignKeyColumn;
import de.timeglobe.catalog.Table;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.LinkedHashMap;

public class ForeignKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, ForeignKeyColumn> foreignKeyColumns = new LinkedHashMap();
    private Table table;
    private String name;
    private String refName;
    private Table refTable;
    private String replication;

    public ForeignKey(Table table, String name, String refName) throws Exception {
        this.table = table;
        if (name == null) {
            throw new Exception("table " + table.getName() + " unnamed foreign key");
        }
        this.name = name;
        this.refName = refName;
    }

    public void solveReferences(Catalog catalog) throws Exception {
        this.refTable = catalog.getTable(this.refName);
        if (this.refTable == null) {
            throw new Exception("table " + this.table.getName() + " foreign key " + this.name + ": invalid table name: " + this.refName);
        }
        this.refTable.addChildRef(this);
    }

    public String getName() {
        return this.name;
    }

    public String getRefName() {
        return this.refName;
    }

    public LinkedHashMap<String, ForeignKeyColumn> getForeignKeyColumns() {
        return this.foreignKeyColumns;
    }

    public ForeignKeyColumn addForeignKeyColumn(ForeignKeyColumn foreignKeyColumn) throws Exception {
        if (this.table.getTableColumn(foreignKeyColumn.getName()) == null) {
            throw new Exception("table " + this.getTable().getName() + " foreign key " + this.name + ": invalid column: " + foreignKeyColumn.getName());
        }
        if (this.foreignKeyColumns.get(foreignKeyColumn.getName()) != null) {
            throw new Exception("table " + this.table.getName() + " foreign key " + this.name + ": column already specified: " + foreignKeyColumn.getName());
        }
        this.foreignKeyColumns.put(foreignKeyColumn.getName(), foreignKeyColumn);
        return foreignKeyColumn;
    }

    public Table getRefTable() {
        return this.refTable;
    }

    public Table getTable() {
        return this.table;
    }

    public String getDDLCreate(int dialect) {
        ForeignKeyColumn ic;
        StringBuffer buf = new StringBuffer();
        String sep = "";
        buf.append("ALTER TABLE " + this.table.getName() + " ADD CONSTRAINT " + "fk_" + this.table.getName() + "_" + this.name + " FOREIGN KEY (");
        for (String tcn : this.foreignKeyColumns.keySet()) {
            ic = this.foreignKeyColumns.get(tcn);
            buf.append(String.valueOf(sep) + ic.getName());
            sep = ", ";
        }
        buf.append(") REFERENCES " + this.refTable.getName() + " (");
        sep = "";
        for (String tcn : this.foreignKeyColumns.keySet()) {
            ic = this.foreignKeyColumns.get(tcn);
            buf.append(String.valueOf(sep) + ic.getReferencedName());
            sep = ", ";
        }
        buf.append(")");
        return buf.toString();
    }

    public String getDDLDrop(int dialect) {
        return "ALTER TABLE " + this.table.getName() + " DROP CONSTRAINT " + this.name;
    }

    public String getReplication() {
        return this.replication;
    }

    public void setReplication(String replication) {
        this.replication = replication;
    }

    public String getHash() throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuffer b = new StringBuffer();
        b.append(String.valueOf(this.name) + "." + this.refTable.getName() + ".");
        for (String n : this.foreignKeyColumns.keySet()) {
            b.append(this.foreignKeyColumns.get(n).getHash());
        }
        return CatalogUtils.getHash(b.toString());
    }

    public boolean compare(ForeignKey o) {
        System.err.println(this.toString());
        System.err.println(o.toString());
        return false;
    }

    public String toString() {
        return "ForeignKey [foreignKeyColumns=" + this.foreignKeyColumns + ", table=" + this.table + ", name=" + this.name + ", refName=" + this.refName + ", refTable=" + this.refTable + "]";
    }
}

