/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.CatalogUtils;
import de.timeglobe.catalog.IndexColumn;
import de.timeglobe.catalog.Table;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.LinkedHashMap;

public class Index
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean unique;
    private LinkedHashMap<String, IndexColumn> indexColumns = new LinkedHashMap();
    private Table table;
    private String name;

    public Index(Table table, String name, boolean unique) {
        this.table = table;
        this.name = name;
        this.unique = unique;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void solve(Catalog catalog) throws Exception {
    }

    public String getName() {
        return this.name;
    }

    public LinkedHashMap<String, IndexColumn> getIndexColumns() {
        return this.indexColumns;
    }

    public IndexColumn addIndexColumn(IndexColumn indexColumn) throws Exception {
        if (this.table.getTableColumn(indexColumn.getName()) == null) {
            throw new Exception("table " + this.table.getName() + " index " + this.name + ": invalid column: " + indexColumn.getName());
        }
        if (this.indexColumns.get(indexColumn.getName()) != null) {
            throw new Exception("table " + this.table.getName() + " index " + this.name + ": column already specified: " + indexColumn.getName());
        }
        this.indexColumns.put(indexColumn.getName(), indexColumn);
        return indexColumn;
    }

    public String getDDLCreate(int dialect) {
        StringBuffer buf = new StringBuffer();
        String sep = "";
        buf.append("CREATE" + (this.unique ? " UNIQUE" : "") + " INDEX " + this.name + " ON " + this.table.getName() + "(");
        for (String tcn : this.indexColumns.keySet()) {
            IndexColumn ic = this.indexColumns.get(tcn);
            buf.append(String.valueOf(sep) + ic.getDDLCreate(dialect));
            sep = ", ";
        }
        buf.append(")");
        return buf.toString();
    }

    public String getDDLDrop(int dialect) {
        StringBuffer buf = new StringBuffer();
        String sep = "";
        buf.append("DROP INDEX " + this.name);
        return buf.toString();
    }

    public String getHash() throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuffer b = new StringBuffer();
        b.append(String.valueOf(this.name) + "." + this.unique + ".");
        for (String n : this.indexColumns.keySet()) {
            b.append(this.indexColumns.get(n).getHash());
        }
        return CatalogUtils.getHash(b.toString());
    }
}

