/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.catalog;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.CatalogUtils;
import de.timeglobe.catalog.ForeignKey;
import de.timeglobe.catalog.ForeignKeyColumn;
import de.timeglobe.catalog.IBackupWriter;
import de.timeglobe.catalog.IRestoreWriter;
import de.timeglobe.catalog.Index;
import de.timeglobe.catalog.PrimaryKeyColumn;
import de.timeglobe.catalog.TableColumn;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Vector;

public class Table
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap<String, ForeignKey> foreignKeys = new LinkedHashMap();
    private LinkedHashMap<String, Index> indices = new LinkedHashMap();
    private LinkedHashMap<String, TableColumn> tableColumns = new LinkedHashMap();
    private LinkedHashMap<String, LinkedHashMap<String, ForeignKey>> childRefs = new LinkedHashMap();
    private LinkedHashMap<String, String> constants = new LinkedHashMap();
    private String name;
    private String replication;

    public Table(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TableColumn addTableColumn(TableColumn tableColumn) throws Exception {
        if (this.tableColumns.get(tableColumn.getName()) != null) {
            throw new Exception("table " + this.getName() + " column already specified: " + tableColumn.getName());
        }
        this.tableColumns.put(tableColumn.getName(), tableColumn);
        return tableColumn;
    }

    public ForeignKey addForeignKey(ForeignKey foreignKey) throws Exception {
        if (this.foreignKeys.get(foreignKey.getName()) != null) {
            throw new Exception("table " + foreignKey.getTable().getName() + " duplicate foreign key " + foreignKey.getName());
        }
        this.foreignKeys.put(foreignKey.getName(), foreignKey);
        return foreignKey;
    }

    public Index addIndex(Index index) throws Exception {
        if (this.indices.get(index.getName()) != null) {
            throw new Exception("table " + this.getName() + " duplicate index " + index.getName());
        }
        this.indices.put(index.getName(), index);
        return index;
    }

    public void addChildRef(ForeignKey foreignKey) throws Exception {
        for (String tcn : foreignKey.getForeignKeyColumns().keySet()) {
            ForeignKeyColumn fkc = foreignKey.getForeignKeyColumns().get(tcn);
            TableColumn tc = this.tableColumns.get(fkc.getReferencedName());
            if (tc == null) {
                throw new Exception("table " + foreignKey.getTable().getName() + " foreign key " + this.name + ": invalid column: " + foreignKey.getRefTable().getName() + "." + fkc.getReferencedName());
            }
            if (tc instanceof PrimaryKeyColumn) continue;
            throw new Exception("table " + foreignKey.getTable().getName() + " foreign key " + this.name + ": not a primary key member: " + foreignKey.getRefTable().getName() + "." + fkc.getReferencedName());
        }
        LinkedHashMap<String, ForeignKey> fks = this.childRefs.get(foreignKey.getTable().getName());
        if (fks == null) {
            fks = new LinkedHashMap();
            this.childRefs.put(foreignKey.getTable().getName(), fks);
        }
        fks.put(foreignKey.getName(), foreignKey);
    }

    public void solveReferences(Catalog catalog) throws Exception {
        for (String fkn : this.getForeignKeys().keySet()) {
            ForeignKey fk = this.getForeignKeys().get(fkn);
            fk.solveReferences(catalog);
        }
    }

    public LinkedHashMap<String, ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<table name=\"" + this.name + "\">\n");
        for (String tcn : this.tableColumns.keySet()) {
            TableColumn tc = this.tableColumns.get(tcn);
            buf.append(tc);
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public TableColumn getTableColumn(String name) {
        return this.tableColumns.get(name);
    }

    public String getDDLCreate(int dialect) {
        boolean hasPKColumn = false;
        StringBuffer buf = new StringBuffer();
        StringBuffer pk = new StringBuffer();
        String sep = "";
        String pkSep = "";
        buf.append("CREATE TABLE " + this.name + " (\r\n");
        for (String tcn : this.tableColumns.keySet()) {
            TableColumn tc = this.tableColumns.get(tcn);
            if (tc instanceof PrimaryKeyColumn) {
                pk.append(String.valueOf(pkSep) + tc.getName());
                pkSep = ", ";
                hasPKColumn = true;
            }
            buf.append(String.valueOf(sep) + tc.getDDLCreate(dialect));
            sep = ",\r\n";
        }
        if (hasPKColumn) {
            buf.append(String.valueOf(sep) + "PRIMARY KEY (" + pk.toString() + ")");
        }
        buf.append("\r\n)");
        return buf.toString();
    }

    public LinkedHashMap<String, Index> getIndices() {
        return this.indices;
    }

    public String getDDLDrop(int dialect) {
        return "DROP TABLE " + this.name;
    }

    public void backup(Connection c, IBackupWriter w, PrintWriter printWriter) throws SQLException, IOException {
        String sql = "SELECT * FROM " + this.name;
        Throwable throwable = null;
        Object var6_7 = null;
        try (Statement s = c.createStatement();){
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ResultSet r = s.executeQuery(sql);){
                w.writeMetadata(r.getMetaData());
                while (r.next()) {
                    w.writeRow(r);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void backupTableWithMeta(Connection c, IBackupWriter w, PrintWriter printWriter) throws SQLException, IOException {
        String sql = "SELECT * FROM " + this.name;
        Throwable throwable = null;
        Object var6_7 = null;
        try (Statement s = c.createStatement();){
            Throwable throwable2 = null;
            Object var9_12 = null;
            try (ResultSet r = s.executeQuery(sql);){
                w.writeTableMetadata(this);
                while (r.next()) {
                    w.writeRow(r);
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public void writeTableMetadata(Connection c, IBackupWriter w, PrintWriter printWriter) throws SQLException, IOException {
        w.writeTableMetadata(this);
    }

    public IRestoreWriter getRestoreWriter() {
        return new RestoreWriter();
    }

    public LinkedHashMap<String, TableColumn> getTableColumns() {
        return this.tableColumns;
    }

    public void addConstant(String name, String value) {
        this.constants.put(name, value);
    }

    public LinkedHashMap<String, String> getConstants() {
        return this.constants;
    }

    public String getReplication() {
        return this.replication;
    }

    public void setReplication(String replication) {
        this.replication = replication;
    }

    public String getHash() throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuffer b = new StringBuffer();
        b.append(String.valueOf(this.name) + ".");
        for (String n : this.tableColumns.keySet()) {
            b.append(this.tableColumns.get(n).getHash());
        }
        b.append(".");
        for (String n : this.foreignKeys.keySet()) {
            b.append(this.foreignKeys.get(n).getHash());
        }
        b.append(".");
        for (String n : this.indices.keySet()) {
            b.append(this.indices.get(n).getHash());
        }
        return CatalogUtils.getHash(b.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compare(Table o, boolean stopCompareOnDiff) {
        try {
            if (this.getHash().equals(o.getHash())) return true;
            for (String n : this.tableColumns.keySet()) {
                TableColumn tableColumnA = this.tableColumns.get(n);
                TableColumn tableColumnB = o.getTableColumn(n);
                if (tableColumnB != null) {
                    if (tableColumnA.getHash().equals(tableColumnB.getHash())) continue;
                    System.err.println("TableColumns: " + tableColumnA.getName() + ": " + tableColumnA.getHash() + " : " + tableColumnB.getHash());
                    tableColumnA.compare(tableColumnB);
                    if (!stopCompareOnDiff) continue;
                    return false;
                }
                System.err.println(String.valueOf(tableColumnA.getName()) + ": " + tableColumnA.getHash() + " : ");
                if (!stopCompareOnDiff) continue;
                return false;
            }
            for (String n : this.foreignKeys.keySet()) {
                ForeignKey foreignKeyA = this.foreignKeys.get(n);
                ForeignKey foreignKeyB = o.foreignKeys.get(n);
                if (foreignKeyB != null) {
                    if (foreignKeyA.getHash().equals(foreignKeyB.getHash())) continue;
                    System.err.println("ForeignKeys: " + foreignKeyA.getName() + ": " + foreignKeyA.getHash() + " : " + foreignKeyB.getHash());
                    foreignKeyA.compare(foreignKeyB);
                    if (!stopCompareOnDiff) continue;
                    return false;
                }
                System.err.println(String.valueOf(foreignKeyA.getName()) + ": " + foreignKeyA.getHash() + " : ");
                if (!stopCompareOnDiff) continue;
                return false;
            }
            return true;
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            return true;
        }
        catch (SignatureException e) {
            e.printStackTrace();
            return true;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return true;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean compareColumns(Table template, Vector<String> ddls) {
        TableColumn tableColumnTemplate;
        TableColumn tableColumn;
        boolean changes = false;
        for (String key : template.tableColumns.keySet()) {
            TableColumn tableColumnTemplate2 = template.tableColumns.get(key);
            TableColumn table = this.tableColumns.get(key);
            if (table != null) continue;
            ddls.add("add column " + tableColumnTemplate2.getName());
            changes = true;
        }
        for (String key : this.tableColumns.keySet()) {
            tableColumn = this.tableColumns.get(key);
            tableColumnTemplate = template.tableColumns.get(key);
            if (tableColumnTemplate != null) continue;
            ddls.add("drop column " + tableColumn.getName());
            changes = true;
        }
        for (String key : this.tableColumns.keySet()) {
            tableColumn = this.tableColumns.get(key);
            tableColumnTemplate = template.tableColumns.get(key);
            if (tableColumnTemplate == null || !tableColumn.compare(template, tableColumnTemplate, ddls)) continue;
            changes = true;
        }
        return changes;
    }

    private class RestoreWriter
    implements IRestoreWriter {
        private PreparedStatement ps = null;

        private RestoreWriter() {
        }

        @Override
        public void prepare(Connection c) throws SQLException {
            StringBuffer buf = new StringBuffer();
            StringBuffer cols = new StringBuffer();
            StringBuffer vars = new StringBuffer();
            String sep = "";
            buf.append("INSERT INTO " + Table.this.name + " (");
            for (String tcn : Table.this.tableColumns.keySet()) {
                TableColumn tc = (TableColumn)Table.this.tableColumns.get(tcn);
                cols.append(String.valueOf(sep) + tc.getName());
                vars.append(String.valueOf(sep) + "?");
                sep = ",";
            }
            buf.append(cols);
            buf.append(") VARCHAR (");
            buf.append(vars);
            buf.append(")");
            this.ps = c.prepareStatement(buf.toString());
        }

        @Override
        public void writeRow(LinkedHashMap<String, Integer> fieldNames, LinkedHashMap<Integer, Object> values) throws SQLException, IOException {
            int p = 1;
            for (String tcn : Table.this.tableColumns.keySet()) {
                TableColumn tc = (TableColumn)Table.this.tableColumns.get(tcn);
                Integer pos = fieldNames.get(tc.getName());
                Object value = null;
                if (pos != null) {
                    value = values.get(pos);
                }
                if (value == null) {
                    this.ps.setString(p++, null);
                    continue;
                }
                int jType = 12;
                if (value instanceof Integer) {
                    jType = 4;
                } else if (value instanceof Long) {
                    jType = -5;
                } else if (value instanceof Integer) {
                    jType = 4;
                } else if (value instanceof Short) {
                    jType = 5;
                } else if (value instanceof Byte) {
                    jType = -6;
                } else if (value instanceof Boolean) {
                    jType = 16;
                } else if (value instanceof Double) {
                    jType = 8;
                }
                switch (tc.getSqlType().getType()) {
                    case 12: {
                        switch (jType) {
                            case 12: {
                                this.ps.setString(p++, (String)value);
                            }
                        }
                        break;
                    }
                    case -6: {
                        switch (jType) {
                            case -6: {
                                this.ps.setInt(p++, ((Byte)value).byteValue());
                            }
                        }
                        break;
                    }
                    case 5: {
                        switch (jType) {
                            case 5: {
                                this.ps.setShort(p++, (Short)value);
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (jType) {
                            case 4: {
                                this.ps.setInt(p++, (Integer)value);
                            }
                        }
                        break;
                    }
                    case -5: {
                        switch (jType) {
                            case -5: {
                                this.ps.setLong(p++, (Long)value);
                            }
                        }
                        break;
                    }
                    case 8: {
                        switch (jType) {
                            case 8: {
                                this.ps.setDouble(p++, (Double)value);
                            }
                        }
                        break;
                    }
                    default: {
                        this.ps.setString(p++, null);
                    }
                }
            }
            this.ps.execute();
        }

        @Override
        public void close() {
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }
}

