/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.db;

import de.obj.utils.XMLPrintWriter2;
import de.timeglobe.catalog.ForeignKey;
import de.timeglobe.catalog.ForeignKeyColumn;
import de.timeglobe.catalog.IBackupWriter;
import de.timeglobe.catalog.Index;
import de.timeglobe.catalog.IndexColumn;
import de.timeglobe.catalog.PrimaryKeyColumn;
import de.timeglobe.catalog.SqlType;
import de.timeglobe.catalog.Table;
import de.timeglobe.catalog.TableColumn;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;

public class BackupTable
implements IBackupWriter {
    private String name;
    private JarOutputStream target;
    private FileOutputStream xmlTargetFile;
    private XMLPrintWriter2 xw;
    private PrintWriter w;
    private SimpleDateFormat sdfTs = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");

    public BackupTable(String name, XMLPrintWriter2 xw, JarOutputStream target, PrintWriter w) throws IOException {
        this.name = name;
        this.target = target;
        this.xw = xw;
        this.w = w;
        JarEntry entry = new JarEntry(String.valueOf(name) + ".xml");
        entry.setTime(new Date().getTime());
        target.putNextEntry(entry);
    }

    public BackupTable(String name, XMLPrintWriter2 xw, FileOutputStream xmlTargetFile, PrintWriter w) throws IOException {
        this.name = name;
        this.xmlTargetFile = xmlTargetFile;
        this.xw = xw;
        this.w = w;
    }

    @Override
    public void writeMetadata(ResultSetMetaData r) throws SQLException, IOException {
        this.xw.print("<t");
        this.xw.printAttribute("n", this.name);
        this.xw.println(">");
        this.xw.println("<m>");
        int c = 0;
        while (c < r.getColumnCount()) {
            this.xw.print("<d");
            this.xw.printAttribute("p", c + 1);
            this.xw.printAttribute("n", r.getColumnName(c + 1));
            this.xw.println("/>");
            ++c;
        }
        this.xw.println("</m>");
    }

    @Override
    public void writeRow(ResultSet r) throws SQLException, IOException {
        ResultSetMetaData rmd = r.getMetaData();
        this.xw.print("<r>");
        int c = 0;
        while (c < rmd.getColumnCount()) {
            Object v;
            if (rmd.getColumnType(c + 1) == 93) {
                v = r.getTimestamp(c + 1);
                if (v != null) {
                    this.xw.print("<c");
                    this.xw.printAttribute("p", c + 1);
                    this.xw.printAttribute("v", this.sdfTs.format(new Date(((Timestamp)v).getTime())));
                    this.xw.println("/>");
                }
            } else {
                v = r.getString(c + 1);
                if (v != null) {
                    this.xw.print("<c");
                    this.xw.printAttribute("p", c + 1);
                    this.xw.printAttribute("v", v);
                    this.xw.println("/>");
                }
            }
            ++c;
        }
        this.xw.println("</r>");
    }

    public void closeEntry() throws IOException {
        this.xw.print("</t>");
        this.xw.flush();
        this.target.closeEntry();
    }

    @Override
    public void writeTableMetadata(Table t) throws SQLException, IOException {
        this.xw.print("<t");
        this.xw.printAttribute("n", t.getName());
        this.xw.println(">");
        this.xw.println("<m>");
        int c = 1;
        for (String key : t.getTableColumns().keySet()) {
            TableColumn tblCol = t.getTableColumns().get(key);
            SqlType sqlType = tblCol.getSqlType();
            this.xw.print("<d");
            this.xw.printAttribute("p", c);
            this.xw.printAttribute("n", tblCol.getName());
            if (sqlType.getType() == 12) {
                this.xw.printAttribute("t", String.valueOf(sqlType.getType()) + "(" + sqlType.getLength() + ")");
            } else if (sqlType.getType() == 8) {
                this.xw.printAttribute("t", String.valueOf(sqlType.getType()) + "(" + sqlType.getLength() + "," + sqlType.getPrecision() + ")");
            } else {
                this.xw.printAttribute("t", sqlType.getType());
            }
            if (!tblCol.isNullable()) {
                this.xw.printAttribute("nn", 1);
            }
            if (tblCol.isIdentity()) {
                this.xw.printAttribute("ident", 1);
            }
            if (tblCol instanceof PrimaryKeyColumn) {
                this.xw.printAttribute("pk", 1);
            }
            this.xw.println("/>");
            ++c;
        }
        for (String key : t.getIndices().keySet()) {
            Index ind = t.getIndices().get(key);
            this.xw.print("<i");
            this.xw.printAttribute("n", ind.getName());
            if (ind.isUnique()) {
                this.xw.printAttribute("ui", 1);
            }
            this.xw.println(">");
            for (String indColKey : ind.getIndexColumns().keySet()) {
                IndexColumn indCol = ind.getIndexColumns().get(indColKey);
                this.xw.print("<ic");
                this.xw.printAttribute("n", indCol.getName());
                this.xw.printAttribute("sort", indCol.isDescending() ? "desc" : "asc");
                this.xw.println("/>");
            }
            this.xw.println("</i>");
        }
        for (String key : t.getForeignKeys().keySet()) {
            ForeignKey foreignKey = t.getForeignKeys().get(key);
            this.xw.print("<f");
            this.xw.printAttribute("n", foreignKey.getName());
            this.xw.printAttribute("ref", foreignKey.getRefName());
            this.xw.println(">");
            for (String forKeyColKey : foreignKey.getForeignKeyColumns().keySet()) {
                ForeignKeyColumn forKeyCol = foreignKey.getForeignKeyColumns().get(forKeyColKey);
                this.xw.print("<fc");
                this.xw.printAttribute("n", forKeyCol.getName());
                this.xw.printAttribute("ref", forKeyCol.getReferencedName());
                this.xw.println("/>");
            }
            this.xw.println("</f>");
        }
        this.xw.println("</m>");
    }
}

