/*
 * Decompiled with CFR 0.152.
 */
package de.timeglobe.guard.cache;

import de.timeglobe.catalog.Catalog;
import de.timeglobe.catalog.ForeignKey;
import de.timeglobe.catalog.ForeignKeyColumn;
import de.timeglobe.catalog.PrimaryKeyColumn;
import de.timeglobe.catalog.SqlType;
import de.timeglobe.catalog.Table;
import de.timeglobe.catalog.TableColumn;
import de.timeglobe.catalog.XmlCatalog;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import net.obj.transaction.Cache;
import net.obj.transaction.CacheForeignKey;
import net.obj.transaction.CacheTable;
import net.obj.transaction.CacheTableColumn;
import net.obj.transaction.CacheTableIndex;
import net.obj.transaction.TransactException;

public class GuardCache
extends Cache {
    private static final long serialVersionUID = 1L;
    private Catalog catalog;

    public GuardCache() throws TransactException {
        Table t;
        LinkedHashMap<String, Catalog> catalogs;
        InputStream in = null;
        XmlCatalog s = new XmlCatalog();
        in = this.getClass().getResourceAsStream("guard.xml");
        try {
            catalogs = s.parse(in);
        }
        catch (IOException e) {
            throw new TransactException(e);
        }
        this.catalog = catalogs.get("guard");
        String pn = "de.timeglobe.guard.beans";
        Hashtable<String, CacheTable> map = new Hashtable<String, CacheTable>();
        for (String tn : this.catalog.getTables().keySet()) {
            t = this.catalog.getTables().get(tn);
            String b1 = t.getName().toLowerCase();
            String b2 = "";
            if (b1.endsWith("ies")) {
                b1 = b1.substring(0, b1.length() - 3);
                b1 = String.valueOf(b1) + "y";
            } else if (b1.endsWith("xes")) {
                b1 = b1.substring(0, b1.length() - 3);
                b1 = String.valueOf(b1) + "x";
            } else if (b1.endsWith("s")) {
                b1 = b1.substring(0, b1.length() - 1);
            }
            boolean cap = true;
            int i = 0;
            while (i < b1.length()) {
                char c = b1.charAt(i);
                if (c == '_') {
                    cap = true;
                } else if (cap) {
                    b2 = String.valueOf(b2) + Character.toUpperCase(c);
                    cap = false;
                } else {
                    b2 = String.valueOf(b2) + c;
                }
                ++i;
            }
            CacheTable ct = this.addCacheTable(String.valueOf(pn) + "." + b2, t.getName(), false);
            map.put(tn, ct);
            for (String cn : t.getTableColumns().keySet()) {
                TableColumn tc = t.getTableColumn(cn);
                SqlType sqt = tc.getSqlType();
                int options = 0;
                if (tc.isNullable()) {
                    options |= 1;
                }
                if (tc instanceof PrimaryKeyColumn) {
                    options |= 2;
                }
                if (tc.getName().equals("tenant_no")) {
                    options |= 8;
                }
                CacheTableColumn ctc = ct.addCacheTableColumn(cn, sqt.getType(), sqt.getLength(), sqt.getPrecision(), options);
                ctc.setRenderingHints(tc.getRenderingHints());
            }
        }
        for (String tn : this.catalog.getTables().keySet()) {
            t = this.catalog.getTables().get(tn);
            CacheTable ct = (CacheTable)map.get(tn);
            for (String fn : t.getForeignKeys().keySet()) {
                ForeignKey fk = t.getForeignKeys().get(fn);
                CacheForeignKey f1 = ct.addCacheForeignKey(fn, (CacheTable)map.get(fk.getRefName()));
                f1.setReplication(fk.getReplication());
                for (String fcn : fk.getForeignKeyColumns().keySet()) {
                    ForeignKeyColumn fc = fk.getForeignKeyColumns().get(fcn);
                    f1.addForeignKeyColumn(fc.getName(), fc.getReferencedName());
                }
            }
        }
    }

    public void create() {
        Iterator<String> j;
        CacheTable t;
        Iterator<String> i = super.getCacheTables().keySet().iterator();
        while (i.hasNext()) {
            CacheTable cacheTable = super.getCacheTables().get(i.next());
        }
        i = super.getCacheTables().keySet().iterator();
        while (i.hasNext()) {
            t = super.getCacheTables().get(i.next());
            try {
                System.out.println("\"" + t.getCreateSQL(false) + "\"");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        i = super.getCacheTables().keySet().iterator();
        while (i.hasNext()) {
            t = super.getCacheTables().get(i.next());
            j = t.getIndices().keySet().iterator();
            while (j.hasNext()) {
                try {
                    CacheTableIndex ix = t.getIndices().get(j.next());
                    System.out.println(ix.getCreateSQL());
                }
                catch (Exception ix) {
                    // empty catch block
                }
            }
        }
        i = super.getCacheTables().keySet().iterator();
        while (i.hasNext()) {
            t = super.getCacheTables().get(i.next());
            j = t.getForeignKeys().keySet().iterator();
            while (j.hasNext()) {
                try {
                    CacheForeignKey f = t.getForeignKeys().get(j.next());
                    System.out.println(f.getCreateSQL());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        GuardCache guardCache = new GuardCache();
        guardCache.create();
    }

    public Catalog getCatalog() {
        return this.catalog;
    }
}

