/*
 * Decompiled with CFR 0.152.
 */
package net.obj.client;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import net.obj.client.ICacheStore;
import net.obj.client.IObjEventListener;
import net.obj.client.TransactionHandler;
import net.obj.transaction.AsyncTransaction;
import net.obj.transaction.Cache;
import net.obj.transaction.IAsyncResultListener;
import net.obj.transaction.IInputStreamProcessor;
import net.obj.transaction.TDownload;
import net.obj.transaction.TSession;
import net.obj.transaction.TUpload;
import net.obj.transaction.TransactException;
import net.obj.transaction.Transaction;
import net.obj.util.Utils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class HttpObjClient
implements ICacheStore {
    private TransactionHandler transactionHandler = null;
    private TSession session = null;
    private boolean useSwing = false;
    private boolean readOnly = false;
    private String confUrl;
    private String clientName = "HttpObjClient";
    private boolean saveCache = false;
    private CacheThread cacheThread;
    private boolean mainInstance = false;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public HttpObjClient() {
    }

    public HttpObjClient(String appName, Integer clientNo, boolean saveCache, boolean useSwing) {
        this.saveCache = saveCache;
        this.useSwing = useSwing;
        if (clientNo != null) {
            this.cacheThread = new CacheThread(appName, clientNo);
            this.cacheThread.setName("cacheThread." + this.clientName);
            this.cacheThread.start();
        }
    }

    public Serializable execute(String urlString, Transaction t) throws TransactException {
        if (this.session == null) {
            throw new TransactException(13, "not logged in");
        }
        t.setSession(this.session);
        if (t.isClient() && this.transactionHandler != null) {
            return this.transactionHandler.execute(t);
        }
        if (this.readOnly) {
            throw new TransactException(13, "read only");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        HttpClient client = new HttpClient();
        try {
            NameValuePair[] anvp;
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeUnshared(t);
            oout.flush();
            oout.close();
            PostMethod method = new PostMethod(urlString);
            byte[] buf1 = bout.toByteArray();
            if (buf1.length > 1000) {
                anvp = new NameValuePair[3];
                anvp[0] = new NameValuePair();
                anvp[0].setName("func");
                anvp[0].setValue("transact");
                anvp[1] = new NameValuePair();
                anvp[1].setName("comp");
                anvp[1].setValue("1");
                anvp[2] = new NameValuePair();
                anvp[2].setName("transaction");
                ByteArrayOutputStream bout2 = new ByteArrayOutputStream();
                DeflaterOutputStream dout = new DeflaterOutputStream(bout2);
                dout.write(buf1);
                dout.finish();
                dout.flush();
                byte[] buf2 = Base64.encodeBase64(bout2.toByteArray());
                String trans = new String(buf2, "UTF8");
                anvp[2].setValue(trans);
                method.setRequestBody(anvp);
            } else {
                anvp = new NameValuePair[2];
                anvp[0] = new NameValuePair();
                anvp[0].setName("func");
                anvp[0].setValue("transact");
                anvp[1] = new NameValuePair();
                anvp[1].setName("transaction");
                byte[] buf2 = Base64.encodeBase64(buf1);
                String trans = new String(buf2, "UTF8");
                anvp[1].setValue(trans);
                method.setRequestBody(anvp);
            }
            method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
            int statusCode = client.executeMethod(method);
            if (statusCode != 200) {
                throw new TransactException(15, "Status Code " + statusCode);
            }
            ObjectInputStream oin = new ObjectInputStream(method.getResponseBodyAsStream());
            Object o = null;
            o = oin.readUnshared();
            if (o != null) {
                oin.close();
                if (o instanceof Exception) {
                    throw new TransactException(15, (Exception)o);
                }
            }
            return (Serializable)o;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TransactException(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new TransactException(e);
        }
    }

    public void execute(String urlString, AsyncTransaction t, IAsyncResultListener l) throws TransactException {
        if (this.session == null) {
            throw new TransactException(13, "not logged in");
        }
        t.setSession(this.session);
        if (t.isClient() && this.transactionHandler != null) {
            this.transactionHandler.execute(t, l);
        } else {
            if (this.readOnly) {
                throw new TransactException(13, "read only");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            HttpClient client = new HttpClient();
            try {
                ObjectOutputStream oout = new ObjectOutputStream(bout);
                oout.writeUnshared(t);
                oout.flush();
                oout.close();
                PostMethod method = new PostMethod(urlString);
                NameValuePair[] anvp = new NameValuePair[3];
                anvp[0] = new NameValuePair();
                anvp[0].setName("func");
                anvp[0].setValue("async");
                anvp[1] = new NameValuePair();
                anvp[1].setName("transaction");
                anvp[1].setValue(new String(Base64.encodeBase64(bout.toByteArray()), "UTF-8"));
                anvp[2] = new NameValuePair();
                anvp[2].setName("comp");
                anvp[2].setValue("0");
                method.setRequestBody(anvp);
                method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
                int statusCode = client.executeMethod(method);
                if (statusCode != 200) {
                    throw new TransactException(15, "" + statusCode);
                }
                InflaterInputStream iin = new InflaterInputStream(method.getResponseBodyAsStream());
                ObjectInputStream oin = new ObjectInputStream(iin);
                Object o = null;
                while ((o = oin.readUnshared()) != null) {
                    if (o instanceof Exception) {
                        throw new TransactException(15, (Exception)o);
                    }
                    if (l.processResult((Serializable)o)) break;
                }
                oin.close();
                iin.close();
                return;
            }
            catch (EOFException oout) {
            }
            catch (IOException e) {
                throw new TransactException(e);
            }
            catch (ClassNotFoundException e) {
                throw new TransactException(e);
            }
        }
    }

    public void executeDownload(String urlString, File localFile) throws TransactException {
        if (this.readOnly) {
            throw new TransactException(13, "read only");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        HttpClient client = new HttpClient();
        FileOutputStream out = null;
        InputStream in = null;
        boolean ok = false;
        try {
            GetMethod method = new GetMethod(urlString);
            method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
            int statusCode = client.executeMethod(method);
            if (statusCode != 200) {
                throw new TransactException(15, "" + statusCode);
            }
            in = method.getResponseBodyAsStream();
            byte[] buf = new byte[100000];
            int bytes = 0;
            out = new FileOutputStream(localFile);
            while ((bytes = in.read(buf)) > 0) {
                out.write(buf, 0, bytes);
            }
            ok = true;
            return;
        }
        catch (EOFException method) {
        }
        catch (IOException e) {
            throw new TransactException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (!ok) {
                localFile.delete();
            }
        }
    }

    public Serializable executeUpload(String urlString, TUpload transaction, File f) throws TransactException {
        if (this.readOnly) {
            throw new TransactException(13, "read only");
        }
        if (this.session == null) {
            throw new TransactException(13, "not logged in");
        }
        transaction.setSession(this.session);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        HttpClient client = new HttpClient();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeUnshared(transaction);
            oout.flush();
            oout.close();
            PostMethod method = new PostMethod(urlString);
            Part[] parts = new Part[]{new StringPart("transaction", new String(Base64.encodeBase64(bout.toByteArray()), "UTF-8")), new FilePart("file", new FilePartSource(f.getName(), f))};
            method.setRequestEntity(new MultipartRequestEntity(parts, method.getParams()));
            method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
            int statusCode = client.executeMethod(method);
            if (statusCode != 200) {
                throw new TransactException(15, "" + statusCode);
            }
            ObjectInputStream oin = new ObjectInputStream(method.getResponseBodyAsStream());
            Object o = null;
            o = oin.readUnshared();
            if (o != null) {
                oin.close();
                if (o instanceof Exception) {
                    throw new TransactException(15, (Exception)o);
                }
            }
            return (Serializable)o;
        }
        catch (IOException e) {
            throw new TransactException(e);
        }
        catch (ClassNotFoundException e) {
            throw new TransactException(e);
        }
    }

    public void login(IObjEventListener l, String urlString, Integer userType, String userName, String password, String computerName) throws TransactException {
        this.readOnly = false;
        this.logout(urlString);
        HttpClient client = new HttpClient();
        try {
            if (userType == null) {
                throw new TransactException(13, "invalid user type: null");
            }
            if (userName == null) {
                throw new TransactException(13, "invalid user name: null");
            }
            if (password == null) {
                throw new TransactException(13, "invalid password: null");
            }
            String javaVersion = this.getJavaVersion();
            PostMethod method = new PostMethod(urlString);
            NameValuePair[] anvp = new NameValuePair[6];
            anvp[0] = new NameValuePair();
            anvp[0].setName("func");
            anvp[0].setValue("login");
            anvp[1] = new NameValuePair();
            anvp[1].setName("userName");
            anvp[1].setValue(userName);
            anvp[2] = new NameValuePair();
            anvp[2].setName("password");
            anvp[2].setValue(password);
            anvp[3] = new NameValuePair();
            anvp[3].setName("computerName");
            anvp[3].setValue(computerName);
            anvp[4] = new NameValuePair();
            anvp[4].setName("userType");
            anvp[4].setValue("" + userType);
            anvp[5] = new NameValuePair();
            anvp[5].setName("javaVersion");
            anvp[5].setValue(javaVersion == null ? "0.0" : javaVersion);
            method.setRequestBody(anvp);
            method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
            int statusCode = client.executeMethod(method);
            if (statusCode != 200) {
                throw new TransactException(15, "" + statusCode);
            }
            ObjectInputStream oin = new ObjectInputStream(method.getResponseBodyAsStream());
            Object o = oin.readUnshared();
            if (o != null) {
                oin.close();
                if (o instanceof TSession) {
                    TSession tSession = (TSession)o;
                    method = new PostMethod(String.valueOf(urlString) + "?func=notify&sessionId=" + tSession.getSessionId());
                    method.getParams().setParameter("http.socket.timeout", new Integer(20000));
                    method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
                    this.transactionHandler = new TransactionHandler(client, method, l, this, this.useSwing);
                    this.transactionHandler.setName("transactionHandler." + this.clientName);
                    this.transactionHandler.start();
                    this.session = tSession;
                    return;
                }
            }
            throw new TransactException(13, "Login failed");
        }
        catch (HttpException ex) {
            throw new TransactException("", ex);
        }
        catch (IOException ex) {
            throw new TransactException("", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new TransactException("", ex);
        }
    }

    public void login(String urlString, Integer userType, String userName, String password, String computerName) throws TransactException {
        this.readOnly = false;
        this.logout(urlString);
        HttpClient client = new HttpClient();
        try {
            if (userType == null) {
                throw new TransactException(13, "invalid user type: null");
            }
            if (userName == null) {
                throw new TransactException(13, "invalid user name: null");
            }
            if (password == null) {
                throw new TransactException(13, "invalid password: null");
            }
            String javaVersion = this.getJavaVersion();
            PostMethod method = new PostMethod(urlString);
            NameValuePair[] anvp = new NameValuePair[6];
            anvp[0] = new NameValuePair();
            anvp[0].setName("func");
            anvp[0].setValue("login");
            anvp[1] = new NameValuePair();
            anvp[1].setName("userName");
            anvp[1].setValue(userName);
            anvp[2] = new NameValuePair();
            anvp[2].setName("password");
            anvp[2].setValue(password);
            anvp[3] = new NameValuePair();
            anvp[3].setName("computerName");
            anvp[3].setValue(computerName);
            anvp[4] = new NameValuePair();
            anvp[4].setName("userType");
            anvp[4].setValue("" + userType);
            anvp[5] = new NameValuePair();
            anvp[5].setName("javaVersion");
            anvp[5].setValue(javaVersion == null ? "0.0" : javaVersion);
            method.setRequestBody(anvp);
            method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
            int statusCode = client.executeMethod(method);
            if (statusCode != 200) {
                throw new TransactException(15, "" + statusCode);
            }
            ObjectInputStream oin = new ObjectInputStream(method.getResponseBodyAsStream());
            Object o = oin.readUnshared();
            if (o != null) {
                oin.close();
                if (o instanceof TSession) {
                    TSession tSession;
                    this.session = tSession = (TSession)o;
                    return;
                }
            }
            throw new TransactException(13, "Login failed");
        }
        catch (HttpException ex) {
            throw new TransactException("", ex);
        }
        catch (IOException ex) {
            throw new TransactException("", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new TransactException("", ex);
        }
    }

    private String getJavaVersion() {
        Properties p = System.getProperties();
        String s = "";
        try {
            s = System.getProperty("java.version");
        }
        catch (Exception ex) {
            s = String.valueOf(s) + "n/a";
        }
        return s;
    }

    public void logoutMessage(String urlString) {
        if (this.session == null) {
            return;
        }
        HttpClient client = new HttpClient();
        try {
            PostMethod method = new PostMethod(urlString);
            NameValuePair[] anvp = new NameValuePair[2];
            anvp[0] = new NameValuePair();
            anvp[0].setName("func");
            anvp[0].setValue("logout");
            anvp[1] = new NameValuePair();
            anvp[1].setName("sessionId");
            anvp[1].setValue(this.session.getSessionId());
            method.setRequestBody(anvp);
            method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
            client.executeMethod(method);
        }
        catch (HttpException httpException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void logout(String urlString) {
        this.logout(urlString, true);
    }

    public void logout(String urlString, boolean sendLogoutMessage) {
        if (sendLogoutMessage) {
            this.logoutMessage(urlString);
        }
        this.session = null;
        if (this.transactionHandler != null) {
            this.transactionHandler.shutdown();
            this.transactionHandler = null;
        }
    }

    public Integer getUserId() {
        if (this.session != null) {
            return this.session.getUserId();
        }
        return null;
    }

    public Integer getClientNo() {
        if (this.session != null) {
            return this.session.getClientNo();
        }
        return null;
    }

    public boolean isUser(Integer userId) {
        return userId == null ? false : (this.session == null ? false : (this.session.getUserId() == null ? false : this.session.getUserId().intValue() == userId.intValue()));
    }

    public boolean isLoginNm(String loginNm) {
        return loginNm == null ? false : (this.session == null ? false : (this.session.getUserName() == null ? false : this.session.getUserName().equals(loginNm)));
    }

    public boolean isUser(String userName, String password) {
        if (this.session != null) {
            if (!Utils.coalesce(userName, "").equalsIgnoreCase(Utils.coalesce(this.session.getUserName(), ""))) {
                return false;
            }
            return Utils.coalesce(password, "").equals(Utils.coalesce(this.session.getUserPassword(), ""));
        }
        return false;
    }

    public String getComputerName() {
        if (this.session != null) {
            return this.session.getComputerName();
        }
        return null;
    }

    public String encodeDownloadUrl(String urlString, TDownload tDownload) throws TransactException {
        if (this.session == null) {
            throw new TransactException(13, "not logged in");
        }
        tDownload.setSession(this.session);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeUnshared(tDownload);
            oout.flush();
            oout.close();
            String trans = new String(Base64.encodeBase64(bout.toByteArray()), "UTF-8");
            urlString = String.valueOf(urlString) + "?func=down&transaction=" + URLEncoder.encode(trans, "UTF-8");
            return urlString;
        }
        catch (IOException e) {
            throw new TransactException(e);
        }
    }

    public void executeDownload(String urlString, TDownload t, IInputStreamProcessor p) throws TransactException {
        if (this.session == null) {
            throw new TransactException(13, "not logged in");
        }
        t.setSession(this.session);
        if (this.readOnly) {
            throw new TransactException(13, "read only");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        HttpClient client = new HttpClient();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeUnshared(t);
            oout.flush();
            oout.close();
            PostMethod method = new PostMethod(urlString);
            NameValuePair[] anvp = new NameValuePair[2];
            anvp[0] = new NameValuePair();
            anvp[0].setName("func");
            anvp[0].setValue("down");
            anvp[1] = new NameValuePair();
            anvp[1].setName("transaction");
            anvp[1].setValue(new String(Base64.encodeBase64(bout.toByteArray()), "UTF-8"));
            method.setRequestBody(anvp);
            method.getParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
            int statusCode = client.executeMethod(method);
            if (statusCode != 200) {
                throw new TransactException(15, "" + statusCode);
            }
            p.processStream(method.getResponseBodyAsStream());
            return;
        }
        catch (EOFException oout) {
        }
        catch (IOException e) {
            throw new TransactException(e);
        }
    }

    public File getCrsDir(String appName, Integer clientNo) throws TransactException {
        String home = System.getProperty("user.home");
        File f = new File(home);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            throw new TransactException(6, String.valueOf(f.getAbsolutePath()) + " is not a directory");
        }
        String dir = String.valueOf(appName) + "-" + clientNo;
        if (!(f = new File(f, dir)).exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            throw new TransactException(6, String.valueOf(f.getAbsolutePath()) + " is not a directory");
        }
        return f;
    }

    public Cache getCache() {
        return this.transactionHandler.getCache();
    }

    public Date loadVersion(IObjEventListener l, String appName, Integer clientNo, File file, String userName, String password) throws TransactException {
        this.readOnly = true;
        Date key = null;
        if (file == null) {
            TreeMap<Date, File> versions = this.getVersions(appName, clientNo);
            key = versions.lastKey();
            file = versions.get(key);
        } else {
            String s = file.getName().replace('.', '\t');
            String[] as = s.split("\t");
            try {
                long ld = Long.parseLong(as[0]);
                key = new Date(ld);
            }
            catch (NumberFormatException ld) {
                // empty catch block
            }
        }
        if (file == null) {
            throw new TransactException(6, "No backup file for client " + clientNo);
        }
        FileInputStream fi = null;
        InflaterInputStream zi = null;
        ObjectInputStream oi = null;
        CipherInputStream cis = null;
        try {
            try {
                Date now = new Date();
                fi = new FileInputStream(file);
                zi = new InflaterInputStream(fi);
                Cipher c = Cipher.getInstance("DES");
                SecretKeySpec k = new SecretKeySpec("t1mEba7s".getBytes(), "DES");
                c.init(2, k);
                cis = new CipherInputStream(zi, c);
                oi = new ObjectInputStream(cis);
                Object o = oi.readUnshared();
                if (o != null && o instanceof Cache) {
                    Cache cache = (Cache)o;
                    this.transactionHandler = new TransactionHandler(null, null, l, null, this.useSwing);
                    this.transactionHandler.setName("transactionHandler." + this.clientName);
                    TSession s = new TSession();
                    s.setClientNo(clientNo);
                    s.setUserId(new Integer(0));
                    s.setUserName(userName);
                    s.setUserPassword(password);
                    this.session = s;
                    this.transactionHandler.setReadOnlyCache(cache);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (oi != null) {
                    try {
                        oi.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (cis != null) {
                    try {
                        cis.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (zi != null) {
                    try {
                        zi.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                block57: {
                    e.printStackTrace();
                    if (oi == null) break block57;
                    try {
                        oi.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (cis != null) {
                    try {
                        cis.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (zi != null) {
                    try {
                        zi.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (fi != null) {
                    try {
                        fi.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        finally {
            if (oi != null) {
                try {
                    oi.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (cis != null) {
                try {
                    cis.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (zi != null) {
                try {
                    zi.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return key;
    }

    @Override
    public void saveCache(Cache cache, boolean flush) {
        if (!this.readOnly && this.mainInstance && this.getClientNo() != null && cache != null) {
            this.cacheThread.postCache(cache, flush);
        }
    }

    public TreeMap<Date, File> getVersions(String appName, Integer clientNo) throws TransactException {
        TreeMap<Date, File> versions = new TreeMap<Date, File>();
        File crsDir = this.getCrsDir(appName, clientNo);
        File[] af = crsDir.listFiles();
        int i = 0;
        while (i < af.length) {
            if (af[i].isFile() && af[i].getName().endsWith("." + appName)) {
                String s = af[i].getName().replace('.', '\t');
                String[] as = s.split("\t");
                try {
                    long l = Long.parseLong(as[0]);
                    Date d = new Date(l);
                    versions.put(d, af[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return versions;
    }

    public void deleteVersions(String appName, Integer clientNo) throws TransactException {
        TreeMap<Date, File> versions = new TreeMap<Date, File>();
        File crsDir = this.getCrsDir(appName, clientNo);
        File[] af = crsDir.listFiles();
        int i = 0;
        while (i < af.length) {
            if (af[i].isFile() && af[i].getName().endsWith(".crs")) {
                String s = af[i].getName().replace('.', '\t');
                String[] as = s.split("\t");
                try {
                    long l = Long.parseLong(as[0]);
                    Date d = new Date(l);
                    versions.put(d, af[i]);
                }
                catch (NumberFormatException l) {
                    // empty catch block
                }
            }
            ++i;
        }
        int size = versions.size() - 5;
        int pos = 0;
        Iterator i2 = versions.keySet().iterator();
        while (i2.hasNext()) {
            File f = (File)versions.get(i2.next());
            if (pos > size) break;
            ++pos;
            f.delete();
        }
    }

    public boolean lockInstance(String appName, Integer clientNo) {
        this.mainInstance = false;
        try {
            final File file = new File(this.getCrsDir(appName, clientNo), ".lock");
            final RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            final FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock != null) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (HttpObjClient.this.cacheThread != null) {
                            HttpObjClient.this.cacheThread.shutdown();
                            HttpObjClient.this.cacheThread = null;
                        }
                        try {
                            fileLock.release();
                            randomAccessFile.close();
                            file.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                this.mainInstance = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mainInstance;
    }

    public void initReadOnlyCache() {
        this.transactionHandler.initReadOnlyCache();
    }

    public Integer getUiVersion() {
        if (this.session != null) {
            return this.session.getUiVersion();
        }
        return null;
    }

    public void addObjEventListener(IObjEventListener l) {
        if (this.transactionHandler != null) {
            this.transactionHandler.addObjEventListener(l);
        }
    }

    public void addObjEventListenerSwing(IObjEventListener l) {
        if (this.transactionHandler != null) {
            this.transactionHandler.addObjEventListenerSwing(l);
        }
    }

    public void removeObjEventListener(IObjEventListener l) {
        if (this.transactionHandler != null) {
            this.transactionHandler.removeObjEventListener(l);
        }
    }

    @Override
    public boolean isSaveCache() {
        return this.saveCache;
    }

    public String getUrl() {
        return this.confUrl;
    }

    public void setUrl(String url) {
        this.confUrl = url;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    private class CacheThread
    extends Thread {
        private boolean stop = false;
        private Vector<Cache> queue = new Vector();
        private Integer clientNo;
        private String appName;

        public CacheThread(String appName, Integer clientNo) {
            this.appName = appName;
            this.clientNo = clientNo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                File saveFile;
                File tempFile;
                block66: {
                    CipherOutputStream cos;
                    DeflaterOutputStream zo;
                    FileOutputStream fo;
                    block67: {
                        Cache cache = null;
                        Vector<Cache> vector = this.queue;
                        synchronized (vector) {
                            if (this.queue.size() == 0) {
                                try {
                                    this.queue.wait(5000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            if (this.queue.size() > 0) {
                                cache = this.queue.remove(0);
                            }
                        }
                        if (cache == null) continue;
                        fo = null;
                        zo = null;
                        ObjectOutputStream oo = null;
                        cos = null;
                        tempFile = null;
                        saveFile = null;
                        try {
                            Date now = new Date();
                            File crsDir = HttpObjClient.this.getCrsDir(this.appName, this.clientNo);
                            saveFile = new File(crsDir, now.getTime() + ".crs");
                            tempFile = File.createTempFile("crs", "tg", crsDir);
                            fo = new FileOutputStream(tempFile);
                            zo = new DeflaterOutputStream(fo);
                            Cipher c = Cipher.getInstance("DES");
                            SecretKeySpec k = new SecretKeySpec("t1mEba7s".getBytes(), "DES");
                            c.init(1, k);
                            cos = new CipherOutputStream(zo, c);
                            oo = new ObjectOutputStream(cos);
                            long time = System.currentTimeMillis();
                            Cache c2 = null;
                            Cache cache2 = cache;
                            synchronized (cache2) {
                                c2 = (Cache)cache.clone();
                            }
                            oo.writeUnshared(c2);
                            oo.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (oo != null) {
                                try {
                                    oo.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            if (cos != null) {
                                try {
                                    cos.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            if (zo != null) {
                                try {
                                    zo.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            if (fo != null) {
                                try {
                                    fo.close();
                                }
                                catch (IOException ex) {
                                    ex.printStackTrace();
                                }
                            }
                            break block66;
                        }
                        catch (Exception e) {
                            try {
                                e.printStackTrace();
                                break block66;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (oo != null) {
                                    try {
                                        oo.close();
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                if (cos != null) {
                                    try {
                                        cos.close();
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                if (zo != null) {
                                    try {
                                        zo.close();
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                                if (fo != null) {
                                    try {
                                        fo.close();
                                    }
                                    catch (IOException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            }
                        }
                        if (oo == null) break block67;
                        try {
                            oo.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (cos != null) {
                        try {
                            cos.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (zo != null) {
                        try {
                            zo.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (fo != null) {
                        try {
                            fo.close();
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (tempFile != null) {
                    if (saveFile != null) {
                        tempFile.renameTo(saveFile);
                    }
                    if (tempFile.exists()) {
                        tempFile.delete();
                    }
                }
                try {
                    HttpObjClient.this.deleteVersions(this.appName, this.clientNo);
                }
                catch (TransactException e) {
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCache(Cache cache, boolean flush) {
            Vector<Cache> vector = this.queue;
            synchronized (vector) {
                if (this.queue.size() == 0) {
                    this.queue.add(cache);
                    if (flush) {
                        this.queue.notifyAll();
                    }
                } else {
                    this.queue.set(0, cache);
                    if (flush) {
                        this.queue.notifyAll();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.stop = true;
            Vector<Cache> vector = this.queue;
            synchronized (vector) {
                this.queue.notifyAll();
            }
        }
    }
}

